/* viewing.h,v 1.2 1995/04/08 19:51:35 explorer Exp */

/*
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */

#ifndef VIEWING_H
#define VIEWING_H

#include "picture.h"

/*
 * Screen
 */
typedef struct RSScreen {
  int xres, yres;		/* Resolution of entire screen */
  int  xsize, ysize;		/* Resolution of window */
  int  minx, miny, maxx, maxy;	/* Window to be rendered */
  Vector scrnx, scrny;		/* Horizontal & vertical screen axes */
  Vector  scrni, scrnj;		/* Normalized versions of the above */
  Vector  firstray;		/* Direction from eye to screen UL  */
  Color background;		/* Background color */
} RSScreen;

/*
 * Camera
 */
typedef struct {
  Vector pos;			/* Eye position */
  Vector pos_orig;		/* Original eye position if animated */
  Trans *pos_trans;		/* Transformation for eye position */
  Vector lookp;			/* Look position */
  Vector lookp_orig;		/* Original look position if animated */
  Trans *lookp_trans;		/* Transformation for look position */
  Vector dir;			/* Look direction */
  Vector up;			/* 'Up' vector */
  Vector up_orig;		/* Original 'up' vector if animated */
  Trans *up_trans;		/* Transformation for 'up' vector */
  Float hfov, vfov;		/* Horizontal/vertical field of view */
  Float lookdist;		/* Eye pos/look pos distance */
  Float aperture;		/* Aperture width (0 == pinhole) */
  Float focaldist;		/* Distance from eye to focal plane */
} RSCamera;

extern RSScreen Screen;
extern RSCamera Camera;

extern Float PixelSize _PROTO((Ray *, Float));
extern void  RSViewing _PROTO((void));
extern void  ViewingSetup _PROTO((void));
extern void  SampleScreen _PROTO((Float, Float, Ray *, Pixel *, int));
extern void  SampleScreenFiltered _PROTO((Float, Float, int, int, Ray *,
					  Pixel *, int));
extern void  focus_blur_ray _PROTO((Ray *));

#endif				/* VIEWING_H */
