/* nspar.h,v 1.1.1.1 1995/02/27 07:38:46 explorer Exp */

/*
 *
 */

#ifndef NSPAR_H
#define NSPAR_H

/*
 * Get some system-wide configuration options here
 */
#include "libcommon/common.h"

/*
 * This whole file is one big conditional.
 */
#ifdef NSPARALLEL
#include <ctype.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/time.h>           /* struct timeval */
#include "options.h"
#include "stats.h"

#define SERVER_BUFFERS 10    /* max lines each server can be givven */
#define SERVER_PRIO    16    /* auto-renice to this level */

typedef struct NSBuffer {
  uint32 rlen;
  char *r;
  uint32 blen;
  char *b;
  uint32 glen;
  char *g;
  uint32 alen;
  char *a;
  uint32 zlen;
  char *z;
} NSBuffer;

typedef struct NSWorkBuffer {
  uint32 lines;  /* the number of lines this buffer will hold when done */
  uint32 start;  /* the FIRST line this buffer will hold */
  uint32 end;    /* the LAST line this buffer will hold */
  uint32 frame;  /* the frame this buffer applies to */
  struct NSWorkBuffer *next;
  NSBuffer *buf[SERVER_BUFFERS];  /* the line data */
} NSWorkBuffer;

typedef struct NSServer {
  char *name;
  int fd;
  int port;
  struct NSServer *next;
  NSWorkBuffer *work;
} NSServer;

#define OP_NOOP      0  /* we should never get this... */
#define OP_OPTIONS   1  /* options packet */
#define OP_RENDER    2  /* render command */
#define OP_PIC_START 3  /* picture start */
#define OP_PIC_END   4  /* picture end */
#define OP_PIC_LINE  5  /* picture data */
#define OP_TERMINATE 6  /* terminate command */
#define OP_VERSION   7  /* version number packet */

#define NS_PROTOCOL_VERSION 0x00010000  /* currently at this version (1.0) */

/*
 * the network buffer used to communicate between the client and servers.
 * Why so complicated?  Mainly to keep sanity within the protocol
 */
typedef union NSNetBuf {
  uint8  n_whole[1024];
  /*
   * generic buffer, for those commands which have no data to pass
   */
  struct {
    uint16 len;   /* length of this packet, not including the length field */
    uint16 op;    /* opcode, one of OP_* above */
  } data;
  /*
   * version information
   */
  struct {
    uint16 len;   /* length of this packet, not including the length field */
    uint16 op;    /* opcode, OP_VERSION */
    uint32 version;
  } version;
  /*
   * render command
   */
  struct {
    uint16 len;   /* length of this packet, not including the length field */
    uint16 op;    /* opcode, OP_RENDER */
    uint32 frame;  /* frame number */
    uint32 start;  /* starting line number */
    uint32 end;    /* ending line number */
  } render;
  /*
   * picture data
   */
  struct {
    uint16 len;   /* length of this packet, not including the length field */
    uint16 op;    /* opcode, OP_PICTURE_DATA */
    uint32 r;     /* number of bytes for red */
    uint32 g;     /* number of bytes for blue */
    uint32 b;     /* number of bytes for green */
    uint32 a;     /* number of bytes for alpha */
    uint32 z;     /* number of bytes for z buffer contents */
  } pic_line;
} NetBuf;

extern int tcp_open _PROTO((int *, int));
extern int init_servers _PROTO((void));
extern int get_work _PROTO((int, int *, int *, int *));
extern int open_server _PROTO((char *, int));

extern NSBuffer *GetBuffer _PROTO((void));
extern NSWorkBuffer *GetFreeWorkBuffer _PROTO((void));

extern int NetSend _PROTO((int, NetBuf *));
extern int NetSendVersion _PROTO((int, uint32));
extern int NetSendRender _PROTO((int, uint32, uint32, uint32));
extern int NetSendPictureLine _PROTO((int, NSBuffer *));
extern int NetSendPictureStart _PROTO((int));
extern int NetSendPictureEnd _PROTO((int));
extern int NetSendOptions _PROTO((int, RSOptions *));
extern int NetSendTerminate _PROTO((int));

extern int NetReceive _PROTO((int, NetBuf *));
extern int NetReceivePictureLine _PROTO((int, NetBuf *, NSBuffer *));

extern size_t net_write _PROTO((int, voidstar, size_t));
extern size_t net_read _PROTO((int, voidstar, size_t));

/*
 * The list of servers we have made connections to
 */
extern NSServer *Servers;

/*
 * The work buffer lists
 */
extern NSWorkBuffer *WorkBufferFreeList;
extern NSWorkBuffer *WorkBufferWriteList;
extern NSWorkBuffer *WorkBufferPendingList;

#endif /* NSPARALLEL */
#endif /* NSPAR_H */
