/* sky.h,v 1.1.1.1 1995/02/27 07:38:42 explorer Exp */

/*
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */

#ifndef SKY_H
#define SKY_H

#define TextSkyCreate(s,h,l,n,c,t) TextCreate((TextRef)SkyCreate(s,h,l,n,c,t),\
					SkyApply)
typedef struct {
  Float	beta;
  Float	omega;
  Float	lambda;
  Float	scale;
  Float	cthresh;
  Float	lthresh;
  int	octaves;
} Sky;

extern Sky *SkyCreate _PROTO((Float, Float, Float, int, Float, Float));
extern void SkyApply _PROTO((Sky *, Geom *, Ray *, Vector *, Vector *,
			     Vector *, Surface *));

#endif /* SKY_H */
