/* imagetext.h,v 1.1.1.1 1995/02/27 07:38:42 explorer Exp */

/*
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */

#ifndef IMAGETEXT_H
#define IMAGETEXT_H

#define TextImageCreate(s) TextCreate((TextRef)ImageTextCreate(s), \
				ImageTextApply)

typedef struct {
  Image	*image;		/* image to use */
  Surface *surf;	/* Alternative surface */
  int	component;	/* component to texture */
  int   smooth;		/* interpolate pixel values? */
  Float	lo, hi;		/* high and low values in image */
  Float	tileu, tilev;	/* tiling control */
  Mapping *mapping;
} ImageText;

extern ImageText *ImageTextCreate _PROTO((char *));
extern void ImageTextApply _PROTO((ImageText *, Geom *, Ray *,
				   Vector *, Vector *, Vector *, Surface *));
extern void ImageTextSetComponent _PROTO((ImageText *, int));

#endif /* IMAGETEXT_H */
