/* surface.h,v 1.1.1.1 1995/02/27 07:38:40 explorer Exp */

/*
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */

#ifndef SURFACE_H
#define SURFACE_H

#include "libobj/geom.h"

#define DEFAULT_INDEX		1.0	/* Default index of refraction */
#define DEFAULT_PHONGPOW	15.0	/* Default specular highlight exp */

/*
 * Surface definition.
 */
typedef struct Surface {
  char	*name;			/* Name */
  Color	amb;		        /* Ambient 'curve' */
  Color diff;		        /* Diffuse reflection 'curve' */
  Color spec;		        /* Specular reflection 'curve' */
  Color translu;	        /* Diffuse transmission 'curve' */
  Color body;		        /* Specular transmission 'curve' */
  Float	srexp;			/* Specular reflection exponent */
  Float stexp;			/* Specular transmission exponent */
  Float statten;		/* Specular transmission attenuation */
  Float index;			/* Index of refraction */
  Float reflect;		/* Specular reflectivity */
  Float transp;			/* Specular transmittance */
  Float translucency;		/* Diffuse transmittance */ 
  char	noshadow;		/* No shadowing? */
  struct Surface *next;		/* Next surface in list (if any) */
} Surface;

/*
 * Linked list of (linked list of) surfaces.
 */
typedef struct SurfList {
  Surface *surf;
  struct SurfList *next;
} SurfList;

extern Surface	*SurfaceCreate _PROTO((void));
extern Surface	*SurfaceCopy _PROTO((Surface *));
extern void	SurfaceBlend _PROTO((Surface *, Surface *, Float, Float));
extern void     ColorBlend _PROTO((Color *, Color *, Float, Float));

extern SurfList	*SurfPop _PROTO((SurfList *));
extern SurfList *SurfPush  _PROTO((Surface *, SurfList *));

/* application-provided */
extern Surface 	*GetShadingSurf _PROTO((HitList *));

extern int	ComputeSurfProps _PROTO((HitList *, Ray *, Vector *, Vector *,
					 Vector *, Surface *, int *));

#endif /* SURFACE_H */
