/* fogdeck.h,v 1.1.1.1 1995/02/27 07:38:39 explorer Exp */

/*
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */

#ifndef FOGDECK_H
#define FOGDECK_H

#define AtmosFogdeckCreate(z,a,s,p,o,c,t) AtmosCreate( \
		(AtmosRef) FogdeckCreate(z,a,s,p,o,c,t), FogdeckApply)	
typedef struct Fogdeck {
  Float	 alt;	/* Z value below which fogdeck deck exists. */
  Float  offset;
  Float  chaoscale;
  Vector scale;
  Color	 color;		/* Fogdeck color */
  Color  trans;		/* Fogdeck transmissivity */
  int	 octaves;
} Fogdeck;

extern Fogdeck *FogdeckCreate _PROTO((Float, Float, Vector *,
				      Float, int, Color *, Color *));
extern void FogdeckApply _PROTO((Fogdeck *, Ray *, Vector *, Float, Color *));

#endif /* FOGDECK_H */
