/* cylinder.h,v 1.1.1.1 1995/02/27 07:38:32 explorer Exp */

/* 
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */

#ifndef CYLINDER_H
#define CYLINDER_H

#define GeomCylinderCreate(c,a,r) GeomCreate((GeomRef)CylinderCreate(c,a,r), \
					 CylinderMethods())

/*
 * Cylinder
 */
typedef struct cylinder	{
  Trans trans;
} Cylinder;

extern GeomRef  CylinderCreate _PROTO((Float, Vector *, Vector *));
extern Methods	*CylinderMethods METHODS_PROTO;
extern int	CylinderIntersect INTERSECT_PROTO;
extern int      CylinderNormal NORMAL_PROTO;
extern void     CylinderUV UV_PROTO;
extern void	CylinderBounds BOUNDS_PROTO;
extern char	*CylinderName NAME_PROTO;
extern void     CylinderStats STATS_PROTO;
extern void     CylinderMethodRegister _PROTO((UserMethodType));

#endif /* CYLINDER_H */
