/* allocmatrix.c,v 1.1.1.1 1995/02/27 07:38:38 explorer Exp */

/*
 * Matrix allocation and freeing Functions.
 *
 * allocmatrix.c
 *
 * Peter Janssen 
 *
 */
#include <stdlib.h>
#include "geom.h"
#include "allocmatrix.h"


voidstar *allocMatrix(size,  sizeY,  sizeX)
     size_t size, sizeY, sizeX;
{
  voidstar *Matrix, *M;
  size_t   y;
  
  Matrix = (voidstar) share_malloc(sizeY * (sizeof(voidstar)));
  size *= sizeX;
  for (y = sizeY, M = Matrix; y > 0; y--, M++) {
    *M = share_malloc(size);
  }
  return Matrix;
}

void freeMatrix(Matrix, sizeY)
     voidstar *Matrix;
     size_t    sizeY;
{
  voidstar *M;
  
  for ( M = Matrix ; sizeY > 0 ; sizeY-- , M++)
    free(*M);
  free(Matrix);
}
