/* image.h,v 1.1.1.1 1995/02/27 07:38:28 explorer Exp */

/*
 * Copyright (C) 1989, 1991, Rod G. Bogart, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 * 
 */

#ifndef IMAGE_H
#define IMAGE_H

/*
 * Generic image object for texture map storage.
 */
typedef struct Image {
  int	width, height;		/* Image size */
  int	chan, has_alpha;	/* # of channels, has alpha info? */
  int	totalchan;		/* # channels + any alpha channel */
  int	chansize;		/* width * height */
  unsigned char *data;		/* Image */
  char	*filename;		/* Filename (identifier) */
  struct Image *next;		/* Next image in list. */
} Image;

Image *ImageCreate _PROTO((char *));
Image *ImageFind _PROTO((char *));
Image *ImageRead _PROTO((char *));
void   ImageIndex _PROTO((Image *, int, int, Float, Float, int, Float[4]));

#endif /* IMAGE_H */
