/* expr.h,v 1.2 1995/04/08 19:52:56 explorer Exp */

/*
 * Copyright (C) 1989, 1991, Craig E. Kolb, Rod G. Bogart
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 * 
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */

#ifndef EXPR_H
#define EXPR_H

#define FLOAT_EXPR		0
#define BUILTIN_EXPR		1


struct Expr;	/* Forward declaration */

typedef struct AnimVal {
  Float		value;		/* Value at sync point */
  Float		sync;		/* Current sync */
  struct Expr	*mode;		/* How to go to next sync */
  struct AnimVal	*next;	/* Next value in list */
} AnimVal;

typedef struct Expr {
  short	type;			/* Expr type (float/builtin) */
  short	timevary;		/* does the expr vary over time? */
  short	symtab;			/* is the expr in the symtab? */
  short	nparams;		/* # of params, if builtin */
  Float	value;			/* float val/last eval if timeexpr */
  Float	timenow;		/* time of last evaluation */
  Float	(*function)();
  struct Expr **params;		/* parameters, if a builtin */
  AnimVal	*animval;	/* Description for animated variable */
} Expr;

typedef struct ExprAssoc {
  Float *lhs;			/* left-hand side */
  Expr *expr;			/* right-hand side */
  struct ExprAssoc *next;		/* Next in list */
} ExprAssoc;


extern Expr	*ExprFloatCreate _PROTO((Float, int));
extern Expr	*ExprReuseFloatCreate _PROTO((Float));
extern Expr	*ExprAnimCreate _PROTO((AnimVal *));
extern Expr	*ExprFunctionCreate _PROTO((Float (*)(), int, Expr **, int));

extern Float	ExprEval _PROTO((Expr *));

extern Expr	*ExprResolve1 _PROTO((Expr *, 
				      Float (*)(), int));
extern Expr	*ExprResolve2 _PROTO((Expr *, Expr *, 
				      Float (*)(), int));
extern Expr	*ExprResolve3 _PROTO((Expr *, Expr *, Expr *, 
				      Float (*)(), int));
extern Expr	*ExprResolve4 _PROTO((Expr *, Expr *, Expr *, Expr *,
				      Float (*)(), int));
extern Expr	*ExprResolve5 _PROTO((Expr *, Expr *, Expr *, Expr *, Expr *,
				      Float (*)(), int));

extern ExprAssoc *AssocCreate _PROTO((Float *, Expr *, ExprAssoc *));

extern void	TimeSet _PROTO((Float));
extern Float	TimeGet _PROTO((void));
extern void	FrameSet _PROTO((Float));
extern Float	FrameGet _PROTO((void));

extern AnimVal	*AddVal _PROTO((Float, Float, Expr *, AnimVal *));
extern AnimVal	*CheckVal _PROTO((AnimVal *));
extern void	AnimEval _PROTO((Expr *));

extern Expr	*TimeExpr;
extern Expr	*FrameExpr;
extern Expr	*DefaultMode;


#endif /* EXPR_H */
