/**************************************************************************
  Copyright (C) 1992 Guy Moreillon
  All rights reserved.

  This software may be freely copied, modified, and redistributed
  provided that this copyright notice is preserved on all copies.

  You may not distribute this software, in whole or in part, as part of
  any commercial product without the express consent of the authors.

  There is no warranty or other guarantee of fitness of this software
  for any purpose.  It is provided solely "as is".
**************************************************************************/
/**************************************************************************

				RAD
		       (Interactive Radiosity)
		    	    Version 1.0
			       1992		    	    
		    	    
		  
		    	  Guy Moreillon
		    	  
**************************************************************************/

/**************************************************************************
  Fichier	: ioread.c
  Description	: Fonctions utilisees pour la lecture de fichier OFF
**************************************************************************/

#include <stdio.h>
#include <math.h>
#include <assert.h>
#include <string.h>
#include "types.h"
#include "macros.h"
#include "misc.h"
#include "ioread.h"
#include "rad.h"

void get_poly(FILE	*geo,
	      TRIANGLE	*array,
	      int	*cur,
	      VECTOR	*points)
/*****************************************************************************
  But	: Lit un polygone dans le fichier geo, le prepare (le decoupe en
	  triangles) et le met dans le tableau de polygones;
  Entree: geo :	    le fichier
	  array :   le tableau
	  cur :	    l'indice courant dans ce tableau
	  points :  les points;
  Sortie: neant
*****************************************************************************/
{
  int i, j, nv, cur_pol[50];

  fscanf(geo, "%d", &nv);

  if (nv < 3)
    Bye_bye("Polygon has less than 3 corners !!!\n");

  for(i = 0; i < nv; i++)
    fscanf(geo, "%d", &(cur_pol[i]));

  for(i = 1, j = 0; j < nv - 2; i++, j++, (*cur)++)
    init_poly(&(array[*cur]),
	      points[cur_pol[0]-1],
	      points[cur_pol[i]-1],
	      points[cur_pol[i+1]-1]);
}

DATAS *read_geo_file(char *name)
/**************************************************************************
  But	: Lit un fichier de description d'objet (format OFF)
  Entree: name:	nom du fichier
  Sortie: tableau de polygones
**************************************************************************/
{
  int	    i, npt, np, nc, cur;
  VECTOR    *pt;
  DATAS	    *datas;
  FILE	    *geo;
  char	    *gn = (char *)malloc(100);

  if ((name[0] != '/') && (name[0] != '~'))
    {
      strcpy(gn, off_path);
      gn = strcat(gn, "/");
      gn = strcat(gn, name);
    }

  if ((geo = fopen(gn, "r")) == NULL)
    {
      printf("Can't open geo file %s\n", gn);
      free(gn);
      return NULL;
    };

  free(gn);

  if (fscanf(geo, "%d %d %d", &npt, &np, &nc) != 3)
    {
      fclose(geo);
      Bye_bye("Can't read datas in geo file !\n");
    };

  pt = (VECTOR *)malloc(sizeof(VECTOR)*npt);
  assert(pt);
  datas = (DATAS *)malloc(sizeof(DATAS));
  assert(datas);
  datas->size = np + nc - np*3;
  datas->maxr = (datas->size / TRI_BLOCK_SIZE + 1) * TRI_BLOCK_SIZE;
  datas->data = (TRIANGLE *)malloc(sizeof(TRIANGLE)*datas->maxr);
  assert(datas->data);

  for(i = 0; i < npt; i++)
    fscanf(geo, "%f %f %f", &(pt[i][0]), &(pt[i][1]), &(pt[i][2]));

  for(i = 0, cur = 0; i < np; i++)
    get_poly(geo, datas->data, &cur, pt);

  fclose(geo);

  free(pt);

  return datas;
}

