
/*  @(#)vars.c 1.3 93/06/01
 *
 *  Variable handling routines used by popi.
 *
 *  Jeremy Fitzhardinge 1992
 *
 *  Popi was originally written by Gerard J. Holzmann - AT&T Bell Labs.
 *  This version is based on the code in his Prentice Hall book,
 *  "Beyond Photography - the digital darkroom," ISBN 0-13-074410-7,
 *  which is copyright (c) 1988 by Bell Telephone Laboratories, Inc.
 *
 *  Permission is given to distribute these extensions, as long as these
 *  introductory messages are not removed, and no monies are exchanged.
 *
 *  No responsibility is taken for any errors or inaccuracies inherent
 *  either to the comments or the code of this program, but if reported
 *  (see README file) then an attempt will be made to fix them.
 */

#include "popi.h"
#include "expr.h"

#define  STRDUP(x)  (strcpy(alloc(strlen(x) + 1), (x)))

static int lastvar = 0 ;

static struct var vars[NUMVARS] ;

int
allocName(n)
char *n ;
{
  int i ;

  for (i = 0; i < lastvar; i++)
    if (!strcmp(vars[i].n, n))
      {
        vars[i].r++ ;
        return(i) ;
      }

  if (lastvar == NUMVARS-1) run_error(ERR_VAR) ;

  vars[lastvar].n = STRDUP(n) ;
  vars[lastvar].r = 0 ;
  vars[lastvar].slot = lastvar ;

  return(lastvar++) ;
}


void
setvardep(var, dep)
int var, dep ;
{
  findVar(var)->dep = dep ;
}


int
getvardep(var)
int var ;
{
  return(findVar(var)->dep) ;
}


void
valVar(i)
int i ;
{
  findVar(i)->r++ ;
}


void
devalVar(var)
int var ;
{
  findVar(var)->r-- ;
}


void
clearVars()
{
  int i;

  for (i = 0; i < lastvar; i++) vars[i].dep = -1 ;
  lastvar = 0 ;
}


char *
tmpvar()
{
  static int count = 0 ;
  char *buf = alloc(10) ;

  SPRINTF(buf, ".t%04d", count++) ;
  return(buf) ;
}


struct var *
findVar(slot)
int slot ;
{
  int i;

  for (i = 0; i < lastvar; i++)
    if (vars[i].slot == slot)
      return(&vars[i]) ;

  run_error(ERR_NOSLOT) ;
}


static int
cmpref(p1, p2)
struct var *p1, *p2 ;
{
  return(p1->r - p2->r) ;
}


void
allocVars()
{
  if (lastvar > 1)
    qsort(vars, lastvar, sizeof(struct var), cmpref) ;

  allocRegs(vars, lastvar) ;
}
