
/*  @(#)mk.c 1.3 93/06/01
 *
 *  Tree node creation routines used in the popi yacc grammar.
 *
 *  Popi was originally written by Gerard J. Holzmann - AT&T Bell Labs.
 *  This version is based on the code in his Prentice Hall book,
 *  "Beyond Photography - the digital darkroom," ISBN 0-13-074410-7,
 *  which is copyright (c) 1988 by Bell Telephone Laboratories, Inc.
 *
 *  Permission is given to distribute these extensions, as long as these
 *  introductory messages are not removed, and no monies are exchanged.
 *
 *  No responsibility is taken for any errors or inaccuracies inherent
 *  either to the comments or the code of this program, but if reported
 *  (see README file) then an attempt will be made to fix them.
 */

#include <stdarg.h>
#include "popi.h"
#include "expr.h"


Tree *
mk(t, a, b)
enum tree t ;
Tree *a, *b ;
{
  Tree *new = (Tree *) LINT_CAST(treealloc(2)) ;
  new->kids[0] = (void *) a ;
  new->kids[1] = (void *) b ;
  new->t = t ;
  return(new) ;
}


Tree *
treealloc(x)
int x ;
{
  Tree *t;

  t = alloc(offsetof(Tree, kids[x])) ;
  t->siz = x ;
  return(t) ;
}


Tree *
mkInum(i)
int i ;
{
  Tree *new = (Tree *) LINT_CAST(treealloc(0)) ;

  new->i = i ;
  new->t = T_Inum ;
  return(new) ;
}


Tree *
mkFnum(d)
double d ;
{
  Tree *new = (Tree *) LINT_CAST(treealloc(0)) ;

  new->d = d ;
  new->t = T_Fnum ;
  return(new) ;
}


Tree *
mkCoord(file, coord)
int file ;
Tree *coord ;
{
  Tree *new = LINT_CAST(treealloc(1)) ;

  new->i = file ;
  if (!(new->kids[0] = coord)) new->siz = 0 ;
  new->t = T_Coord ;
  return(new) ;
}

 
Tree *
mkMapcoord(file, coord, expr)
int file ;
Tree *coord ;
Tree *expr ;
{
  Tree *new = LINT_CAST(treealloc(2)) ;

  new->i = file ;
  if (!(new->kids[1] = coord)) new->siz-- ;
  new->t = T_Mapcoord ;
  new->kids[0] = expr ;
  return(new) ;
}


Tree *
mkun(t, a)
enum tree t ;
void *a ;
{
  Tree *new = (Tree *) LINT_CAST(treealloc(1)) ;
  new->kids[0] = a ;
  new->t = t ;
  return(new) ;
}


Tree *
mkCond(a, b, c)
Tree *a, *b, *c ;
{
  Tree *new = (Tree *) LINT_CAST(treealloc(3)) ;
  new->kids[0] = (void *) a ;
  new->kids[1] = (void *) b ;
  new->kids[2] = (void *) c ;
  new->t = T_Cond ;
  return(new) ;
}


Tree *
mkempty(t)
enum tree t ;
{
  Tree *new = (Tree *) LINT_CAST(treealloc(0)) ;
  new->t = t ;
  return(new) ;
}


struct builtin builtins[] = {
  { "sin",   T_Sin,     1, NULL   },
  { "cos",   T_Cos,     1, NULL   },
  { "tan",   T_Tan,     1, NULL   },
  { "abs",   T_Abs,     1, NULL   },
  { "sqr",   T_Sqr,     1, NULL   },
  { "sqrt",  T_Sqrt,    1, isqrt  },
  { "rand",  T_Rand,    0, dorand },
  { "atan",  T_Atan,    2, NULL   },
  { "hypot", T_Hypot,   2, NULL   },
  { "log",   T_Log,     1, NULL   },
  { "dist",  T_VRadius, 4, dist   },
  { "angle", T_VAngle,  4, angle  },
} ;

int nbuiltin = NUMEL(builtins) ;

Tree *
mkBuiltin(char *f, int n, ...)
{
  int i ;
  Tree *new ;
  va_list va ;

  for (i = 0; i < nbuiltin; i++)
    if (!strcmp(f, builtins[i].n))
      break ;

  if (i == nbuiltin)
    {
      FPRINTF(stderr, "No such builtin\n") ;
      return(NULL) ;
    }
  if (builtins[i].a != n)
    {
      FPRINTF(stderr, "Wrong number of args for %s()\n", f) ;
      return(NULL) ;
    }
  new = treealloc(n) ;
  new->t = builtins[i].t ;
  va_start(va, n) ;
  for (i = 0; i < n; i++)
    new->kids[i] = va_arg(va, Tree *) ;
  va_end(va) ;
  return(new) ;
}


Tree *
mkAssign(name, val)
char *name ;
Tree *val ;
{
  Tree *t = treealloc(1) ;

  t->t = T_Assign ;
  t->i = allocName(name) ;
  t->kids[0] = val ;
  return(t) ;
}


Tree *
mkVar(n)
char *n ;
{
  Tree *t = treealloc(0) ;

  t->t = T_Var ;
  t->i = allocName(n) ;
  return(t) ;
}


Tree *
mkTop(t1, t2, t3, t4, t5)
Tree *t1, *t2, *t3, *t4, *t5 ;
{
  Tree *new = treealloc(5) ;

  new->t = T_Top ;
  new->kids[0] = t1 ;
  new->kids[1] = t2 ;
  new->kids[2] = t3 ;
  new->kids[3] = t4 ;
  new->kids[4] = t5 ;
  return(new) ;
}
