
/* ****************************************************************** */
/* Function : FirstElmList.c
 * 
 * Author   : J.Paul Schmidt.
 * 
 * Cree le  : 88/04/12 Version  : 1.2
 * 
 * Modifications : 90/01/18 Author   : Reason   :
 * 
 * Implemented functionality : Acces to the first elment of the list.
 * 
 * Input parameters : List identifier. (Ptr to 1st element).
 * 
 * Output parameter : First value in the list. */
/* ****************************************************************** */

#include "ListeP.h"

long FirstElmList (
#if NeedFunctionPrototypes
  Liste s_idlist			/* list to process indentifier */
)
#else
s_idlist)
  Liste s_idlist ;                /* list to process indentifier */
#endif

{
  ty_list *p_firstelem;		/* Pointer to the list to process */

#ifdef debug
  (void) fprintf (stderr, " Function : FirstElmList \n");
#endif

  /* Parameter transformation */
  p_firstelem = (ty_list *) s_idlist;

  Lst_TestPar (p_firstelem, "NULL POINTER AS PARAMETER \n", ERRNU);

  /* Next element acces */
  Lst_TestPar (p_firstelem->p_first, "EMPTY LIST \n", ERRVI);

  p_firstelem->p_cur = p_firstelem->p_first;	/* Update curent element */

#ifdef debug
  (void) fprintf (stderr, " End of : FirstElmList \n");
#endif

  return (p_firstelem->p_first->s_elem);

}				/* End of FirstElmList */
