/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Name : OpenInFile
Type : int
Written on   : 14-Nov-90     By : A. Etemadi
Modified on  :               By : 
Directory    : ~atae/ORT/ORT/LPEG/src/MiscRoutines

==============================================================================

Input parameters    : 
 InFileName	--   Name of Input file 

Output parameters   : 
 p_InFile	--   Pointer to start of data file

Output result       : 
 0 = successful, 
 1 = error

Calling procedure:

 char *InFileName;
 FILE *p_InFile; 

 OpenInFile(InFileName, &p_InFile)

Functionality: 
 Open a file for read access.  On successfull completion this function 
 returns a pointer to the start of the file via p_InFile.

----------------------------------------------------------------------------*/

#include <stdio.h>     /* Standard C I/O library */
#include <math.h>      /* Standard C mathematics library */
#include <errno.h>     /* Standard C error handling routines */
/* #include <strings.h> */   /* Standard C string handling routines */
#include <ctype.h>     /* Standard C type identification routines */

int OpenInFile (InFileName,
		  p_InFile)

       char *InFileName; 	/* Name of input file */
	FILE *(*p_InFile);	/* Pointer to start of file */
     
 { 

#ifdef debug
	  fprintf(stderr," Start of function OpenInFile \n");
#endif

/*
 Open file for reading
*/
	  *p_InFile = fopen(InFileName,"r");

	  if ( (*p_InFile) == NULL) {
             fprintf(stderr," NULL pointer returned when opening file %s \n",InFileName);
             exit(-1);
	  }
	  
	  fseek(*p_InFile,0,0);
         return(0);	  

#ifdef debug
	  fprintf(stderr," End of function OpenInFile \n");
#endif

 }
