/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Name : CreateStringList
Type : int
Written on   : 8-Mar-90     By : A. Etemadi
Modified on  :              By : 
Directory    : ~atae/ORT/FEX/src

==============================================================================

Input parameters    :

 p_InFile 		-- Pointer to data file
 PrintFlag		-- 0 Print String ID, 1 don't print it 

Output parameters   : 

 StringListSize	-- Number of pixels in string
 StringListID		-- ID of Linked List of pixels belonging to string 
 StringList		-- Linked List of pixels belonging to string 

Output Result :

  0  Successful
  1  Error
 -1  EOF

Calling procedure:

 FILE *p_InFile;

 int PrintFlag;
 int StringListSize;

 Liste StringListID;

 struct ORTPoint *StringList;

 CreateStringList( &p_InFile,
	       PrintFlag,
	      &StringListSize,
	      &StringListID,
	      &StringList);

Functionality: 
 
 This function reads the positions of the pixels in the strings produced by the
CreateString program, stores them in a linked list and passes them back.
One string is read at a time (hence the **p_InFile buisness to keep track of
the position in the file).

******************
COORDINATE SYSTEM OF ROSIN'S STRING DATA IS NOT THE SAME AS THE ORT.
	A) ROWS AND COLS SHOULD BE SWAPPED
	B) WE SHOULD CENTER THINGS AT 0,0 BY SUBTACTING HALF THE SIZE OF THE IMAGE
THESE HAVE TO BE CHANGED IF WE USE ANOTHER STRING FINDER INSTEAD OF ROSIN'S
******************
----------------------------------------------------------------------------*/

#include "FEX.h"
#include "LPEG.h"
#include "ListeMacros.h"
#include "Liste.h"

int  CreateStringList( p_InFile,
                 NoOfRows,
		   PrintFlag,
	      	   StringListSize,
	      	   StringListID,
	      	   StringList)

 FILE *(*p_InFile);

 int *NoOfRows;
 int PrintFlag;

 int *StringListSize;

 Liste *StringListID;

 struct ORTPoint *(*StringList);

{

 int flag;
 int Row,Col;

#ifdef debug
          fprintf(stderr," Start of function CreateStringList \n");
#endif

/*
 Read Image dimensions
*/

 fscanf((*p_InFile),"%d\n",NoOfRows);

 if (SkipLines (&(*p_InFile),100,1,PrintFlag) != 0) {
    fprintf(stderr,"Reached the end of the file...\n");
    return(-1);
 }

 *StringListID = CreatList();
 *StringListSize = 0;

 flag = 1;
 while (flag > 0) {

/*
 Allocate some memory for the StringList structure

*/

 *StringList = MACAllocateMem(ORTPoint);

/* 
 Now read a String record 

*/

 flag = fscanf( (*p_InFile), "%4d %4d\n",&Row,&Col);

   if (flag == 0)
       return(1);

   if (flag == EOF)
       return(-1);

   if (Row == -1)
   	return(0);

/* 
******************
COORDINATE SYSTEM OF ROSIN'S STRING DATA IS NOT THE SAME AS THE ORT.
	A) ROWS AND COLS SHOULD BE SWAPPED
	B) WE SHOULD CENTER THINGS AT 0,0 BY SUBTACTING HALF THE SIZE OF THE IMAGE
THESE HAVE TO BE CHANGED IF WE USE ANOTHER STRING FINDER INSTEAD OF ROSIN'S
*****************
*/

	(*StringList)->Col = (double) Row - ((double) (*NoOfRows))/2.0;
	(*StringList)->Row = (double) Col - ((double) (*NoOfRows))/2.0;
/*
 Now add this element to the list

*/
	AddElmList( *StringListID, (long)*StringList ); 
	(*StringListSize)++;

}

#ifdef debug
          fprintf(stderr," End of function CreateStringList \n");
#endif

}

