/*				mpegUtil.h

MpegUtil is an analysis and edit program for MPEG-1 video streams.
    
Copyright (c) Phillip Lougher, March 1995.
    
Permission to use and distribute this software and its documentation is
hereby granted, subject to the provision that all files are distributed
unaltered, and that no profit is made from its distribution.

This software is provided "as is", without any warranty either express or
implied.  In no event shall the author (Phillip Lougher) be liable for
any damages arising out of the use of this software.  The user of this
software assumes all risk as to its quality and accuracy.
*/

/* Constants */
#define BUFF_SIZE 8192
#define MAX_BLOCKS 1024
#define MAX_PICTURES 128
#define INITIAL_DATA 1024
#define GOP_ARRAY_LENGTH 20
#define TRUE 1
#define FALSE 0

/* MPEG start and end codes */
#define EXTENSION_START_CODE 0x000001b5
#define GROUP_START_CODE 0x000001b8
#define SEQUENCE_HEADER_CODE 0x000001b3
#define SEQUENCE_END_CODE 0x00000001b7
#define USER_DATA_START_CODE 0x000001b2
#define PICTURE_START_CODE 0x00000100

/* Picture type codes */
#define I_FRAME 1
#define P_FRAME 2
#define B_FRAME 3
#define D_FRAME 4

#define BYTEALIGNED (cur_bit == 7)

#ifndef unix
#define bcopy(a, b, c) memcpy(b, a, c)
#endif

char aspectRatioMeaning[][40] = {
     "forbidden", "1.000 Square pixels", "0.6735",
     "0.7031 example 16:9, 625 line", "0.7615", "0.8055",
     "0.8437 example 16:9, 525 line", "0.8935",
     "0.9157 example CCIR601, 625 line", "0.9815", "1.0255", "1.0695",
     "1.0950 example CCIR601, 525 line", "1.1575", "1.2015", "reserved"
    };

char pictureRateMeaning[][40] = {
     "Forbidden", "23.976 frames per second", "24 frames per second",
     "25 frames per second", "29.97 frames per second", "30 frames per second",
     "50 frames per second", "59.94 frames per second", "60 frames per second",
     "reserved"
     };

/* Structures for holding picture type information */
typedef struct {
	short int temporal_reference;
	char fragment;
	int mallocedSize;
	int dataSize;
	int picture_size;
	unsigned char bytes[INITIAL_DATA];
	} extraData;

typedef struct {
	char type;
	unsigned char gop;
	char gop_status;
	char deleted;
	extraData *data;
	} pictureInfo;

typedef struct {
	long int pictures;
	long int occurrences;
	} gop_average;
	
#define CLOSED_GOP 1
#define BROKEN_LINK 2
