.TH GLMPEG_PLAY 1

.SH NAME
glmpeg_play - SGI-specific MPEG player based on the Berkeley decoder

.SH SYNOPSIS
.B glmpeg_play
[options] <file>

.SH DESCRIPTION
.I glmpeg_play 
will decode and play MPEG movies with a variety of options.  By
default, glmpeg_play will act much like the Berkeley decoder
(mpeg_play) on which it is based: as each frame is decoded, it is
displayed in the program's window.  When the movie has played once,
the player pauses and starts over after the user "unpauses".  This
results in minimal memory usage, but potentially slow movie playback
(depending on the size of the frames and the speed of your processor,
of course).

However,
.I glmpeg_play
offers a wide range of options to expand on this basic task,
including: user-specified window size with rudimentary movie zooming
(see -zoom and -fullscreen), a variety of playback styles and
directions (see -forward, -backward, and -rock), and buffering to
either disk or memory (see -buffer).  Buffering to memory provides the
biggest speedup, but can also consume huge amounts of memory; for this
reason,
.I glmpeg_play
provides the ability to specify a maximum allowed amount of memory to
allocate (see -maxmemory).  These options are described in detail
below, and you can get a brief summary by running glmpeg_play -help.

.I glmpeg_play
also offers a wide range of interactive controls, some of which
duplicate the functionality of command-line switches, and others which
are only applicable at the time of playback.  In addition to the
detailed descriptions below, a brief summary of available options can
be called up while running
.I glmpeg_play
by hitting `H' in the movie window.

.SH PLAYBACK STYLES AND MODES
.I glmpeg_play
has a variety of ways to play an MPEG movie.  Note that whatever style
and mode you select, glmpeg_play always plays a movie repeatedly; it only
quits when you explicitly tell it to do so (e.g., by hitting Esc or Q).

The first option, the
.B playback style,
controls what directions the movie plays, and in what order.  The
default style is forward: the movie simply plays in the normal
direction.  Also available is the backwards style, in which the movie
simply plays in reverse.  Finally, the "rock" style (as in rocking
back and forth) combines the two by playing forwards, then backwards,
continuously.  Note: the playback style is
.B not
necessarily the same as the current playback direction, although there
some fairly obvious connections.  (That is, the forward style implies
playing forwards, and likewise for the backward style.)  However, the
current direction of the movie can be temporarily changed during
buffered playback so as to override the play style.  See the
"Interactive Control" section below for details.

The two available playback modes are continuous and once-only.  Under
continuous playback, glmpeg_play simply repeats the movie endlessly
without pausing.  Under once-only playback, glmpeg_play pauses between
each playback, at which time the user can either abort the program (by
hitting Esc) or repeat the movie (by hitting Space).  Note that if the
play style is rock, the the play mode is ignored: the movie is
always "rocked" continuously.

Both the playback style and mode can be selected either via
command-line options, or during playback.  Finally, note that the
range of playback options is somewhat restricted if glmpeg_play is in the
process of decoding the movie.  For the full set of features, you must
use buffered playback; see the -buffer option below for details.

.SH COMMAND-LINE OPTIONS
Options can be specified in any order on the command line (although
note that some options override others, so order is significant for
these).  Options can be specified in abbreviated form -- only enough
characters to uniquely identify each one is required.  Also, any of
the options described below can also be supplied in the environment
variable GLMPEG_PLAY_OPTS.  This variable is processed before actual
command-line options, so the command-line can override options from
the environment variable.  (Note that the name of the movie to play is
the command-line argument that cannot be supplied via
GLMPEG_PLAY_OPTS.)

The -help option will give a brief summary of the following options
and exit.  Note that many of the options described here have an
inverse form, e.g. -noforwards or -nodoublebuffer.  The options are
listed here under their positive forms.

.B Buffering Options

Keep in mind when using the buffering options that compression ratios
of 200:1 are not uncommon with MPEG's, and the amount of memory or
disk space that will be consumed by a decoded movie is hard to judge a
priori.  This is the reason that -maxmemory is supplied; also, glmpeg_play
will abort and erase its temporary file if it fills up the temporary
directory.  Note that this may cause momentary problems elsewhere on
your system, so if you are unsure how much space a movie will require,
it is best to play it back unbuffered to see how long and how big the
movie is.  The amount of memory required is simply the number of
frames times the number of pixels per frame (width times height) times
four bytes per pixel.  (The number of frames and frame dimensions can
be read off of the status text when you activate the help window.)

.IP "-buffer {none|disk|memory} (default: none)" 5
A buffer type of "none" results in frames always being displayed immediately as
they are decoded.  Very little control of playback is available when
buffering is disabled: the backward and rock playback styles are ignored,
and single-stepping, fast-forwarding and rewinding are not available.
With either disk or memory buffering, frames are both saved and
displayed as they are decoded; when the entire movie has been decoded,
then
.I glmpeg_play
pauses before playing back the decoded movie from disk or memory.
Note that while the movie is decoding, the same restrictions (i.e.,
only one-frame-at-a-time forward playback is available) apply as for
unbuffered playback.  However, when the movie is in buffered playback,
glmpeg_play's full range of playback options are available.  See the
Interactive Controls section below for more information.

Note that disk buffering is always done to the directory pointed to by
$TMPDIR, or if that doesn't exist to /usr/tmp, or to /tmp.  Make sure
that whatever directory is accessed is on a locally mounted partition
for maximum performance (and to keep network traffic down).  Also see
the -maxmemory option for information on limiting the amount of memory
that
.I glmpeg_play
is allowed to allocate.

Also, only enough characters to uniquely identify the buffering method
are required after either of the -buffer or -fallback options.

.IP "-maxmemory <N>:" 5
This option is only applicable if -buffer memory is used; in fact, if
memory buffering is selected and a -maxmemory argument is not
supplied, glmpeg_play will print a warning.  -maxmemory is used to tell
glmpeg_play when to give up on memory buffering and fall back on another
buffering method (by default, it falls back on no buffering, and
simply plays the movie as though -buffer none had been selected; see
the -fallback option).  In particular,
.I N
is the maximum amount of memory (in megabytes) that glmpeg_play will
allocate before giving up on memory buffering.
Note: because there is apparently no way to determine ahead of time
how long an MPEG movie is,
.I glmpeg_play
actually buffers frames to memory until allocating one more frame
would cause
.I N
megabytes to be allocated.

.IP "-fallback {none|disk} (default: none)" 5
This option determines what glmpeg_play will do when it "runs out" of
memory (i.e., violates the constraint set by -maxmemory).  If
-fallback none is selected, then glmpeg_play will simply continue playing
the movie without saving frames, as though -buffer none had been
selected in the first place.  If -fallback disk is selected, however,
glmpeg_play will create a temporary file (as with disk buffering), write
the already-buffered frames to disk, and carry on decoding, buffering
all subsequent frames on disk.  This behaviour should be transparent
to the user (unless -verbose is supplied on the command line) apart
from the delay to save old frames, and the performance penalty due to
disk buffering.

.IP "-keeptemp (default: -nokeeptemp)" 5
This option is only applicable if disk buffering is used.  If
-keeptemp is specified, then 
.I glmpeg_play
will not delete the temporary file from which it buffers frames; this
is meant primarily for debugging.  (If you do want to make use of it,
for instance to retrieve the individual frames of the movie, the file
will be in the first directory available from $TMPDIR, /usr/tmp, or
/tmp, and the filename will start with MPEG.  The frames are stored
consecutively and in row-major order in the file, with four bytes per
pixel: red, green, blue, and unused.)

.PP
.B Playback Style and Mode Options

.IP "-forward (default)" 5
Specifies the forward style of play, i.e. frames are played in the
normal order only.

.IP "-backward" 5
Selects the backward style of play, i.e. frames are played in reverse
order only.

.IP "-rock" 5
Selects "rocked" playback, where the movie is played forwards, then
backwards, continuously.  (During "rocked" playback, the playback mode
is ignored; the movie is always shown repeatedly without pausing
between playbacks.)

.IP "-onceonly (default) (equivalent to -nocontinuous)" 5
Causes the movie to pause between repetitions of playback.  Has no 
effect during "rocked" play.

.IP "-continuous (default: -nocontinuous)" 5
Causes the movie to repeat playbacks continuously, without pausing.

.PP
.B Window Size Options

.IP "-zoom <zoom_factor> (default: 1.0)" 5
specifies the amount to zoom the movie by.  Note that the zoom
factor may be specified as a floating point number; the full precision
specified will be used to size the window, but the zoom factors will
be truncated to integers when sizing the actual movie frames.  This is
because most current SGI hardware only supports integer zoom factors
(see rectzoom(3G)).  Note also that the zoom factors may be
recalculated on the fly if the window is resized (see "Interactive
Control", below); in this case, the largest possible integer zoom
factor will be used.  

.IP "-fullscreen (default: -nofullscreen)" 5
causes 
.I glmpeg_play
to open a full-screen, borderless window in which to display the
movie.  Like the
.I -zoom
option, this will result in the movie being zoomed by an integer
factor as much as possible and still fit within the window.
.I -nofullscreen
is the default.

.PP
.B Miscellaneous Display Options

.IP "-display <server_name>" 5
.I glmpeg_play
will open a DGL connection to the specified server, and display movies
there.  Note that since whole images will be shoved through the
connection, performance will take a major hit and network traffic will
be greatly increased.  Not recommended for use, but there if you need
it.

.IP "-delay <delay> (default: 3)" 5
specifies the time to delay between frames in hundredths of a second.
Note that this does not take into account the inherent delay in
displaying frames;
.I glmpeg_play
simply pauses (see sginap(2)) for the specified time before displaying
each frame.  This delay is only done if the movie is not being
decoded, i.e. it is being played back from disk or memory buffers.
This delay can be changed on the fly using the up and down arrow keys;
see below in the "Interactive Control" section.

.IP "-doublebuffer (default: -nodoublebuffer)" 5
tells 
.I glmpeg_play
to use double buffering; this is the default.  On some systems,
double buffering may result in images being displayed with only 12-bit
colour; if this is unacceptable, you may wish to use
.I -nodoublebuffer.

.PP
.B Output Options

.IP "-quiet/-verbose" 5
.I -quiet
(the default) causes glmpeg_play to output nothing except in the case
of error.  
.I -verbose
will result in useful information regarding the progress of decoding.

.SH INTERACTIVE CONTROL

While displaying the movie, many keyboard controls are available.  You
can control whether the movie is paused or playing, the current
direction (forwards or backwards), the playback mode (forward,
backward, or rock), the playback mode (continuous or once-only), and
the speed (delay between frames).  Also, you can activate full-screen
mode or double-buffering, resize the window, move to the first or last
frame, and single-step forwards or backwards.  Unfortunately, most of
these features require that the movie frames be buffered.  When
decoding frames, only pausing, double-buffer toggling, and
resizing/full-screen mode are available.

The following keys/mouse buttons control the action:

.IP "Space" 5
pauses or unpauses the movie.  Note that whether the movie is paused
or playing how the left/right arrow keys (or mouse buttons) and the
backspace key behave.

.IP "Left/right arrows (or mouse buttons)" 5
When the movie is playing, these control the direction: left arrow
makes the movie play backwards, and right arrow makes it play forwards
(if the movie is already playing in the specified direction, it does
not change).  The change in direction is only temporary, though; if
the playback style is forward and you override this by hitting the
left-arrow key, the movie will play backwards until it reaches the
first frame, and then resume forwards playback.  To change the
playback style, see 'F', 'B', and 'R'.

When the movie is paused, these cause it to single step in the
specified direction.  Note that, regardless of the direction of
single-stepping, when the movie is "unpaused", the movie will continue
playing in the direction it was previously playing in.  These keys
have no effect if the movie is not buffered.

.IP "Enter" 5
When the movie is paused, this single steps in the current direction.
Pressing Enter when the movie is playing has no effect.

.IP "Backspace" 5
When paused, pressing Backspace single-steps the movie in the opposite
direction.  When playing, Backspace temporarily changes the direction
of play.  Like the Left/Right arrow keys, the change is temporary;
however, Backspace always has an effect, since it toggles the current
direction. 

.IP "Home/End" 5
Home causes the movie to "rewind" to the first frame and pause; End
"fast-forwards" to the last frame and pauses.  

.IP "F, B, R" 5
These change the current playback style, and are equivalent to
(respectively) -forward, -backward, and -rock on the command line.

.IP "O, C" 5
These change the current play mode; O is equivalent to the
command-line option -onceonly, and C is equivalent to -continuous.

.IP "D, S" 5
These switch between double-buffering (D) and single-buffering (S).  
Equivalent to -doublebuffer and -singlebuffer.

.IP "Z or +; X or -" 5
These increase or decrease the current zoom factor of the movie by
one.  You cannot decrease below one, or such that the window
dimensions are greater than the screen dimensions.

.IP "Up/down arrows" 5
Up arrow will speed up the movie (by decreasing the delay between
frames -- see the -delay option above) and down arrow will slow the
movie down.  These keys have no effect if the movie is paused.

.IP "F1" 5
This toggles between full-screen and windowed mode.

.IP "Esc, Q" 5
These will terminate glmpeg_play.

.SH BUGS

Can't determine the size of a movie at the beginning of execution
(need to know more about the MPEG format!)

If run on hardware that supports fractional zoom, only integer zoom
will be used.

Doesn't support any dithering options other than full colour.

Can't single step forwards or rewind in unbuffered mode -- this is not
due to restrictions of MPEG, but laziness on my part.

.SH AUTHOR
Greg Ward, McConnell Brain Imaging Centre, Montreal Neurological
Institute, McGill University (greg@pet.mni.mcgill.ca).  The MPEG
decoding code comes from the Berkeley MPEG decoder (Version 2.0) and
is Copyright (c) 1992 The Regents of the University of California.

.SH VERSION
This man page documents version 1.0 of glmpeg_play, released 22 July
1994.

.SH COPYRIGHT
Copyright \fB\(co\fR\s12 1994 by Gregory P. Ward.  All rights
reserved.  Permission to use, copy, modify, and distribute this
software and its documentation for any purpose, without fee, and
without written agreement is hereby granted, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software and its documentation.
                                                                    
IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT,
INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE AUTHOR HAS
BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
                                                                    
THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS
IS" BASIS, AND THE AUTHOR HAS NO OBLIGATION TO PROVIDE MAINTENANCE,
SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
