/*
 * This file is part of
 * Movietool: display a succession of rasterfile frames in real-time
 *
 * Copyright 1989 by Ole H. Nielsen
 * This software may be distributed freely provided that:
 * 1) this copyright notice is kept intact,
 * 2) you do not try to sell this software for a profit,
 * 3) you provide the full source code.
 *
 * Author: Ole H. Nielsen
 *         Lab of Applied Physics, Bygn. 307
 *         Technical University of Denmark, DK-2800 Lyngby
 *         E-mail: ohnielse@ltf.dth.dk
 */

#include <suntool/sunview.h>

#define ROP PIX_SRC | PIX_DONTCLIP
#define PIXRECT_NULL (struct pixrect *)NULL

/* pr_mag copies a magnified view of spr to dpr using pixel replication  */

struct pixrect *pr_mag (spr, mag)
struct pixrect *spr;	/* source pixrect */
int mag;	 	/* magnification */
{
	register short xmax = spr->pr_size.x, ymax = spr->pr_size.y - 1;
	register short x, y, i, delta;
	register struct pixrect *dpr;

	if (mag < 2 || mag > 10)
		return PIXRECT_NULL;

	if ((dpr = mem_create (xmax*mag, (ymax+1)*mag, spr->pr_depth)) ==
		PIXRECT_NULL)
		return PIXRECT_NULL;

	for (x = 0; x < xmax; x += 1) {
		i = x*mag;
		for (delta = 0; delta < mag; delta += 1, i += 1)
			pr_rop (dpr, i, 0, 1, ymax, ROP, spr, x, 0);
	}
	xmax *= mag;
	for (y = ymax; y >= 0; y -= 1) {
		i = y*mag;
		for (delta = 0; delta < mag; delta += 1, i += 1)
			pr_rop (dpr, 0, i, xmax, 1, ROP, dpr, 0, y);
	}
	return dpr;
}
