/*
 * texttoobj.c - Pull characters out of a Wavefront font file converted
 *               from Adobe postscript by pstoobj producing another
 *               Wavefront object file containing face outlines of the
 *               desired text.
 *
 * Written by:  Wesley C. Barris
 *              AHPCRC
 *              Minnesota Supercomputer Center, Inc.
 * Date:        Dec. 20, 1990
 * Copyright @ 1990, Minnesota Supercomputer Center, Inc.
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 *
 */
#include <stdio.h>
#include <stdlib.h>

main(argc, argv)
int argc;
char **argv;
{
   FILE	*text_fp, *font_fp, *desc_fp, *mod_fp;
   char	text_file[40], font_path[80], desc_path[80], oneline[80], obj_name[40];
   char	*wf_dirP, *cP;
   int	nobjs, i, lineno;
   float	x, y, x1, y1, x2, y2, space, newline;
   float	desc[127-33][4];
   int junk,width;

   if (argc != 4) {
      fprintf(stderr, "Usage: texttoobj text_file object_file font_name\n");
      exit(-1);
      }
   /*if (!getenv("WF_AV_DIR")) {
      fprintf(stderr, "Environment variable: WF_AV_DIR is undefined.\n");
      exit(-1);
      }*/
   strcpy(text_file, argv[1]);
   strcpy(obj_name,  argv[2]);
#ifdef ALTFONTPATH
   /*strcpy(font_path, "your-font-path-here/");*/
   strcpy(font_path, "/usr/tmp/");
#else
   if (!(wf_dirP = getenv("WF_CMD_DIR"))) {
      fprintf(stderr, "Environment variable: WF_CMD_DIR is undefined.\n");
      exit(-1);
      }
   strcpy(font_path, wf_dirP);
   strcat(font_path, "/fonts/");
#endif
/*
 *  Valid fonts are:	compact			similar to helvetica
 *			compact-bold
 *			compact-italic
 *			compact-bolditalic
 *			mono			similar to courier
 *			mono-bold
 *			mono-italic
 *			mono-bolditalic
 *			news			similar to times
 *			news-bold
 *			news-italic
 *			news-bolditalic
 *			greek
 */
   strcat(font_path, argv[3]);
   strcpy(desc_path, font_path);
   strcat(font_path, ".obj");
   strcat(desc_path, ".dsc");
   if (!(text_fp = fopen(text_file, "r"))) {
      fprintf(stderr, "Can't find text file: %s\n", text_file);
      exit(-1);
      }
   if (!(font_fp = fopen(font_path, "r"))) {
      fprintf(stderr, "Can't find font file: %s\n", font_path);
      fprintf(stderr, "Valid fonts are: compact\n");
      fprintf(stderr, "                 compact-bold\n");
      fprintf(stderr, "                 compact-italic\n");
      fprintf(stderr, "                 compact-bolditalic\n");
      fprintf(stderr, "                 mono\n");
      fprintf(stderr, "                 mono-bold\n");
      fprintf(stderr, "                 mono-italic\n");
      fprintf(stderr, "                 mono-bolditalic\n");
      fprintf(stderr, "                 news\n");
      fprintf(stderr, "                 news-bold\n");
      fprintf(stderr, "                 news-italic\n");
      fprintf(stderr, "                 news-bolditalic\n");
      fprintf(stderr, "                 greek\n");
      exit(-1);
      }
   if (!(desc_fp = fopen(desc_path, "r"))) {
      fprintf(stderr, "Can't find font descriptor file: %s\n", desc_path);
      exit(-1);
      }
   fscanf(desc_fp, "%f %f %f %f", &x1, &y1, &x2, &y2);
   newline = (y2-y1)*1.0;
   for (i=0; i<=127-33; i++)
      fscanf(desc_fp, "%f %f %f %f",
                      &desc[i][0], &desc[i][1], &desc[i][2], &desc[i][3]);
   fclose(desc_fp);
   space   = (desc[65-33][2]-desc[65-33][0])*0.1;
   x = 0;
   y = 0;
   if (!(mod_fp = fopen("model_driver", "w"))) {
      fprintf(stderr, "Can't open model driver file: %s\n");
      exit(-1);
      }
   nobjs = 0;
   lineno = 0;
   fprintf(mod_fp, "#!/bin/csh -f\n", font_path);
   fprintf(mod_fp, "model <<! >/dev/null\n");
   fprintf(mod_fp, "ro %s\n", font_path);
   fprintf(mod_fp, "g -a temp\n");
/*
 *  Snoop thru the text file.
 */
   while (fgets(oneline,sizeof(oneline), text_fp) != NULL) {
      if (oneline[0] == '\n') {
/*
 *  I have to ignore blank returns like this because I am passing in
 *  the object file name and this would cause stuff to be clobbered.
 */
/*         fprintf(mod_fp, "gm -r repeat default\n");
         fprintf(mod_fp, "g default\n");
         fprintf(mod_fp, "weld 0.02\n");
         fprintf(mod_fp, "checkdb -f\n");
         fprintf(mod_fp, "cg\n");
         fprintf(mod_fp, "tran -s .2 .2 .2\n");
         fprintf(mod_fp, "setr -me mirror\n");
         fprintf(mod_fp, "setr -ml colors.mtl\n");
         fprintf(mod_fp, "wo -g %s\n", obj_name);
         fprintf(mod_fp, "del -g\n");*/
         y -= newline;
         }
      else {
         fprintf(mod_fp, "g -a line%d\n", ++lineno);
         for (cP=oneline; *cP!='\n'; cP++) {
            if (*cP == ' ')
               x += 5.0*space;
            else {
               if (*cP == '\'')
                  fprintf(mod_fp, "gm squote temp\n");
               else if (*cP == '\"')
                  fprintf(mod_fp, "gm dquote temp\n");
               else if (*cP == ';')
                  fprintf(mod_fp, "gm semi temp\n");
               else if (*cP == '`')
                  fprintf(mod_fp, "gm accent temp\n");
               else if (*cP == '$')
                  fprintf(mod_fp, "gm dollar temp\n");
               else if (*cP == '%')
                  fprintf(mod_fp, "gm percent temp\n");
               else if (*cP == '\\')
                  fprintf(mod_fp, "gm back_slash temp\n");
               else if (*cP == ',')
                  fprintf(mod_fp, "gm comma temp\n");
               else
                  fprintf(mod_fp, "gm %c temp\n", *cP);
               fprintf(mod_fp, "g temp\n");
               fprintf(mod_fp, "rep -t %f %f 0.0\n",
                       x-desc[(int)(*cP)-33][0], y-desc[65-33][1]);
               fprintf(mod_fp, "rg 1\n");
               fprintf(mod_fp, "gm -r repeat1 line%d\n", lineno);
               fprintf(mod_fp, "g -d repeat1\n");  /*get rid of this name*/
               fprintf(mod_fp, "g temp\n");
               fprintf(mod_fp, "delall\n");	/*remove all from temp*/
               x += desc[(int)(*cP)-33][2]-desc[(int)(*cP)-33][0]+space;
               }
            }
            x = 0;
            y -= newline;
            fprintf(mod_fp, "g line%d\n", lineno);
            fprintf(mod_fp, "cg -x\n");
            /*fprintf(mod_fp, "tran -t 0.0 %f 0.0\n", y-desc[65-33][1]);*/
         }
      }
   fprintf(mod_fp, "gm -r repeat default\n");
   fprintf(mod_fp, "g default\n");
   fprintf(mod_fp, "weld 0.02\n");
   fprintf(mod_fp, "checkdb -f\n");
   fprintf(mod_fp, "cg\n");
   fprintf(mod_fp, "tran -s .2 .2 .2\n");
   /*fprintf(mod_fp, "setr -me mirror\n");*/
   /*fprintf(mod_fp, "setr -ml colors.mtl\n");*/
   fprintf(mod_fp, "wo -g %s\n", obj_name);
   fprintf(mod_fp, "!\n");
   fclose(text_fp);
   fclose(font_fp);
   fclose(mod_fp);
   system("chmod 755 model_driver;model_driver;rm model_driver");
   fprintf(stderr, "A Wavefront object file called %s has been created.\n", obj_name);
   /*fprintf(stderr, "Done.  Now type \"sh model_driver\" to create the Wavefront object file.\n");*/
}
