/*
 * texttorle.c - Use display postscript to display text in an off-screen
 *               buffer then copy this text into a Utah rle file to be later
 *               composited on top of another image.
 *
 * Written by:  Wesley C. Barris
 *              AHPCRC
 *              Minnesota Supercomputer Center, Inc.
 * Date:        May 12, 1992
 * Copyright @ 1992, Minnesota Supercomputer Center, Inc.
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 *
 * Usage: texttorle fontname size RRR GGG BBB string
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <malloc.h>
#include <X11/Xlib.h>
#include <gl.h>
#include <PSutils.h>

#define BLKSIZ	80

Display		*display;
unsigned int	maxwidth;
unsigned int	totheight;
unsigned int	totwidth;

/*****************************************************************************/

main(argc, argv)
int argc;
char *argv[];
{

   XImage	*bitmap;
   char		*text, *tP, textbuf[BLKSIZ];
   char		*font;
   float	ptsize, xdpi, ydpi; 
   int		fontheight;
   int		i, nchar, nalloc;
   int		nstr = 0;
   int		spec_char;
   int		justify;
   int		xoffset, yoffset, ymax;
   short	cv[4];
/*
 *  Are there enough arguments?
 */
   if (argc < 6) {
      fprintf(stderr, "Usage: texttorle fontname size RRR GGG BBB string\n");
      fprintf(stderr, "Example: texttorle Times-Roman 40.0 100 255 100 hello\n");
      exit(-1);
      }
   else if (argc == 6) { /* re-directing from a file or here document */
      font = argv[1];
      ptsize = atof(argv[2]);
      if (ptsize < 1.0 || ptsize > 200.0) {
         fprintf(stderr, "Invalid font size: %f\n", ptsize);
         exit(-1);
         }
      nchar = 0;
      while (fgets(textbuf, BLKSIZ, stdin) != NULL) {
         i = strlen(textbuf);
         nchar += i;
         text = (char *)realloc(text, nchar+1);
         tP = text + nchar - i;
         strcpy(tP, textbuf);
         if (i < BLKSIZ - 1)
            nstr++;
         }
      nchar = strlen(text);
      text[nchar-1] = '\0';
      if (!strncmp(text, ".CENTER.", 8)) {
         justify = JUSTIFY_CENTER;
         text = &text[8];
         nstr--;
         }
      else if (!strncmp(text, ".RIGHT.", 7)) {
         justify = JUSTIFY_RIGHT;
         text = &text[7];
         nstr--;
         }
      else if (!strncmp(text, ".LEFT.", 6)) {
         justify = JUSTIFY_LEFT;
         text = &text[6];
         nstr--;
         }
      }
/*                              0          1       2  3   4   5    6   */
   else if (argc == 7) { /* texttorle Times-Roman 30 255 255 255 Hello */
      font = argv[1];
      ptsize = atof(argv[2]);
      if (ptsize < 1.0 || ptsize > 500.0) {
         fprintf(stderr, "Invalid font size: %f\n", ptsize);
         exit(-1);
         }
      nstr++;
      if (argv[6][0] == '.') {
         text = (char *)malloc(2);
         spec_char = atoi(&argv[6][1]);
         text[0] = (char)spec_char;
         text[1] = '\0';
         }
      else {
         nchar = strlen(argv[6]) + 1;
         text = (char *)malloc(nchar);
         strcpy(text, argv[6]);
         }
      }
/*
 * Figure out what color they want.
 */
   cv[0] = atoi(argv[3]);
   cv[1] = atoi(argv[4]);
   cv[2] = atoi(argv[5]);
   cv[3] = 255;
   if (cv[0] < 0 || cv[0] > 255 ||
       cv[1] < 0 || cv[1] > 255 ||
       cv[2] < 0 || cv[2] > 255) {
      fprintf(stderr, "Invalid color value: %d %d %d\n", cv[0], cv[1], cv[2]);
      exit(-1);
      }
/*
 * Get X and Y offsets.
 */
   xdpi = (float)getgdesc(GD_XPMAX)/getgdesc(GD_XMMAX)*25.4 + 1.0;
   ydpi = (float)getgdesc(GD_YPMAX)/getgdesc(GD_YMMAX)*25.4 + 1.0;
   fontheight = ptsize*ydpi/72.0 + 1.0;	/* height based on point size */
   xoffset = 0;
   yoffset = 0;
   ymax = fontheight;
   for (i=0; i<N_EXT_FONTS; i++) {
      if (!(strncmp(font, font_info[i].name, strlen(font)))) {
         xoffset = font_info[i].xmult*ptsize*xdpi/72.0 + 1.0;
         yoffset = font_info[i].lomult*ptsize*ydpi/72.0 + 1.0;
         ymax = font_info[i].himult*ptsize*ydpi/72.0 + 1.0;
         }
      }
/*
 * Determine an image size that seems suitable and start X and DPS.
 */
   maxwidth = 720;			/* max width for Abekas screen */
   totheight = yoffset + (nstr-1)*fontheight + ymax;
   /*fprintf(stderr, "%d %d %d\n", yoffset, fontheight, ymax);*/
   display = XOpenDisplay(NULL);
   psinit(display, maxwidth, totheight);
   psfindfont(font, ptsize);
/*
 * Find the total width of the text.
 */
   psgetblocksize(text, &totwidth, &totheight);
/*
 * Is our window wide enough?
 */
   if (totwidth > maxwidth) {
      psclose();
      psinit(display, totwidth, totheight);
      psfindfont(font, ptsize);
      }
/*
 *  Print all the strings.
 */
   pstexttoctxt(text, justify);
   bitmap = psctxttobitmap();
   psbitmaptorle(bitmap, cv);
   XCloseDisplay(display);
}
