/*
 * file:     textMenu.c
 * author:   Wes Barris
 * date:     9/01/92
 * purpose:  creates Text menu
 *
 * copyright info:
 *
 *    @Copyright 1992
 *    Research Equipment Inc. dba Minnesota Supercomputer Center
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "desi.h"
#include "proto.h"
#include <X11/StringDefs.h>
#include <Xm/CascadeB.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/Separator.h>

extern DESI		desi;

static struct {
   char		*name;			/* name of menu item widget */
   void		(*callbackFcn)(Widget, XtPointer, char*);	/* callback function */
   void		(*initFcn)(Widget);		/* fcn to init client-data */
   } items[] = {
      { NULL,		NULL,		FontMenuInit	},
      { NULL,		NULL,		StyleMenuInit	},
      { NULL,		NULL,		JustifyMenuInit	},
      { NULL,		NULL,		SizeMenuInit	},
      { "color",	ColorPanelCB,	NULL		},
      };

void
TextMenuInit(Widget parent)
{
   int		i, n;
   Arg		arg[10];
   Widget	textMenu, w;

/*
 * Create pulldown menu.
 */
   n = 0;
   textMenu = XmCreatePulldownMenu(parent, "textMenu", arg, n);
/*
 * Create the entries for this menu.
 */
   for (i = 0; i < XtNumber(items); i++)
      if (items[i].name == NULL)
         (items[i].initFcn)(textMenu);
      else {
         w = XmCreatePushButton(textMenu, items[i].name, arg, 0);
         XtAddCallback(w, XmNactivateCallback, (XtCallbackProc)items[i].callbackFcn, (XtPointer)items[i].name);
            /*items[i].callbackFcn, (items[i].initFcn == NULL) ?
            items[i].name : (XtPointer)((items[i].initFcn)()));*/
         XtManageChild(w);
         }
/*
 * Create the cascade button.
 */
   n = 0;
   XtSetArg(arg[n], XmNsubMenuId, textMenu); n++;
   w = XmCreateCascadeButton(parent, "text", arg, n);
   XtManageChild(w);
}
