#include <stdio.h>
#include <gl/gl.h>
/*
 * To compile: cc -o test test.c -lgl_s
 */

short	ul[3] = {255, 0, 0};
short	ur[3] = {0, 255, 0};
short	ll[3] = {0, 0, 255};
short	lr[3] = {255, 255, 0};
short	wsize[2] = {800, 400};
short	vert[2];
short	cv[3];


void
drawleftback()
{
   bgnpolygon();
      c3s(ul);
      vert[0] =  0; vert[1] = wsize[1]-1; v2s(vert);
      c3s(ur);
      vert[0] = wsize[0]/2-1; vert[1] = wsize[1]-1; v2s(vert);
      c3s(lr);
      vert[0] = wsize[0]/2-1; vert[1] =  0; v2s(vert);
      c3s(ll);
      vert[0] = 0; vert[1] =  0; v2s(vert);
   endpolygon();
}


void
drawrightback()
{
   short	leftc[3];
   short	rightc[3];
   short	y;

   for (y = 0; y < wsize[1]; y++) {
      leftc[0] = ll[0] + (ul[0]-ll[0])*(y/(wsize[1]-1.0));
      leftc[1] = ll[1] + (ul[1]-ll[1])*(y/(wsize[1]-1.0));
      leftc[2] = ll[2] + (ul[2]-ll[2])*(y/(wsize[1]-1.0));
      rightc[0] = lr[0] + (ur[0]-lr[0])*(y/(wsize[1]-1.0));
      rightc[1] = lr[1] + (ur[1]-lr[1])*(y/(wsize[1]-1.0));
      rightc[2] = lr[2] + (ur[2]-lr[2])*(y/(wsize[1]-1.0));
      bgnline();
         c3s(leftc);
         vert[0] =  wsize[0]/2; vert[1] = y; v2s(vert);
         c3s(rightc);
         vert[0] = wsize[0]-1; vert[1] = y; v2s(vert);
      endline();
      }
}


void
interp(xc, yc, size)
short	xc, yc, size;
{
   short	xl, xr, yu, yd;
   short	topc, botc;
   short	fractl, fractr;
   short	n;

   xl = xc - size/2;
   xr = xc + size/2;
   yu = yc + size/2;
   yd = yc - size/2;
   fractl = (xl < wsize[0]/2 ? xl : xl - wsize[0]/2);
   fractr = (xr < wsize[0]/2 ? xr : xr - wsize[0]/2);
   bgnpolygon();
/* Upper Left */
      for (n=0; n<=2; n++) {
         topc = fractl/(0.5*wsize[0]) * (ur[n]-ul[n]) + ul[n];
         botc = fractl/(0.5*wsize[0]) * (lr[n]-ll[n]) + ll[n];
         cv[n] = (float)yd/wsize[1] * (botc-topc) + topc;
         }
      c3s(cv);
      vert[0]=xl; vert[1]=yu; v2s(vert);
/* Upper Right */
      for (n=0; n<=2; n++) {
         topc = fractr/(0.5*wsize[0]) * (ur[n]-ul[n]) + ul[n];
         botc = fractr/(0.5*wsize[0]) * (lr[n]-ll[n]) + ll[n];
         cv[n] = (float)yd/wsize[1] * (botc-topc) + topc;
         }
      c3s(cv);
      vert[0]=xr;vert[1]=yu; v2s(vert);
/* Lower Right */
      for (n=0; n<=2; n++) {
         topc = fractr/(0.5*wsize[0]) * (ur[n]-ul[n]) + ul[n];
         botc = fractr/(0.5*wsize[0]) * (lr[n]-ll[n]) + ll[n];
         cv[n] = (float)yu/wsize[1] * (botc-topc) + topc;
         }
      c3s(cv);
      vert[0]=xr;vert[1]=yd;v2s(vert);
/* Lower Left */
      for (n=0; n<=2; n++) {
         topc = fractl/(0.5*wsize[0]) * (ur[n]-ul[n]) + ul[n];
         botc = fractl/(0.5*wsize[0]) * (lr[n]-ll[n]) + ll[n];
         cv[n] = (float)yu/wsize[1] * (botc-topc) + topc;
         }
      c3s(cv);
      vert[0]=xl; vert[1]=yd;v2s(vert);
   endpolygon();
}


main()
{
   char str[10];

   gversion(str);
   fprintf(stderr, "%s\n", str);
   foreground();
   prefsize(wsize[0], wsize[1]);
   winopen("Test window");
   RGBmode();
   gconfig();
   viewport(0, wsize[0]-1, 0, wsize[1]-1);
   ortho2(-0.5, wsize[0]-.5, -0.5, wsize[1]-.5);
   drawleftback();
   drawrightback();
   interp(wsize[0]/4, wsize[1]/2, 100);
   interp(3*wsize[0]/4, wsize[1]/2, 100);
   while (1)
      ;
}
