/*
 * file:     spaceMenu.c
 * author:   Wes Barris
 * date:     3/2/92
 * purpose:  creates Space pull-right menu
 *
 * copyright info:
 *
 *                           @Copyright 1992
 *      Research Equipment Inc. dba Minnesota Supercomputer Center
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "desi.h"
#include <X11/StringDefs.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/CascadeB.h>
#include <Xm/Separator.h>
#include "SelfM/SelfM.h"
#include "Umsc/List.h"

extern DESI	desi;
extern UmscList	theList;

static void
SpaceCB(w, spacement)
Widget	w;
int	spacement;
{
   Arg		args[3];
   GenericInfo	*thisObject;
   int		x, y, sofar;
   int		i, j, n, nselected, totdim, space, toobig;
   typedef struct {
      short	num;
      short	dim;
      short	siz;
      } sortobj;
   sortobj junk, *sarray;
/*
 * Are there any selected objects?  Count them.
 */
   totdim = 0;
   nselected = 0;
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   for (i=0; i<UmscListGetCount(theList); i++) {
      if (thisObject->selected == True) {
         nselected++;
         if (spacement == 1)
            totdim += thisObject->width;
         else
            totdim += thisObject->height;
         }
      thisObject = UmscListGetNext(theList);
      }
   sarray = (sortobj *)malloc(nselected*sizeof(sortobj));
/*
 * Pull out info from these selected objects.
 */
   nselected = 0;
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   for (i=0; i<UmscListGetCount(theList); i++) {
      if (thisObject->selected == True) {
         if (spacement == 1) {
            sarray[nselected].dim = thisObject->x;
            sarray[nselected].siz = thisObject->width;
            sarray[nselected++].num = i;
            }
         else {
            sarray[nselected].dim = thisObject->y;
            sarray[nselected].siz = thisObject->height;
            sarray[nselected++].num = i;
            }
         }
      thisObject = UmscListGetNext(theList);
      }
   if (spacement == 1) {
      if (totdim > desi.back.width) {
         toobig = 1;
         space = (totdim+80 - desi.back.width)/(nselected - 1);
         }
      else {
         toobig = 0;
         space = (desi.back.width - totdim)/(nselected + 1);
         }
      }
   else {
      if (totdim > desi.back.height) {
         toobig = 1;
         space = (totdim+80 - desi.back.height)/(nselected - 1);
         }
      else {
         toobig = 0;
         space = (desi.back.height - totdim)/(nselected + 1);
         }
      }
/*
 * Now sort them based on their X,Y origins.
 */
   for (i=1; i<nselected; i++)
      for (j=1; j<nselected; j++)
         if (sarray[j].dim < sarray[j-1].dim) {
            junk.dim = sarray[j].dim;
            junk.siz = sarray[j].siz;
            junk.num = sarray[j].num;
            sarray[j].dim = sarray[j-1].dim;
            sarray[j].siz = sarray[j-1].siz;
            sarray[j].num = sarray[j-1].num;
            sarray[j-1].dim = junk.dim;
            sarray[j-1].siz = junk.siz;
            sarray[j-1].num = junk.num;
            }
/*
 * Reposition each one of them.
 */
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   for (i=0; i<UmscListGetCount(theList); i++) {
      if (thisObject->selected == True) {
         j = 0;
         sofar = (toobig ? 40 : space);
         while (i != sarray[j].num)
            if (toobig)
               sofar += sarray[j++].siz - space;
            else
               sofar += sarray[j++].siz + space;
         if (spacement == 1) {
            x = desi.back.xoffset + sofar;
            thisObject->x = x;
            n = 0;
            XtSetArg(args[n], XtNxChild, x); n++;
            XtSetValues(XtParent(thisObject->w), args, n);
            }
         else {
            y = desi.back.yoffset + sofar;
            thisObject->y = y;
            n = 0;
            XtSetArg(args[n], XtNyChild, y); n++;
            XtSetValues(XtParent(thisObject->w), args, n);
            }
         }
      thisObject = UmscListGetNext(theList);
      }
}

static struct {
	char	*name;			/* name of menu item widget */
	void	(*func)();		/* callback function */
	int	data;
	} items[] = {
		{ "horizontal",	SpaceCB,	1},
		{ "vertical",	SpaceCB,	2},
		};

void
SpaceMenuInit(Widget parent)
{
   int	i,
		n;
   Arg		arg[10];
   Widget	spaceMenu,
		w;
/*
 * Create the Space menu.
 */
   n = 0;
   spaceMenu = XmCreatePulldownMenu(parent, "spaceMenu", arg, n);
/*
 * Create the entries for the space menu.
 */
   for (i = 0; i < XtNumber(items); i++) {
      if (items[i].name != NULL) {
         w = XmCreatePushButton(spaceMenu, items[i].name, arg, 0);
         XtAddCallback(w, XmNactivateCallback, (XtCallbackProc)items[i].func, (char *)items[i].data);
         }
      else 
         w = XmCreateSeparator(spaceMenu, "sep", arg, 0);
      XtManageChild(w);
      }
/*
 * Create the Space cascade button.
 */
   n = 0;
   XtSetArg(arg[n], XmNsubMenuId, spaceMenu); n++;
   w = XmCreateCascadeButton(parent, "space", arg, n);
   XtManageChild(w);
}
