/*
 * file:     justifyMenu.c
 * author:   Wes Barris
 * date:     9/01/92
 * purpose:  creates Justify menu
 *
 * copyright info:
 *
 *    @Copyright 1992
 *    Research Equipment Inc. dba Minnesota Supercomputer Center
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "desi.h"
#include "proto.h"
#include "PSutils.h"
#include <X11/StringDefs.h>
#include <Xm/CascadeB.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/RowColumn.h>
#include <Xm/ToggleB.h>
#include <Xm/Scale.h>
#include <Xm/Separator.h>
#include "Umsc/List.h"

extern DESI		desi;
extern UmscList		theList;
extern GenericInfo	defaultInfo;
extern TextInfo		selectedText;

Widget	justifyMenu;

static void
SetJustifyCB(w, client_data, call_data)
Widget				w;
int				client_data;
XmToggleButtonCallbackStruct	*call_data;
{
   GenericInfo	*thisObject;
   int		n;
/*
 * Return if the button is unselected or if this event was triggered by
 * calling XmToggleButtonSetState.
 */
   if (!call_data->set || !call_data->event)
      return;
/*
 * Set this for the default and any selected text.
 */
   defaultInfo.u.text.justify = client_data;
   selectedText.justify = client_data;
/*
 * Are there any selected text objects?
 */
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   for (n=0; n<UmscListGetCount(theList); n++) {
      if (thisObject->objtype == TXTOBJ && thisObject->selected == True) {
         thisObject->u.text.justify = selectedText.justify;
         SetShapeMask(thisObject);
         DrawText(thisObject);
         }
      thisObject = UmscListGetNext(theList);
      }
}



static struct {
   char   *name;         /* name of menu item widget */
   void   (*func)();      /* callback function */
   int    data;
   } items[] = {
      { "left",		SetJustifyCB,	JUSTIFY_LEFT	},
      { "center",	SetJustifyCB,	JUSTIFY_CENTER	},
      { "right",	SetJustifyCB,	JUSTIFY_RIGHT	},
      };

static void
SetItemCB(w, client_data, call_data)
Widget			w;
char			*client_data;
XmAnyCallbackStruct	*call_data;
{
   int	i;
/*
 * Set the justify item so that it matches that of the selected text.
 */
   for (i = 0; i < XtNumber(items); i++) {
      if (items[i].data == selectedText.justify) {
         XmToggleButtonSetState(XtNameToWidget(justifyMenu, items[i].name), True, True);
         return;
         }
      else
         XmToggleButtonSetState(XtNameToWidget(justifyMenu, items[i].name), False, False);
      }
}


void
JustifyMenuInit(Widget parent)
{
   int		i, n;
   Arg		arg[10];
   Widget	w;

/*
 * Create pulldown menu.
 */
   n = 0;
   XtSetArg(arg[n], XmNradioBehavior, True); n++;
   justifyMenu = XmCreatePulldownMenu(parent, "justifyMenu", arg, n);
/*
 * Create the entries for the menu.
 */
   for (i = 0; i < XtNumber(items); i++) {
      if (items[i].name != NULL) {
         w = XmCreateToggleButton(justifyMenu, items[i].name, arg, 0);
         XtAddCallback(w, XmNvalueChangedCallback, (XtCallbackProc)items[i].func, (char *)items[i].data);
         }
      else 
         w = XmCreateSeparator(justifyMenu, "sep", arg, 0);
      XtManageChild(w);
      }
/*
 * Create the Style cascade button.
 */
   n = 0;
   XtSetArg(arg[n], XmNsubMenuId, justifyMenu); n++;
   w = XmCreateCascadeButton(parent, "justify", arg, n);
   XtAddCallback(w, XmNcascadingCallback, (XtCallbackProc)SetItemCB, NULL);
   XtManageChild(w);
}
