.so /research/devel/khaos/manual/utils/tmac.manual
.ds f. cantata.man
.J1 2 Cantata
.K1 2 CANTATA "Visual Language Programming Environment" "Mark Young (programming) Carla Williams (doc)"
.K0 CANTATA
.NH 1 "INTRODUCTION"
.XS
\s12\*(SN  INTRODUCTION\s0
.XE
.sp 2
.LP
The purpose in providing a visual language interface to the data processing
programs included in the Khoros library is to increase 
the productivity of researchers and application developers.  
By providing a more natural environment, similar to the block
diagrams that are already familiar to practitioners in the field,
the system provides support to both novice and experienced programmers.
.sp 2
.NH 2 "ABOUT CANTATA"
.XS
      \*(SN  ABOUT CANTATA
.XE
.sp
.LP
\fBCantata\fP is a graphically expressed, data flow oriented language which
provides a visual programming environment within the Khoros system.
Data flow is a "naturally visible" approach in which a program is
described as a directed graph, where each node represents an operator
(or function) and each directed arc represents a path over which
data tokens flow.  In the data-driven model, execution of a node
occurs whenever all its input data tokens are available.  The result
is placed on the node's output arc(s) and flows on to the next node for
processing.  
.PP
In \fBcantata\fP, the nodes represent processing routines from
the Khoros libraries and the tokens represent data to be processed by the nodes.
To create a \fBcantata\fP application, the user selects the desired
programs (and control structures, as needed), places
the corresponding glyph icons on the workspace, and interconnects these
elements to indicate the flow of processing from routine to routine.
The graphical programming elements of the visual language consist of the
workspace \fImaster form\fP and a flow graph based on connected 
\fIglyphs\fP, as described in the following sections.
.sp 2
.NH 2 "CANTATA MASTER FORM"
.XS
      \*(SN  CANTATA MASTER FORM
.XE
.sp
.so /research/devel/khaos/doc/cantata/master_help/manual/Overview
.sp 2
.NH 1 "PROGRAM SUBFORMS"
.XS
\s12\*(SN  PROGRAM SUBFORMS\s0
.XE
.sp 2
.so /research/devel/khaos/doc/cantata/master_help/manual/Subforms
.sp 2
.NH 2 "SUBFORM USAGE"
.XS
      \*(SN  SUBFORM USAGE
.XE
.sp
.so /research/devel/khaos/doc/cantata/subforms/Forms/manual/Usage
.sp 2
.NH 3 "Subform Guide Pane"
.XS
              \*(SN  Subform Guide Pane
.XE
.sp
.so /research/devel/khaos/doc/cantata/subforms/Forms/manual/guide
.sp 2
.NH 3 "Setting Program Parameters"
.XS
              \*(SN  Setting Program Parameters
.XE
.sp
.so /research/devel/khaos/doc/cantata/subforms/Forms/manual/pane
.sp 2
.NH 3 "Subform Glyph Button"
.XS
              \*(SN  Subform Glyph Button
.XE
.sp
.so /research/devel/khaos/doc/cantata/subforms/Forms/manual/glyph
.sp 2
.NH 2 "USING CANTATA TO CONSTRUCT A VISUAL PROGRAM"
.XS
      \*(SN  USING CANTATA TO CONSTRUCT A VISUAL PROGRAM
.XE
.sp
.so /research/devel/khaos/doc/cantata/master_help/manual/Usage
.sp 3
.NH 1 "MASTER ACTION BUTTONS"
.XS
\s12\*(SN  MASTER ACTION BUTTONS\s0
.XE
.sp 2
.LP
The action buttons on the master form provide the basic operations needed for
the creation of and execution of processing flow graphs.
.sp 2
.NH 2 "ROUTINES MASTER ACTION BUTTON"
.XS
      \*(SN  ROUTINES MASTER ACTION BUTTON
.XE
.sp
.so /research/devel/khaos/doc/cantata/master_help/manual/routines
.sp 2
.NH 2 "RUN AND RESET MASTER ACTION BUTTON"
.XS
      \*(SN  RUN AND RESET MASTER ACTION BUTTON
.XE
.sp
.so /research/devel/khaos/doc/cantata/master_help/manual/run
.sp 2
.NH 2 "QUIT MASTER ACTION BUTTON"
.XS
      \*(SN  QUIT MASTER ACTION BUTTON
.XE
.sp
.so /research/devel/khaos/doc/cantata/master_help/manual/quit
.sp 2
.NH 2 "MASTER FORM GLYPH BUTTON"
.XS
      \*(SN  MASTER FORM GLYPH BUTTON
.XE
.sp
.so /research/devel/khaos/doc/cantata/master_help/manual/glyph
.sp 2
.NH 2 "TUTORIAL: CREATING A CANTATA PROGRAM"
.XS
      \*(SN  TUTORIAL: CREATING A CANTATA PROGRAM
.XE
.sp
.so /research/devel/khaos/doc/cantata/master_help/manual/tutorial
.sp 3
.NH 1 "INTERACTION SUBFORMS"
.XS
\s12\*(SN  INTERACTION SUBFORMS\s0
.XE
.sp 2
.LP
Interaction subform buttons are located on the top-left and left side 
of the \fBcantata\fP
master form (as opposed to the program subform menu buttons which
are located along the top of the master form).  Clicking the mouse on a
subform button, such as `Variables', brings up the corresponding subform.  
Clicking the mouse on a subform menu button, such as `Edit' or `Workspace', 
pops up 
a drop down menu of selections that can be immediate actions or subform
actions.
The following section may be skipped initially, as it contains the information
needed for more advanced \fBcantata\fP programming.
.sp 2
.NH 2 "WORKSPACE ATTRIBUTES AND UTILITIES"
.XS
      \*(SN  WORKSPACE ATTRIBUTES AND UTILITIES
.XE
.sp
.so /research/devel/khaos/doc/cantata/workspace/manual/Overview
.sp 2
.NH 3 "List Cache Files"
.XS
              \*(SN  List Cache Files
.XE
.sp
.so /research/devel/khaos/doc/cantata/workspace/manual/list_cache
.sp 2
.NH 3 "Saving Temporary Files"
.XS
              \*(SN  Saving Temporary Files
.XE
.sp
.so /research/devel/khaos/doc/cantata/workspace/manual/save_files
.sp 2
.NH 3 "Workspace File Utilities"
.XS
              \*(SN  Workspace File Utilities
.XE
.sp
.so /research/devel/khaos/doc/cantata/workspace/file_utils/manual/Overview
.LP
.so /research/devel/khaos/doc/cantata/workspace/file_utils/manual/temp_files
.sp 2
.NH 3 "Setting Workspace Attributes"
.XS
              \*(SN  Setting Workspace Attributes
.XE
.sp
.so /research/devel/khaos/doc/cantata/workspace/attributes/manual/Overview
.sp 2
.NH 3 "Setting Workspace Attributes via Xdefaults"
.XS
              \*(SN  Setting Workspace Attributes via Xdefaults
.XE
.sp
.so /research/devel/khaos/doc/cantata/workspace/attributes/manual/xdefaults
.sp 2
.NH 3 "Khoros Data Cache"
.XS
              \*(SN  Khoros Data Cache
.XE
.sp
.so /research/devel/khaos/doc/cantata/workspace/attributes/manual/cache
.sp 2
.NH 2 "DEFINE VARIABLES / EVALUATE EXPRESSIONS"
.XS
      \*(SN  DEFINE VARIABLES / EVALUATE EXPRESSIONS
.XE
.sp
.so /research/devel/khaos/doc/cantata/variables/manual/Overview
.SH
DEFINING VARIABLES
.so /research/devel/khaos/doc/cantata/variables/manual/Usage
.sp 2
.NH 3 "Arithmetic Operators"
.XS
              \*(SN  Arithmetic Operators
.XE
.sp
.so /research/devel/khaos/doc/cantata/variables/manual/operators
.sp 2
.NH 3 "Logical Operators"
.XS
              \*(SN  Logical Operators
.XE
.sp
.so /research/devel/khaos/doc/cantata/variables/manual/logicals
.sp 2
.NH 3 "Predefined Constants"
.XS
              \*(SN  Predefined Constants
.XE
.sp
.so /research/devel/khaos/doc/cantata/variables/manual/constants
.sp 2
.NH 3 "Functions"
.XS
              \*(SN  Functions
.XE
.sp
.so /research/devel/khaos/doc/cantata/variables/manual/functions
.sp 3
.NH 2 "PROGRAM FLOW CONTROL"
.XS
      \*(SN  PROGRAM FLOW CONTROL
.XE
.sp
.so /research/devel/khaos/doc/cantata/control/manual/Overview
.sp 2
.NH 3 "COUNT-LOOP Control Structure"
.XS
              \*(SN  COUNT-LOOP Control Structure
.XE
.sp
.so /research/devel/khaos/doc/cantata/control/count_loop/manual/Count_Loop
.sp
.SH
COUNT-LOOP EXAMPLES
.so /research/devel/khaos/doc/cantata/control/count_loop/manual/loop_examples
.sp
.NH 3 "WHILE-LOOP Control Structure"
.XS
              \*(SN  WHILE-LOOP Control Structure
.XE
.sp
.so /research/devel/khaos/doc/cantata/control/while_loop/manual/While_Loop
.sp
.SH
WHILE-LOOP EXAMPLES
.so /research/devel/khaos/doc/cantata/control/while_loop/manual/loop_examples
.sp
.NH 3 "IF-THEN-ELSE Control Structure"
.XS
              \*(SN  IF-THEN-ELSE Control Structure
.XE
.sp
.so /research/devel/khaos/doc/cantata/control/if_else/manual/If_Then_Else
.sp
.SH
IF-THEN-ELSE EXAMPLES
.so /research/devel/khaos/doc/cantata/control/if_else/manual/If_examples
.sp
.NH 3 "MERGE Control Structure"
.XS
              \*(SN  MERGE Control Structure
.XE
.sp
.so /research/devel/khaos/doc/cantata/control/merge/manual/merge
.bp
.sp 3
.NH 1 "AVAILABLE ROUTINES"
.XS
\s12\*(SN  AVAILABLE ROUTINES\s0
.XE
.sp 2
.LP
The following sections give an overview of the data processing
programs currently available on each of the Program Subforms 
within \fBcantata\fP.
.sp 2
.NH 2 "INPUT SOURCES Menu"
.XS
      \*(SN  INPUT SOURCES Menu
.XE
.sp 2
.NH 3 "Input Data Files"
.XS
              \*(SN  Input Data Files
.XE
.so /research/devel/khaos/doc/cantata/subforms/input_file/manual/Overview
.sp 2
.NH 3 "Create Image (2D)"
.XS
              \*(SN  Create Image (2D)
.XE
.so /research/devel/khaos/doc/cantata/subforms/inputcreate2D/manual/Overview
.sp 2
.NH 3 "Create Signal (1D)"
.XS
              \*(SN  Create Signal (1D)
.XE
.so /research/devel/khaos/doc/cantata/subforms/inputcreate1D/manual/Overview
.sp 2
.NH 2 "OUTPUT Menu"
.XS
      \*(SN  OUTPUT Menu
.XE
.sp 2
.NH 3 "Information about Data"
.XS
              \*(SN  Information
.XE
.so /research/devel/khaos/doc/cantata/subforms/info/manual/Overview
.sp 2
.NH 3 "Display Images"
.XS
              \*(SN  Display Images
.XE
.so /research/devel/khaos/doc/cantata/subforms/outputdisplay/manual/Overview
.sp 2
.NH 3 "Plot Data"
.XS
              \*(SN  Plot Data
.XE
.so /research/devel/khaos/doc/cantata/subforms/output_plot/manual/Overview
.sp 2
.NH 3 "Print Images"
.XS
              \*(SN  Print Images
.XE
.so /research/devel/khaos/doc/cantata/subforms/output_print/manual/Overview
.sp 2
.NH 3 "Dither"
.XS
              \*(SN  Dither
.XE
.so /research/devel/khaos/doc/cantata/subforms/output_dither/manual/Overview
.sp 2
.NH 2 "CONVERSIONS Menu"
.XS
      \*(SN  CONVERSIONS Menu
.XE
.sp 2
.NH 3 "Data Structure and Type Conversion"
.XS
              \*(SN  Data Structure and Type Conversion
.XE
.so /research/devel/khaos/doc/cantata/subforms/convert_data/manual/Overview
.sp 2
.NH 3 "Standard File Formats"
.XS
              \*(SN  Standard File Formats
.XE
.so /research/devel/khaos/doc/cantata/subforms/stndrd_format/manual/Overview
.sp 2
.NH 3 "Remote Sensing and GIS File Formats"
.XS
              \*(SN  Remote Sensing and GIS File Formats
.XE
.so /research/devel/khaos/doc/cantata/subforms/gis_format/manual/Overview
.sp 2
.NH 3 "Raw File Formats"
.XS
              \*(SN  Raw File Formats
.XE
.so /research/devel/khaos/doc/cantata/subforms/no_format/manual/Overview
.sp 2
.NH 3 "Color Transformations"
.XS
              \*(SN  Color Transformations
.XE
.so /research/devel/khaos/doc/cantata/subforms/convert_color/manual/Overview
.sp 2
.NH 3 "Maps and LUTs"
.XS
              \*(SN  Maps and LUTs
.XE
.so /research/devel/khaos/doc/cantata/subforms/map/manual/Overview
.sp 2
.NH 3 "Compress"
.XS
              \*(SN  Compress
.XE
.so /research/devel/khaos/doc/cantata/subforms/convert_compr/manual/Overview
.sp 2
.NH 2 "ARITHMETIC Menu"
.XS
      \*(SN  ARITHMETIC Menu
.XE
.sp 2
.NH 3 "Unary Arithmetic"
.XS
              \*(SN  Unary Arithmetic
.XE
.so /research/devel/khaos/doc/cantata/subforms/arith_unary/manual/Overview
.sp 2
.NH 3 "Binary Arithmetic"
.XS
              \*(SN  Binary Arithmetic
.XE
.so /research/devel/khaos/doc/cantata/subforms/arith_binary/manual/Overview
.sp 2
.NH 3 "Logical Operations"
.XS
              \*(SN  Logical Operations
.XE
.so /research/devel/khaos/doc/cantata/subforms/arith_logical/manual/Overview
.sp 2
.NH 3 "Matrix Algebra"
.XS
              \*(SN  Matrix Algebra
.XE
.so /research/devel/khaos/doc/cantata/subforms/matrixalgebra/manual/Overview
.sp 2
.NH 2 "IMAGE PROCESSING Menu"
.XS
      \*(SN  IMAGE PROCESSING Menu
.XE
.sp 2
.NH 3 "2D Spatial Domain Filters"
.XS
              \*(SN  2D Spatial Domain Filters
.XE
.so /research/devel/khaos/doc/cantata/subforms/filter2Dspatl/manual/Overview
.sp 2
.NH 3 "Morphological Operations"
.XS
              \*(SN  Morphological Operations
.XE
.so /research/devel/khaos/doc/cantata/subforms/filter_morph/manual/Overview
.sp 2
.NH 3 "2D Transforms"
.XS
              \*(SN  2D Transforms
.XE
.so /research/devel/khaos/doc/cantata/subforms/transform2D/manual/Overview
.sp 2
.NH 3 "2D Frequency Domain Filters"
.XS
              \*(SN  2D Frequency Domain Filters
.XE
.so /research/devel/khaos/doc/cantata/subforms/filter_2Dfreq/manual/Overview
.sp 2
.NH 3 "Histograms"
.XS
              \*(SN  Histograms
.XE
.so /research/devel/khaos/doc/cantata/subforms/histogram/manual/Overview
.sp 2
.NH 3 "Geometric Manipulations"
.XS
              \*(SN  Geometric Manipulations
.XE
.so /research/devel/khaos/doc/cantata/subforms/geomanip/manual/Overview
.sp 2
.NH 3 "Subimage/Subsignal Operations"
.XS
              \*(SN  Subimage/Subsignal Operations
.XE
.so /research/devel/khaos/doc/cantata/subforms/subregion/manual/Overview
.sp 2
.NH 2 "SIGNAL ANALYSIS Menu"
.XS
      \*(SN  SIGNAL ANALYSIS Menu
.XE
.sp 2
.NH 3 "Segmentation"
.XS
              \*(SN  Segmentation  
.XE
.so /research/devel/khaos/doc/cantata/subforms/segment/manual/Overview
.sp 2
.NH 3 "Feature Extraction"
.XS
              \*(SN  Feature Extraction
.XE
.so /research/devel/khaos/doc/cantata/subforms/feature/manual/Overview
.sp 2
.NH 3 "Classification/Clustering Algorithms"
.XS
              \*(SN  Classification/Clustering Algorithms
.XE
.so /research/devel/khaos/doc/cantata/subforms/classify/manual/Overview
.sp 2
.NH 2 "SIGNAL PROCESSING Menu"
.XS
      \*(SN  SIGNAL PROCESSING Menu
.XE
.sp 2
.NH 3 "Modify 1D Sequences"
.XS
              \*(SN  Modify 1D Sequences
.XE
.so /research/devel/khaos/doc/cantata/subforms/modify_seq1D/manual/Overview
.sp 2
.NH 3 "1D Transforms"
.XS
              \*(SN  1D Transforms
.XE
.so /research/devel/khaos/doc/cantata/subforms/transform1D/manual/Overview
.sp 2
.NH 3 "1D Time Domain Filters"
.XS
              \*(SN  1D Time Domain Filters
.XE
.so /research/devel/khaos/doc/cantata/subforms/filter_1Dtime/manual/Overview
.sp 2
.NH 3 "1D Frequency Domain Filters"
.XS
              \*(SN  1D Frequency Domain Filters
.XE
.so /research/devel/khaos/doc/cantata/subforms/filter_1Dfreq/manual/Overview
.sp 2
.NH 3 "1D Linear Operations"
.XS
              \*(SN  1D Linear Operations
.XE
.so /research/devel/khaos/doc/cantata/subforms/linearop1D/manual/Overview
.sp 2
.NH 3 "Spectral Estimation"
.XS
              \*(SN  Spectral Estimation
.XE
.so /research/devel/khaos/doc/cantata/subforms/spectest1D/manual/Overview
.sp 2
.NH 2 "CONTRIBUTED Menu"
.XS
      \*(SN  CONTRIBUTED Menu
.XE
.so /research/devel/khaos/doc/cantata/subforms/contrib/manual/Overview
.sp 2
.NH 3 "Contributed (Example)"
.XS
              \*(SN  Contributed (Example)
.XE
.so /research/devel/khaos/doc/cantata/subforms/contrib/manual/contrib
.sp 2
.NH 2 "REMOTE & GIS Menu"
.XS
      \*(SN  REMOTE & GIS Menu
.XE
.sp 2
.NH 3 "Image Warping"
.XS
              \*(SN  Image Warping
.XE
.so /research/devel/khaos/doc/cantata/subforms/gis_warp/manual/Overview
.sp 2
.NH 3 "Surface Manipulation"
.XS
              \*(SN  Surface Manipulation Menu
.XE
.so /research/devel/khaos/doc/cantata/subforms/gis_surface/manual/Overview
.sp 2
.NH 3 "GIS Vector Data"
.XS
              \*(SN  GIS Vector Data Menu
.XE
.so /research/devel/khaos/doc/cantata/subforms/gis_vector/manual/Overview

.TC 2 CANTATA
