/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lSimg2viff.c
 >>>>
 >>>>      Program Name: Simg2viff
 >>>>
 >>>> Date Last Updated: Mon Apr 15 22:24:59 1991 
 >>>>
 >>>>          Routines: lSimg2viff - the library call for Simg2viff
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lSimg2viff - library call for Simg2viff
*
* Purpose:
*    
*    Conversion from GE Signa Magnet Image to VIFF format
*    
*    
* Input:
*    
*    file           (int) File descriptor of the file in which the raw
*                   data is located.
*    
*    nrows          (int) number of rows
*    
*    ncols          (int) number of columns
*    
*    header_offset  The header offset indicates the  number  of  bytes
*                   dedicated  to  header information before the image
*                   data starts.  The specified number  of  bytes  are
*                   skipped when converting to VIFF format.
*    
*    type           (unsigned long) This variable indicaties the  data
*                   type     of     the    raw    input    file.     -
*                   man3_long_description_end
*    
*    
* Output:
*    
*    image          (struct xvimage) Pointer to resulting VIFF image.
*    
*    
*
* Written By: Donna Koechner
*    
*    Audit Done  06-OCT-90  Donna Koechner
*    
*    
****************************************************************/


/* -library_def */
int
lSimg2viff(file, image, nrows, ncols, header_offset, type)
struct xvimage  **image;
int             nrows, ncols, header_offset;
unsigned long   type;
int             file;
/* -library_def_end */

/* -library_code */
{
  int                   img_size, num_pts, conv_to_float;
  struct xvimage        *img, *createimage();
  char                  *data, *read_raw_mag();

 /*
  * Calculate image data size.
  */
  img_size = nrows * ncols;
  
 /*
  * Read in the raw signa image.
  */
  
  conv_to_float = 0;    /* do not convert output type to VFF_TYP_FLOAT */

  if (!(data = read_raw_mag(file, header_offset, &num_pts, type, conv_to_float)))
  {
    return(0);
  }

  if ( num_pts < img_size )
  {
    (void)fprintf(stderr,"\nOut of bounds! Number of requested rows and \
columns is greater than \nthe number of points found in the data file.\n\
Number of points is %d. (Number of rows = %d Number of columns = %d.)\n\n", 
num_pts, nrows, ncols);
    return(0);
  }

 /*
  * Create the VIFF image.
  */
  img = createimage( (unsigned long) nrows,             /* number of rows */
                     (unsigned long) ncols,             /* number of columns */
                     (unsigned long) type,              /* data_storage_type */
                     (unsigned long) 1,                 /* number_of_images */
                     (unsigned long) 1,                 /* num_data_bands */
                     "created by Simg2viff",            /* comment */
                     (unsigned long) 0,                 /* map_row_size */
                     (unsigned long) 0,                 /* map_col_size */
                     (unsigned long) VFF_MS_NONE,       /* map_scheme */
                     (unsigned long) VFF_MAPTYP_NONE,   /* map_storage_type */
                     (unsigned long) VFF_LOC_IMPLICIT,  /* location_type */
                     (unsigned long) 0);        /* dimension */
 
  img->imagedata = data;
  *image = img;
  if ( img == NULL )
  { 
    (void)fprintf(stderr,"lSimg2viff: Unable to allocate new image!\n");
    return(0);
   }
  return (1);
}
/* -library_code_end */
