/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vringint.c
 >>>>
 >>>>      Program Name: vringint
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Compute ring integrals
 >>>>	
 >>>>	
 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Mon Apr 15 22:17:05 1991
 >>>>
 >>>>          Routines: main- the main program for vringint
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vringint.h"


/****************************************************************
 *
 * Routine Name:  main program for vringint
 *
 *       Input:  
 *          -i  input image 
 *          -o  resulting output image 
 *
 *
 *          [-x] X coordinate of ring center 
 *          [-y] Y coordinate of ring center 
 *          [-rmin] minimum ring radius  (value >= 0.0)
 *          [-rmax] maximum ring radius  (value > 0.0)
 *          [-step] step interval between rings  (value > 0.0)
 *          [-ang] angular step interval in degrees  (value > 0.0)
 *          [-t] line integral (0) or ring integral (1)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image,*covimage,*readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);
        image = readimage(vringint->i_file);
        if (image == NULL) exit(1);
        CHECKINPUT(program, image);
/* -main_before_lib_call_end */

/* -main_library_call */
    if(! lvringint(image,vringint->x_float,vringint->y_float,
                         vringint->rmin_float,vringint->rmax_float,
                         vringint->step_float,vringint->ang_float,
                         vringint->t_logic) )
    {
        (void) fprintf(stderr, "lvringint Failed\n");
        exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(vringint->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vringint 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vringint :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCompute ring integrals\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-x]  X coordinate of ring center (float) [255.5]\n");
	fprintf(stderr,"\t[-y]  Y coordinate of ring center (float) [255.5]\n");
	fprintf(stderr,"\t[-rmin]  minimum ring radius (float, >= 0.0) [0]\n");
	fprintf(stderr,"\t[-rmax]  maximum ring radius (float, > 0.0) [255]\n");
	fprintf(stderr,"\t[-step]  step interval between rings (float, > 0.0) [1]\n");
	fprintf(stderr,"\t[-ang]  angular step interval in degrees (float, > 0.0) [0.5]\n");
	fprintf(stderr,"\t[-t]  line integral (0) or ring integral (1) (boolean) [false]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vringint\n");
	fprintf(stderr, "\t[-U] Gives the usage for vringint\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vringint.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vringint.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vringint
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*x_pstr = 
	"\nEnter: (x) X coordinate of ring center \n        {float [255.500000] }: "; 
char	*y_pstr = 
	"\nEnter: (y) Y coordinate of ring center \n        {float [255.500000] }: "; 
char	*rmin_pstr = 
	"\nEnter: (rmin) minimum ring radius \n        {float, >= 0.0 [0.000000] }: "; 
char	*rmax_pstr = 
	"\nEnter: (rmax) maximum ring radius \n        {float, > 0.0 [255.000000] }: "; 
char	*step_pstr = 
	"\nEnter: (step) step interval between rings \n        {float, > 0.0 [1.000000] }: "; 
char	*ang_pstr = 
	"\nEnter: (ang) angular step interval in degrees \n        {float, > 0.0 [0.500000] }: "; 
char	*t_pstr = 
	"\nEnter: (t) line integral (0) or ring integral (1) \n        {boolean, (y/n)  [no] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vringint", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vringint.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vringint: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vringint.ans");
		}

	     }

	}

	/*
	 * allocate the vringint structure
	 */
	vringint = (vringint_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vringint_struct));

	/*
	 * get required arguments for vringint
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vringint->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vringint->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vringint->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vringint->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vringint->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vringint->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vringint->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vringint->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vringint->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vringint->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vringint
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vringint->x_flag = vget_float(fid, prompt_flag,
	"-x", x_pstr, &(vringint->x_float),
	255.500000, 0.000000, 0.000000);

	vringint->y_flag = vget_float(fid, prompt_flag,
	"-y", y_pstr, &(vringint->y_float),
	255.500000, 0.000000, 0.000000);

	vringint->rmin_flag = vget_float(fid, prompt_flag,
	"-rmin", rmin_pstr, &(vringint->rmin_float),
	0.000000, 1.000000, 1.000000);

	vringint->rmax_flag = vget_float(fid, prompt_flag,
	"-rmax", rmax_pstr, &(vringint->rmax_float),
	255.000000, 2.000000, 2.000000);

	vringint->step_flag = vget_float(fid, prompt_flag,
	"-step", step_pstr, &(vringint->step_float),
	1.000000, 2.000000, 2.000000);

	vringint->ang_flag = vget_float(fid, prompt_flag,
	"-ang", ang_pstr, &(vringint->ang_float),
	0.500000, 2.000000, 2.000000);

	vringint->t_flag = vget_logic(fid, prompt_flag,
	"-t", t_pstr, &(vringint->t_logic), 0);


}



