/******************************************************************************
* Symb_err.c - handler for all symb library fatal errors.		      *
*******************************************************************************
* Written by Gershon Elber, May. 91.					      *
******************************************************************************/

#include "symb_loc.h"

typedef struct SymbErrorStruct {
    SymbFatalErrorType ErrorNum;
    char *ErrorDesc;
} SymbErrorStruct;

static SymbErrorStruct ErrMsgs[] =
{
    { SYMB_ERR_WRONG_SRF,		"Provided surface type is wrong" },
    { SYMB_ERR_BZR_CRV_EXPECT,		"Bezier curve is expected" },
    { SYMB_ERR_BZR_SRF_EXPECT,		"Bezier surface is expected" },
    { SYMB_ERR_BSP_CRV_EXPECT,		"Bspline curve is expected" },
    { SYMB_ERR_BSP_SRF_EXPECT,		"Bspline surface is expected" },
    { SYMB_ERR_RATIONAL_EXPECTED,	"Rational Crv/Srf expected." },
    { SYMB_ERR_NO_CROSS_PROD,		"No cross product for scalar surface" },
    { SYMB_ERR_POWER_NO_SUPPORT,	"Power basis type is not supported" },
    { SYMB_ERR_CRV_FAIL_CMPT,		"Cannot make curves compatible" },
    { SYMB_ERR_SRF_FAIL_CMPT,		"Cannot make surfaces compatible" },
    { SYMB_ERR_UNDEF_CRV,		"Undefined curve type" },
    { SYMB_ERR_UNDEF_SRF,		"Undefined surface type" },
    { SYMB_ERR_UNDEF_GEOM,		"Undefined geometry type" },
    { SYMB_ERR_OUT_OF_RANGE,		"Data is out of range." },
    { SYMB_ERR_DIR_NOT_CONST_UV,	"Dir is not one of CONST_U/V_DIR" },
    { SYMB_ERR_REPARAM_NOT_MONOTONE,	"Reparametrization is not monotone" },
    { SYMB_ERR_BSPLINE_NO_SUPPORT,	"Bspline basis type is not supported" },
    { SYMB_ERR_WRONG_PT_TYPE,		"Provided point type is wrong" },
    { SYMB_ERR_ONLY_2D_OR_3D,		"Only two or three dimensions are supported" },
    { SYMB_ERR_RATIONAL_NO_SUPPORT,	"Rational function is not supported" },
    { SYMB_ERR_SRFS_INCOMPATIBLE,	"Surfaces for requested operation are incompatible" },
    { SYMB_ERR_CRVS_INCOMPATIBLE,	"Curves for requested operation are incompatible" },
    { SYMB_ERR_CANNOT_COMP_NORMAL,	"Cannot compute normal" },
    { SYMB_ERR_TOO_COMPLEX,		"Too complex" },
    { SYMB_ERR_UNSUPPORT_PT,		"Unsupported point type" },
    { SYMB_ERR_W_NOT_SAME,		"Weights are not identical" },
    { SYMB_ERR_SCALAR_EXPECTED,		"Scalar entity expected" },
    { SYMB_ERR_POLY_CONST_SRF,		"Constant surfaces cannot be converted to polygons" },

    { SYMB_ERR_UNDEFINE_ERR,	NULL }
};

/*****************************************************************************
* DESCRIPTION:                                                               M
* Returns a string describing a the given error. Errors can be raised by     M
* any member of this symb library as well as other users. Raised error will  M
* cause an invokation of SymbFatalError function which decides how to handle M
* this error. SymbFatalError can for example, invoke this routine with the   M
* error type, print the appropriate message and quit the program.            M
*                                                                            *
* PARAMETERS:                                                                M
*   ErrorNum:   Type of the error that was raised.                           M
*                                                                            *
* RETURN VALUE:                                                              M
*   char *:     A string describing the error type.                          M
*                                                                            *
* KEYWORDS:                                                                  M
*   SymbDescribeError, error handling                                        M
*****************************************************************************/
char *SymbDescribeError(SymbFatalErrorType ErrorNum)
{
    int i = 0;

    for ( ; ErrMsgs[i].ErrorDesc != NULL; i++)
	if (ErrorNum == ErrMsgs[i].ErrorNum)
	    return ErrMsgs[i].ErrorDesc;

    return "Undefined error";
}
