#
# The XXX_DIR variables below MUST have ABSOLUTE path. Since this file
# is sourced from several directories relative path specification will
# be simple wrong.
#

SRC_DIR = Work:T/irit5b

#
# All libraries created will be installed into the LIB_DIR directory.
#
LIB_DIR = $(SRC_DIR)/lib

#
# All includes files associated with the installed libraries will be
# installed into the INC_DIR directory.
#
INC_DIR = $(SRC_DIR)/include

#
# All binaries created will be installed into the BIN_DIR directory.
#
BIN_DIR = $(SRC_DIR)/bin

#
# Location of object file to resolve circularities in libraries.
#
CIRCLINK = $(SRC_DIR)/circlink/circlink.o

#
# Uncomment the correct set of variables to be used or modify it for
# your system.
#
# -D flags:
#
# -D__GL__ - if your system supports gl graphics library (SGI 4d & IBM R6000).
#
# -D__X11__ - if your system supports X11. Only one of __GL__ or __X11__ should
#	be used.
#
#  Emulation to the following function are available by defining the
#  following. Look at misc_lib/xgeneral.c/h for implementation.
# -DGETCWD - if getcwd is not defined in this system.
# -DSTRSTR - if strstr is not defined in this system.
# -DSTRDUP - if strdup is not defined in this system.
# -DSTRICMP - if stricmp and strincmp are not defined in this system.
#
# -DTIMES - if times is defined in your system, otherwise uses time.
#
# -DRAND - if the (s)rand random number generator exists.
# -DRAND48 - ?rand48 random number generators exists.
#	If non of RAND or RAND48 are defined, (s)random is used.
#
# -DUSLEEP - if usleep is defined in the system.
# -DSGINAP - on sgi systems instead of usleep.
#
# -DNO_VOID_PTR - if your C compiler does not support (void *).
#
# -DUSE_VARARGS - if your system does not have stdarg.h and have the old
#	varargs.h.
#
# -DNO_CONCAT_STR - if 'char *p = "This is" "one string";' is illegal.
#
# -DGRAPDRVS - any combination of of 'xgldrvs', 'xgladap', 'x11drvs'.
#
# -DMAKE_REAL_FLOAT - force real number to be float and not double.
#               Expect problems as it is not really tested.
#
# Other, possibly useful defines (for c code development):
#
# -DDEBUG - for some debugging functions in the code (that can be invoked
#		from a debugger).
#

#
# Flags for Amiga using gcc
#
CC = sc
DFLAGS = DEFINE=RAND48 DEFINE=USLEEP DEFINE=GRAPDRVS=amidrvs
CPUFLAGS = CPU=68040 MATH=68882
CFLAGS = NOSTACKCHECK STRMERGE DATA=FAR CODE=FAR $(DFLAGS) $(CPUFLAGS)
MATHLIB = LIB:scm881.lib
SYMS = ND
MORELIBS = 

#
# Default rule for compilation.
#
.c.o:
	$(CC) $(CFLAGS) IDIR= IDIR=$(INC_DIR) IDIR=$(SRC_DIR)/amigalib $<

#
# All libraries.
#
LIBS = $(CIRCLINK) $(LIB_DIR)/bool.lib $(LIB_DIR)/geom.lib\
$(LIB_DIR)/prsr.lib $(LIB_DIR)/trim.lib $(LIB_DIR)/triv.lib\
$(LIB_DIR)/symb.lib $(LIB_DIR)/cagd.lib $(LIB_DIR)/misc.lib\
$(LIB_DIR)/xtra.lib $(LIB_DIR)/amg.lib #$(LIB_DIR)/gif.lib
