/*****************************************************************************
*   "Irit" - the 3d (not only polygonal) solid modeller.		     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
*   Module to provide the required interfact for the cagd library for the    *
* free form surfaces and curves.					     *
*****************************************************************************/

#ifndef FREEFORM_H
#define FREEFORM_H

CagdRType *GetKnotVector(IPObjectStruct *KntObjList,
			 int Order,
			 int *Length,
			 char **ErrStr);
int GetDrawCtlPt(void);
int GetFourPerFlat(void);
int GetPolyApproxOptimal(void);
int GetPolyApproxUV(void);
RealType GetPolyApproxTol(void);
IPObjectStruct *GenBezierSurfaceObject(IPObjectStruct *LstObjList);
IPObjectStruct *GenBezierCurveObject(IPObjectStruct *PtObjList);
IPObjectStruct *GenBsplineSurfaceObject(RealType *UOrder,
					RealType *VOrder,
					IPObjectStruct *LstObjList,
					IPObjectStruct *KntObjList);
IPObjectStruct *GenBsplineCurveObject(RealType *ROrder,
				      IPObjectStruct *PtObjList,
				      IPObjectStruct *KntObjList);
IPObjectStruct *GenSURFPREVObject(IPObjectStruct *Cross);
IPObjectStruct *DivideSurfaceObject(IPObjectStruct *SrfObj,
				    RealType *Dir,
				    RealType *ParamVal);
IPObjectStruct *RegionFromSurfaceObject(IPObjectStruct *SrfObj,
					RealType *RDir,
					RealType *ParamVal1,
					RealType *ParamVal2);
IPObjectStruct *DivideCurveObject(IPObjectStruct *CrvObj, RealType *ParamVal);
IPObjectStruct *RegionFromCurveObject(IPObjectStruct *CrvObj,
				      RealType *ParamVal1,
				      RealType *ParamVal2);
IPObjectStruct *RefineSurfaceObject(IPObjectStruct *SrfObj,
				    RealType *Dir,
				    RealType *Replace,
				    IPObjectStruct *KnotsObj);
IPObjectStruct *RefineCurveObject(IPObjectStruct *CrvObj,
				  RealType *Replace,
				  IPObjectStruct *KnotsObj);
IPObjectStruct *EvalSurfaceObject(IPObjectStruct *SrfObj,
				  RealType *u,
				  RealType *v);
IPObjectStruct *EvalCurveObject(IPObjectStruct *CrvObj, RealType *t);
IPObjectStruct *DeriveSurfaceObject(IPObjectStruct *SrfObj, RealType *Dir);
IPObjectStruct *DeriveCurveObject(IPObjectStruct *CrvObj);
IPObjectStruct *IntegrateCurveObject(IPObjectStruct *CrvObj);
IPObjectStruct *SurfaceNormalObject(IPObjectStruct *SrfObj);
IPObjectStruct *NormalSurfaceObject(IPObjectStruct *SrfObj,
				    RealType *u,
				    RealType *v);
IPObjectStruct *TangentSurfaceObject(IPObjectStruct *SrfObj,
				     RealType *Dir,
				     RealType *u,
				     RealType *v);
IPObjectStruct *TangentCurveObject(IPObjectStruct *CrvObj, RealType *t);
IPObjectStruct *CurveFromSrfMesh(IPObjectStruct *SrfObj,
				 RealType *Dir,
				 RealType *Index);
IPObjectStruct *CurveFromSurface(IPObjectStruct *SrfObj,
				 RealType *Dir,
				 RealType *ParamVal);
IPObjectStruct *CurveReverse(IPObjectStruct *CrvObj);
IPObjectStruct *SurfaceReverse(IPObjectStruct *SrfObj);
void ComputeSurfacePolygons(IPObjectStruct *PObj);
IPObjectStruct *Geometry2Polygons(IPObjectStruct *Obj, RealType *Normals);
IPObjectStruct *Geometry2Polylines(IPObjectStruct *Obj, RealType *Optimal);
IPObjectStruct *ExtremumControlPointVals(IPObjectStruct *Obj, CagdRType *Min);
IPObjectStruct *GenCircleCurveObject(VectorType Position, RealType *Radius);
IPObjectStruct *GenPCircleCurveObject(VectorType Position, RealType *Radius);
IPObjectStruct *GenArcCurveObject(VectorType Start,
				  VectorType Center,
				  VectorType End);
IPObjectStruct *GenRuledSrfObject(IPObjectStruct *Crv1, IPObjectStruct *Crv2);
IPObjectStruct *GenBoolSumSrfObject(IPObjectStruct *Crv1,
				    IPObjectStruct *Crv2,
				    IPObjectStruct *Crv3,
				    IPObjectStruct *Crv4);
IPObjectStruct *GenBoolOneSrfObject(IPObjectStruct *BndryCrv);
IPObjectStruct *GenSrfFromCrvsObject(IPObjectStruct *CrvList,
				     RealType *OtherOrder);
IPObjectStruct *GenSweepScaleSrfObject(IPObjectStruct *CrossSection,
				       IPObjectStruct *Axis,
				       IPObjectStruct *Scale,
				       IPObjectStruct *Frame,
				       RealType *RRefine);
IPObjectStruct *GenSweepSrfObject(IPObjectStruct *CrossSection,
				  IPObjectStruct *Axis, 
				  IPObjectStruct *Frame);
IPObjectStruct *GenOffsetObject(IPObjectStruct *Obj,
				RealType *Offset,
				RealType *Tolerance,
				RealType *BezInterp);
IPObjectStruct *GenAOffsetObject(IPObjectStruct *Obj,
				 RealType *Offset,
				 RealType *Epsilon,
				 RealType *Trim,
				 RealType *BezInterp);
IPObjectStruct *GenLeastSqrOffsetObject(IPObjectStruct *Obj,
					RealType *Offset,
					RealType *NumOfSamples,
					RealType *NumOfDOF,
					RealType *Order);
IPObjectStruct *MergeSrfSrf(IPObjectStruct *Srf1,
			    IPObjectStruct *Srf2,
			    RealType *Dir,
			    RealType *SameEdge);
IPObjectStruct *MergeCurvesAndCtlPoints(IPObjectStruct *PObj1,
					IPObjectStruct *PObj2);
IPObjectStruct *EditCrvControlPoint(IPObjectStruct *PObjCrv,
				    CagdCtlPtStruct *Pt,
				    RealType *Index);
IPObjectStruct *EditSrfControlPoint(IPObjectStruct *PObjSrf,
				    CagdCtlPtStruct *Pt,
				    RealType *UIndex,
				    RealType *VIndex);
IPObjectStruct *RaiseCurveObject(IPObjectStruct *PObjCrv, RealType *Order);
IPObjectStruct *RaiseSurfaceObject(IPObjectStruct *PObjSrf,
				   RealType *RDir,
				   RealType *RNewOrder);
void MakeFreeFormCompatible(IPObjectStruct *PObj1, IPObjectStruct *PObj2);
IPObjectStruct *TwoCrvsMorphing(IPObjectStruct *PObjCrv1,
				IPObjectStruct *PObjCrv2,
				RealType *Method,
				RealType *Blend);
IPObjectStruct *TwoSrfsMorphing(IPObjectStruct *PObjSrf1,
				IPObjectStruct *PObjSrf2,
				RealType *Blend);
IPObjectStruct *CnvrtBezierToBspline(IPObjectStruct *PObj);
IPObjectStruct *CnvrtBsplineToBezier(IPObjectStruct *PObj);
IPObjectStruct *TwoCrvsSrfsProduct(IPObjectStruct *PObj1,
				   IPObjectStruct *PObj2);
IPObjectStruct *TwoCrvsSrfsDotProduct(IPObjectStruct *PObj1,
				      IPObjectStruct *PObj2);
IPObjectStruct *TwoCrvsSrfsCrossProduct(IPObjectStruct *PObj1,
					IPObjectStruct *PObj2);
IPObjectStruct *TwoCrvsSrfsSum(IPObjectStruct *PObj1, IPObjectStruct *PObj2);
IPObjectStruct *TwoCrvsSrfsDiff(IPObjectStruct *PObj1, IPObjectStruct *PObj2);
IPObjectStruct *CrvReparametrization(IPObjectStruct *Obj,
				     RealType *TMin,
				     RealType *TMax);
IPObjectStruct *SrfReparametrization(IPObjectStruct *Obj,
				     RealType *RDir,
				     RealType *TMin,
				     RealType *TMax);
IPObjectStruct *CrvCurvaturePts(IPObjectStruct *PObj, RealType *Eps);
IPObjectStruct *SrfCurvatureBounds(IPObjectStruct *PObj,
				   RealType *RPtType,
				   RealType *RDir);
IPObjectStruct *CrvEvolute(IPObjectStruct *PObj);
IPObjectStruct *CrvInflectionPts(IPObjectStruct *PObj, RealType *Eps);
IPObjectStruct *CrvZeros(IPObjectStruct *PObj, RealType *Eps, RealType *Axis);
IPObjectStruct *CrvExtremes(IPObjectStruct *PObj,
			    RealType *Eps,
			    RealType *Axis);
IPObjectStruct *CrvCrvInter(IPObjectStruct *PObj1,
			    IPObjectStruct *PObj2,
			    RealType *Eps,
			    RealType *SelfInter);
IPObjectStruct *CrvPointDist(IPObjectStruct *PCrv,
			     PointType Point,
			     RealType *MinDist,
			     RealType *Eps);
IPObjectStruct *CrvLineDist(IPObjectStruct *PCrv,
			    PointType Point,
			    VectorType Vec,
			    RealType *MinDist,
			    RealType *Eps);
IPObjectStruct *CrvComposition(IPObjectStruct *PObj1, IPObjectStruct *PObj2);
IPObjectStruct *SrfsPrisa(IPObjectStruct *Srfs,
			  CagdRType *SamplesPerCurve,
			  CagdRType *Epsilon,
			  CagdRType *Dir,
			  CagdVType Space);
IPObjectStruct *SrfAdapIsoCurves(IPObjectStruct *Srf,
				 CagdRType *Dir,
				 CagdRType *Eps,
				 CagdRType *FullIso,
				 CagdRType *SinglePath);
IPObjectStruct *GetFreefromParamDomain(IPObjectStruct *FreeformObj);
IPObjectStruct *CrvLeastSquarePtData(IPObjectStruct *PtObjList,
				     CagdRType *Order,
				     CagdRType *CrvSize,
				     CagdRType *ParamType);
IPObjectStruct *SrfLeastSquarePtData(IPObjectStruct *LstObjList,
				     CagdRType *UOrder,
				     CagdRType *VOrder,
				     CagdRType *USize,
				     CagdRType *VSize,
				     CagdRType *ParamType);
int GetResolution(int ClipToMin);
IPObjectStruct *CurveMultiResDecomp(IPObjectStruct *CrvObj, RealType *Discont);
IPObjectStruct *GenTrimmedSurface(IPObjectStruct *SrfObj,
				  IPObjectStruct *TrimmedCrvsObj,
				  RealType *RHasTopLvlTrim);
IPObjectStruct *GetSrfFromTrimmedSrf(IPObjectStruct *TrimmedSrfObj);
IPObjectStruct *GetTrimCrvsFromTrimmedSrf(IPObjectStruct *TrimmedSrfObj,
					  RealType *RParamSpace);
IPObjectStruct *GenBezierTrivarObject(IPObjectStruct *LstLstObjList);
IPObjectStruct *GenBsplineTrivarObject(RealType *RUOrder,
				       RealType *RVOrder,
				       RealType *RWOrder,
				       IPObjectStruct *LstLstObjList,
				       IPObjectStruct *KntObjList);
IPObjectStruct *EvalTrivarObject(IPObjectStruct *TVObj,
				 RealType *u,
				 RealType *v,
				 RealType *w);
IPObjectStruct *SurfaceFromTrivar(IPObjectStruct *TVObj,
				  RealType *RDir,
				  RealType *ParamVal);
IPObjectStruct *DivideTrivarObject(IPObjectStruct *TVObj,
				    RealType *RDir,
				    RealType *ParamVal);
IPObjectStruct *RegionFromTrivarObject(IPObjectStruct *TVObj, 
					RealType *RDir,
					RealType *ParamVal1,
					RealType *ParamVal2);
IPObjectStruct *RefineTrivarObject(IPObjectStruct *TVObj,
				    RealType *RDir,
				    RealType *RReplace,
				    IPObjectStruct *KnotsObj);
IPObjectStruct *DeriveTrivarObject(IPObjectStruct *TVObj, RealType *Dir);
IPObjectStruct *InterpolateTrivar(IPObjectStruct *TVObj);
IPObjectStruct *ComputeCrvMoments(IPObjectStruct *CrvObj, RealType *RMoment);
IPObjectStruct *GenTVFromSrfsObject(IPObjectStruct *SrfList,
				    RealType *OtherOrder);

#endif /* FREEFORM_H */
