#include <stdio.h>
#ifdef ultrix
#include <cursesX.h>
#else
#include <curses.h>
#endif
#include <signal.h>
#include "vaxconio.h"
#define false 0
#define true (!false)
#define dbg if (1==1)
extern int noscreenio;
delay(int i)
{}
int vx_top=1,vx_bot=24;
textattr()
{}
abort_key()
{
	return false;
}
kbhit()
{
	return false;
}
scr_gets(char *x)
{
	getstr(x);
}
clreol()
{
	if (noscreenio) return;
	clrtoeol();
}
cputs(char *line)
{
	int x;
	int y;
	if (noscreenio) return;
	getyx(stdscr,y,x);
	mvaddstr(y,x,line);
}
delline()
{
	int x;
	int y;
	getyx(stdscr,y,x);
	move(22,1);
	clrtobot();
	move(y,1);
	deleteln();
	move(y,x);
}
gotoxy(int x, int y)
{
	if (noscreenio) return;
	if (y==25) y=24;
	if (y<1) y=1;
	move(y+vx_top-2,x);
}
insline()
{
	int x;
	int y;
	getyx(stdscr,y,x);
	move(y,x);
	insertln();
	move(y,x);
	move(22,1);
	clrtobot();
	move(y,x);

}
putch(int char_val)
{
	int x;
	int y;
	getyx(stdscr,y,x);
	mvaddch(y,x,char_val);
}
int scr_refresh()
{
	if (!noscreenio) refresh();
}
int scr_getch()
{
	if (noscreenio) return getc(stdin);
	else return getch();
}
void trap();
void trap()
{
	echo();
	nl();
	nocbreak();
	endwin();
	exit(1);
}
scr_init()
{
	static int doneinit;
#ifdef ultrix
	signal(SIGINT,trap);
#endif
#ifdef aix
	signal(SIGINT,trap);
#endif
	if (doneinit) {printf("init called twice \n"); exit();}	
	doneinit = true;
	initscr();
	scrollok(stdscr,true);
#ifdef unix
	noecho();
	nonl();
	cbreak();
	clear();
/* The AIX R6000 goes looney if you set keypad to be true, */
#ifndef NOKEYPAD
	keypad(stdscr,TRUE);
#endif
#endif
}
scr_end()
{
	if (noscreenio) return;
	echo();
	nl();
	nocbreak();
	endwin();
}
textbackground(int color_num)
{}
textcolor(int colornum)
{}
gettextinfo(struct text_info *r)
{
	int x;
	int y;
	if (noscreenio) return;
	getyx(stdscr,y,x);
	r->curx = x;
	r->cury = y;
	r->wintop = vx_top;
}
screen_save()
{}
screen_restore()
{
	if (noscreenio) return;
	scr_norm();
	clrscr();
	gotoxy(1,1);
	cputs("\n");
}
int wyerr;
w_message(char *s)
{
	wyerr++;
	if (noscreenio) return;
	scr_savexy();
	gotoxy(1,wyerr);
	clreol();
	cputs(s);
	scr_restorexy();
}	
window(int left,int top, int right, int bottom)
{
	if (left==1 && top==1 && bottom==25) {
	if (noscreenio) return;
#ifndef unix
		printf("\x1b[%d;%dr",1,24);
#endif
	} 	
	vx_top = top;
	vx_bot = bottom;
	wyerr = 0;
}
clrscr()
{
	if (noscreenio) return;
	if (vx_top==1 && vx_bot==25) {
		clearok(stdscr,TRUE);
		clear();
		refresh();
		clearok(stdscr,FALSE);
		return;
	}
	clear();
}
scr_dots(int i)
{
}
scr_left(int i)
{
	int y,x;
	if (i<=0) return;
	getyx(stdscr,y,x);
	move(y,x-i);
}
scr_right(int i)
{
	int y,x;
	if (i<=0) return;
	getyx(stdscr,y,x);
	move(y,x+i);
}
int vx_topsave,vx_botsave;
int savex,savey;
scr_savexy()
{
	if (noscreenio) return;
	getyx(stdscr,savey,savex);
	vx_topsave = vx_top;
	vx_botsave = vx_bot;
	
}
scr_restorexy()
{
	if (noscreenio) return;
	move(savey,savex);
	vx_top = vx_topsave;
	vx_bot = vx_botsave;
}

scr_norm()  /* yellow on blue */
{
#ifndef NOATTRIB
	attrset(A_NORMAL);
#endif
}
scr_inv()   /* black on white */
{
#ifndef NOATTRIB
	attrset(A_BOLD);
#endif
}
scr_grey()  /* black on grey */
{
#ifndef NOATTRIB
	attrset(A_REVERSE);
#endif
}
scr_isblackwhite()
{
	return true;
}
scr_menubg()
{
	scr_norm();
}
scr_menuval()
{
	scr_inv();
}
scr_menuhi()
{

	scr_grey();
}

#ifndef unix
#include <descrip.h>
vax_edt(char *s) 	/* call the vax EDT editor */
{
	$DESCRIPTOR(sdesc,"");
	sdesc.dsc$a_pointer = s;
	sdesc.dsc$w_length = strlen(s);
	edt$edit(&sdesc,&sdesc);
}
#else
vax_edt(char *s)
{}
#endif
