/*---------------------------------------------------------------------------*/
#include "all.h"


#define true (!false)
#define false 0

int var_local;		/* 0 = global, 1 = local */
char *var_names[100];	/* Global variables */
int var_type[100];
int nvar;
char *lvar_names[100];	/*  Local variables  */
int lvar_type[100];
int nlvar;

static void *dp_stack[100];
static void *dp_stackstr[100];
static int ndp;
static double (*lvar_val)[100];
static char *(*lvar_str)[100];
static double var_val[100];
static char *var_str[100];
/*------------------------------------------------------------------*/
int var_check(int *j);
var_check(int *j)
{
	if (*j<0 || *j>400) {
		gprint("Variable index is wrong %d \n",*j);
		*j = 1;
	}
	if (lvar_val == NULL  && *j>=200) {
		*j = 0;
		gprint("No local variables assigned \n");
	}
}
var_alloc_local()
{
	dp_stack[++ndp] = lvar_val;
	dp_stackstr[ndp] = lvar_str;
	lvar_val = myallocz(sizeof(*lvar_val));
	lvar_str = myallocz(sizeof(*lvar_str));
}
var_free_local()
{
	if (ndp==0) {gprint("Cannot free local as none saved \n"); return;}
	myfree(lvar_val);
	myfree(lvar_str);
	lvar_val = dp_stack[ndp];
	lvar_str = dp_stackstr[ndp--];
}
var_set(int jj, double v)
{
	var_check(&jj);
	if (jj<200)
		var_val[jj] = v;
	else
		(*lvar_val)[jj-200] = v;
}
var_setstr(int jj, char *s)
{
	var_check(&jj);
	if (jj<200)
		mystrcpy(&var_str[jj],s);
	else
		mystrcpy(&(*lvar_str)[jj-200],s);
}
var_getstr(int jj, char *s)
{
	var_check(&jj);
	if (jj<200) {
		if (var_str[jj]!=NULL) strcpy(s,var_str[jj]);
		else {
			strcpy(s,"");
			gprint("String Variable not defined %d \n",jj);
		}
	} else {
		if ((*lvar_str)[jj-200]!=NULL) strcpy(s,(*lvar_str)[jj-200]);
		if ((*lvar_str)[jj-200]==NULL) gprint("ERROR, variable not defined\n");
	}

}
var_get(int jj, double *v)
{
	var_check(&jj);
	if (jj<200)
		*v = var_val[jj];
	else
		*v = (*lvar_val)[jj-200];
}
/*------------------------------------------------------------------*/
var_nlocal(int *l)
{
	*l = nlvar;
}
var_clear_global()
{
	nvar = 0;
}
var_set_local()
{
	var_local = true;
	nlvar = 0;
}
var_set_global()
{
	var_local = false;
}
var_clear_local()
{
	nlvar = 0;
}
var_findadd(char *name,int *idx,int *type)	/* Add a variable to the list */
{
	var_find(name,idx,type);
	if (*idx==-1) var_add(name,idx,type);
}
var_add(char *name,int *idx,int *type)	/* Add a variable to the list */
{
	if (var_local==0) {
		if (nvar>90) gprint("Too many global variables \n");
		mystrcpy(&var_names[nvar],name);
		*idx = nvar;
		if (lastchar(name,'$')) *type=2;
		else *type=1;
		var_type[nvar++] = *type;
	} else {
		if (nlvar>90) gprint("Too many local variables \n");
		mystrcpy(&lvar_names[nlvar],name);
		*idx = nlvar+200;
		if (lastchar(name,'$')) *type=2;
		else *type=1;
		lvar_type[nlvar++] = *type;
	}
}
var_find(char *name,int *idx,int *type)	/* Find a variable in the list */
{
	int i;
/* 	if (var_local==0) { */

	for (i=0;i<nlvar;i++) {
		if (strcmp(lvar_names[i],name)==0) {
			*idx = i+200;
			*type = lvar_type[i];
			return;
		}
	}
	for (i=0;i<nvar;i++) {
		if (strcmp(var_names[i],name)==0) {
			*idx = i;
			*type = var_type[i];
			return;
		}
	}
	*idx = -1;


/* 	} else { */
/* 	} */
}
/*------------------------------------------------------------------*/
var_find_dn(int *idx, int *var, int *nd)
{
	int i,d;
	*nd = 0;
	for (i=0;i<nlvar;i++) {
		if (strncmp(lvar_names[i],"D",1)==0) {
			d = atoi(lvar_names[i]+1);
			if (d>0 && d<100) {
				++*nd;
				*idx++ = i+200;
				*var++ = d;
			}
		}
	}
}
var_find_rc(int *idx, int *var, int *nd, int c)
{
	int i,d;
	*nd = 0;
	for (i=0;i<nlvar;i++) {
		if (*lvar_names[i]==c) {
			d = atoi(lvar_names[i]+1);
			if (d>0) {
				++*nd;
				*idx++ = i+200;
				*var++ = d;
			}
		}
	}
	for (i=0;i<nvar;i++) {
		if (*var_names[i]==c) {
			d = atoi(var_names[i]+1);
			if (d>0) {
				++*nd;
				*idx++ = i;
				*var++ = d;
			}
		}
	}
}
/*------------------------------------------------------------------*/
str_var(s)
char *s;
{
	int i;
	i = strlen(s);
	if (*(s+i-1)=='$') return true;
	  else return false;
}

valid_var(s)
char *s;
{
	return true;
}

/*------------------------------------------------------------------*/
