#define XSIZECM 19		/* at 120 DPI  */
#define YSIZECM 27		/* at 72 DPI */
#ifdef __TURBOC__
#define NXBITS 1352 /* 180 dpi */
#define NYBITS 1920	/* 180 dpi  (24 pin epson printers) */
#else
#define NXBITS 300	/* because vax cant cope with one huge record */
#define NYBITS 408
#endif
#include "bitmap.h"
dvitype(void)
{
	printf("Epson (24Pin)");
}
bitmap_print()
{
	int y;
	for (y=nybits-24 ; y>=0 ; y-=24)
		print_row(y);
}
print_row(int y)
{
	unsigned char savechar,temp;
	static unsigned char out_buff[3*NXBITS+20]="\x1b*\x27";
	unsigned int r,i,j,newy,x,z;
	unsigned char *line;
	dbg printf("row %d\n",y);
	for (r=5;r<(3*NXBITS+6);r++) out_buff[r] = 0;
	for (r=0; r<24; r++,y++) {
		line = bitmap_line(y);
		for (x=0,j = 5; x<NXBITS;x++,j++) {
			z = 1 << (x % 8);
			if ((z & line[x/8]) != 0) {
				if (r<8) {
					 out_buff[x*3+7] |= 1 << r;
				} else if (r<16) {
					 out_buff[x*3+6] |= 1 << (r-8);
				} else {
					 out_buff[x*3+5] |= 1 << (r-16);
				}
			}
		}
	}
	out_buff[3] = (x) & 255;
	out_buff[4] = (x) / 256;
	printmem(out_buff,x*3+5);
	pprintf("\x0d\x1bJ\x18");
}

