/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997	Tim Janik	<timj@psynet.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include	"rcs.h"
RCS_ID("$Id: structures.c,v 1.9 1997/08/18 03:38:12 timj Exp $")


#define		__structures_c__

#include	"structures.h"
#include	"widdata.h"
#include	"type2str.h"
#include	"special_fields.h"
#include	"config.h"
#include	"defines.h"



/* --- auxillary structure field arrays --- */

/*	LinkageBox
*/
static	const	gsi_field_info_S	LinkageBox_fields[]={
{
	GSI_FIELD_ENUM					/* field_type */,
	"pack_type"					/* field_name */,
	GB_OPT_REBUILD					/* field_flags */,
	_GSI_VU_ENUM_(GTK_PACK_START)			/* minimum */,
	_GSI_VU_ENUM_(GTK_PACK_START)			/* v_default */,
	_GSI_VU_ENUM_(GTK_PACK_END)			/* maximum */,
	_GSI_FIELD_FUNC_(String_GtkPackType)		/* field_func */,
	_GSI_OFFSET_(gb_linkage_box_S, pack_type)	/* field_offset */,
},
{
	GSI_FIELD_BITS					/* field_type */,
	"attach"					/* field_name */,
	GB_OPT_REBUILD					/* field_flags */,
	_GSI_VU_BITS_(0)				/* minimum */,
	_GSI_VU_BITS_(GTK_EXPAND | GTK_FILL)		/* v_default */,
	_GSI_VU_BITS_(GTK_EXPAND | GTK_FILL)		/* maximum */,
	_GSI_FIELD_FUNC_(String_GtkAttachOptions)	/* field_func */,
	_GSI_OFFSET_(gb_linkage_box_S, attach)		/* field_offset */,
},
{
	GSI_FIELD_INT					/* field_type */,
	"padding"					/* field_name */,
	GB_OPT_REBUILD					/* field_flags */,
	_GSI_VU_INT_(0)					/* minimum */,
	_GSI_VU_INT_(0)					/* v_default */,
	_GSI_VU_INT_(MAX_PADDING)			/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_linkage_box_S,
	  padding)					/* field_offset */,
},
};


/*	LinkageTable
*/
static	const	gsi_field_info_S	LinkageTable_fields[]={
{
	GSI_FIELD_BITS					/* field_type */,
	"xoptions"					/* field_name */,
	GB_OPT_REBUILD					/* field_flags */,
	_GSI_VU_BITS_(0)				/* minimum */,
	_GSI_VU_BITS_(GTK_EXPAND | GTK_FILL)		/* v_default */,
	_GSI_VU_BITS_(GTK_EXPAND |
		      GTK_SHRINK | GTK_FILL)		/* maximum */,
	_GSI_FIELD_FUNC_(String_GtkAttachOptions)	/* field_func */,
	_GSI_OFFSET_(gb_linkage_table_S,
	  xoptions)					/* field_offset */,
},
{
	GSI_FIELD_BITS					/* field_type */,
	"yoptions"					/* field_name */,
	GB_OPT_REBUILD					/* field_flags */,
	_GSI_VU_BITS_(0)				/* minimum */,
	_GSI_VU_BITS_(GTK_EXPAND | GTK_FILL)		/* v_default */,
	_GSI_VU_BITS_(GTK_EXPAND |
		      GTK_SHRINK | GTK_FILL)		/* maximum */,
	_GSI_FIELD_FUNC_(String_GtkAttachOptions)	/* field_func */,
	_GSI_OFFSET_(gb_linkage_table_S,
	  yoptions)					/* field_offset */,
},
{
	GSI_FIELD_INT					/* field_type */,
	"xpadding"					/* field_name */,
	GB_OPT_REBUILD					/* field_flags */,
	_GSI_VU_INT_(0)					/* minimum */,
	_GSI_VU_INT_(0)					/* v_default */,
	_GSI_VU_INT_(MAX_PADDING)			/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_linkage_table_S,
	  xpadding)					/* field_offset */,
},
{
	GSI_FIELD_INT					/* field_type */,
	"ypadding"					/* field_name */,
	GB_OPT_REBUILD					/* field_flags */,
	_GSI_VU_INT_(0)					/* minimum */,
	_GSI_VU_INT_(0)					/* v_default */,
	_GSI_VU_INT_(MAX_PADDING)			/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_linkage_table_S,
	  ypadding)					/* field_offset */,
},
{
	GSI_FIELD_INT					/* field_type */,
	"left_attach"					/* field_name */,
	GB_OPT_REBUILD					/* field_flags */,
	_GSI_VU_INT_(0)					/* minimum */,
	_GSI_VU_INT_(0)					/* v_default */,
	_GSI_VU_INT_(MAX_ATTACH)			/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_linkage_table_S,
	  left_attach)					/* field_offset */,
},
{
	GSI_FIELD_INT					/* field_type */,
	"right_attach"					/* field_name */,
	GB_OPT_REBUILD					/* field_flags */,
	_GSI_VU_INT_(0)					/* minimum */,
	_GSI_VU_INT_(1)					/* v_default */,
	_GSI_VU_INT_(MAX_ATTACH)			/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_linkage_table_S,
	  right_attach)					/* field_offset */,
},
{
	GSI_FIELD_INT					/* field_type */,
	"top_attach"					/* field_name */,
	GB_OPT_REBUILD					/* field_flags */,
	_GSI_VU_INT_(0)					/* minimum */,
	_GSI_VU_INT_(0)					/* v_default */,
	_GSI_VU_INT_(MAX_ATTACH)			/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_linkage_table_S,
	  top_attach)					/* field_offset */,
},
{
	GSI_FIELD_INT					/* field_type */,
	"bottom_attach"					/* field_name */,
	GB_OPT_REBUILD					/* field_flags */,
	_GSI_VU_INT_(0)					/* minimum */,
	_GSI_VU_INT_(1)					/* v_default */,
	_GSI_VU_INT_(MAX_ATTACH)			/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_linkage_table_S,
	  bottom_attach)				/* field_offset */,
},
};

static const gchar*
LinkageNotebook_tab_label	(void);
const gchar*
LinkageNotebook_tab_label	(void)
{
	return "";
}

/*	LinkageNotebook
*/
static	const	gsi_field_info_S	LinkageNotebook_fields[]={
{
	GSI_FIELD_ENUM					/* field_type */,
	"page_linkage"					/* field_name */,
	GB_OPT_REBUILD					/* field_flags */,
	_GSI_VU_ENUM_(GB_PAGE_INSERT)			/* minimum */,
	_GSI_VU_ENUM_(GB_PAGE_APPEND)			/* v_default */,
	_GSI_VU_ENUM_(GB_PAGE_PREPEND)			/* maximum */,
	_GSI_FIELD_FUNC_(String_GbPageLinkage)		/* field_func */,
	_GSI_OFFSET_(gb_linkage_notebook_S, page_linkage)
							/* field_offset */,
},
{
	GSI_FIELD_INT					/* field_type */,
	"position"					/* field_name */,
	GB_OPT_REBUILD					/* field_flags */,
	_GSI_VU_INT_(0)					/* minimum */,
	_GSI_VU_INT_(0)					/* v_default */,
	_GSI_VU_INT_(MAX_PAGES)				/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_linkage_notebook_S,
	  position)					/* field_offset */,
},
{
	GSI_FIELD_STRING				/* field_type */,
	"tab_label"					/* field_name */,
	GB_OPT_REBUILD			|
	  GSI_OPT_STRING_DEFAULTS	|
	  GSI_OPT_STRING_FUNCTION	|
	  GSI_OPT_STRING_NONNULL			/* field_flags */,
	_GSI_VU_STRING_(NULL)				/* minimum */,
	_GSI_VU_STRING_(NULL)				/* v_default */,
	_GSI_VU_STRING_(NULL)				/* maximum */,
	_GSI_FIELD_FUNC_(LinkageNotebook_tab_label)	/* field_func */,
	_GSI_OFFSET_(gb_linkage_notebook_S, tab_label)	/* field_offset */,
},
{
	GSI_FIELD_FLOAT					/* field_type */,
	"tab_xalign"					/* field_name */,
	GB_OPT_REBUILD					/* field_flags */,
	_GSI_VU_FLOAT_(MIN_ALIGN)			/* minimum */,
	_GSI_VU_FLOAT_(0.5)				/* v_default */,
	_GSI_VU_FLOAT_(MAX_ALIGN)			/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_linkage_notebook_S, tab_xalign)	/* field_offset */,
},
{
	GSI_FIELD_FLOAT					/* field_type */,
	"tab_yalign"					/* field_name */,
	GB_OPT_REBUILD					/* field_flags */,
	_GSI_VU_FLOAT_(MIN_ALIGN)			/* minimum */,
	_GSI_VU_FLOAT_(0.5)				/* v_default */,
	_GSI_VU_FLOAT_(MAX_ALIGN)			/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_linkage_notebook_S, tab_yalign)	/* field_offset */,
},
{
	GSI_FIELD_INT					/* field_type */,
	"tab_xpad"					/* field_name */,
	GB_OPT_REBUILD					/* field_flags */,
	_GSI_VU_INT_(0)					/* minimum */,
	_GSI_VU_INT_(0)					/* v_default */,
	_GSI_VU_INT_(MAX_PADDING)			/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_linkage_notebook_S, tab_xpad)	/* field_offset */,
},
{
	GSI_FIELD_INT					/* field_type */,
	"tab_ypad"					/* field_name */,
	GB_OPT_REBUILD					/* field_flags */,
	_GSI_VU_INT_(0)					/* minimum */,
	_GSI_VU_INT_(0)					/* v_default */,
	_GSI_VU_INT_(MAX_PADDING)			/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_linkage_notebook_S, tab_ypad)	/* field_offset */,
},
};



/* --- gtk base type - GtkObject --- */


/* Object
*/
static	const	gsi_field_info_S	Object_fields[]={
{
	GSI_FIELD_STRING				/* field_type */,
	"user_data"					/* field_name */,
	GSI_OPT_STRING_DEFAULTS		|
	  GSI_OPT_STRING_UNQUOTED			/* field_flags */,
	_GSI_VU_POINTER_(NULL)				/* minimum */,
	_GSI_VU_POINTER_("NULL")			/* v_default */,
	_GSI_VU_POINTER_(NULL)				/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_objdat_S, PIGGY_BACK_user_data)	/* field_offset */,
	/* hm, using clone for user data is a trick to have GUBI_DATA()
	 * available from object's user data ;)
	*/
},
};



/* --- widget field arrays --- */


/*	Widget
*/
static	const	gsi_field_info_S	Widget_fields[]={
{
	GSI_FIELD_STRING				/* field_type */,
	"widget_name"					/* field_name */,
	GSI_OPT_STRING_NONNULL				/* field_flags */,
	_GSI_VU_STRING_(NULL)				/* minimum */,
	_GSI_VU_STRING_(NULL)				/* v_default */,
	_GSI_VU_STRING_(NULL)				/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_base_S, widget_name)	/* field_offset */,
},
{
	GSI_FIELD_BITS					/* field_type */,
	"flags"						/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_BITS_(0)				/* minimum */,
	_GSI_VU_BITS_(GTK_VISIBLE | GTK_SENSITIVE)	/* v_default */,
	_GSI_VU_BITS_(	GTK_VISIBLE	|
			GTK_SENSITIVE	|
			GTK_CAN_DEFAULT	|
			GTK_CAN_FOCUS	|
			GTK_HAS_DEFAULT	|
			GTK_HAS_FOCUS  )		/* maximum */,
	_GSI_FIELD_FUNC_(String_GtkWidgetFlag)		/* field_func */,
	_GSI_OFFSET_(gb_wdat_base_S, flags)		/* field_offset */,
},
{
	GSI_FIELD_INT					/* field_type */,
	"x"						/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_INT_(-1)				/* minimum */,
	_GSI_VU_INT_(-1)				/* v_default */,
	_GSI_VU_INT_(MAX_POS)				/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_base_S, x)			/* field_offset */,
},
{
	GSI_FIELD_INT					/* field_type */,
	"y"						/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_INT_(-1)				/* minimum */,
	_GSI_VU_INT_(-1)				/* v_default */,
	_GSI_VU_INT_(MAX_POS)				/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_base_S, y)			/* field_offset */,
},
{
	GSI_FIELD_INT					/* field_type */,
	"width"						/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_INT_(0)					/* minimum */,
	_GSI_VU_INT_(0)					/* v_default */,
	_GSI_VU_INT_(MAX_SIZE)				/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_base_S, width)		/* field_offset */,
},
{
	GSI_FIELD_INT					/* field_type */,
	"height"					/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_INT_(0)					/* minimum */,
	_GSI_VU_INT_(0)					/* v_default */,
	_GSI_VU_INT_(MAX_SIZE)				/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_base_S, height)		/* field_offset */,
},
};


/*	Misc
*/
static	const	gsi_field_info_S	Misc_fields[]={
{
	GSI_FIELD_FLOAT					/* field_type */,
	"xalign"					/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_FLOAT_(MIN_ALIGN)			/* minimum */,
	_GSI_VU_FLOAT_(0.5)				/* v_default */,
	_GSI_VU_FLOAT_(MAX_ALIGN)			/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_misc_S, xalign)	/* field_offset */,
},
{
	GSI_FIELD_FLOAT					/* field_type */,
	"yalign"					/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_FLOAT_(MIN_ALIGN)			/* minimum */,
	_GSI_VU_FLOAT_(0.5)				/* v_default */,
	_GSI_VU_FLOAT_(MAX_ALIGN)			/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_misc_S, yalign)		/* field_offset */,
},
{
	GSI_FIELD_INT					/* field_type */,
	"xpad"						/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_INT_(0)					/* minimum */,
	_GSI_VU_INT_(0)					/* v_default */,
	_GSI_VU_INT_(MAX_PADDING)			/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_misc_S, xpad)		/* field_offset */,
},
{
	GSI_FIELD_INT					/* field_type */,
	"ypad"						/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_INT_(0)					/* minimum */,
	_GSI_VU_INT_(0)					/* v_default */,
	_GSI_VU_INT_(MAX_PADDING)			/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_misc_S, ypad)		/* field_offset */,
},
};


/*	Container
*/
static	const	gsi_field_info_S	Container_fields[]={
{
	GSI_FIELD_INT					/* field_type */,
	"border_width"					/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_INT_(0)					/* minimum */,
	/* v_default must be 0, otherwise we
	 * have problems on several widgets
	*/
	_GSI_VU_INT_(0)					/* v_default */,
	_GSI_VU_INT_(MAX_BORDER_WIDTH)			/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_container_S,
	  border_width)					/* field_offset */,
},
};


/*	Label
*/
static	const	gsi_field_info_S	Label_fields[]={
{
	GSI_FIELD_STRING				/* field_type */,
	"label"						/* field_name */,
	GSI_OPT_STRING_FUNCTION		|
	  GSI_OPT_STRING_NONNULL			/* field_flags */,
	_GSI_VU_STRING_(NULL)				/* minimum */,
	_GSI_VU_STRING_(NULL)				/* v_default */,
	_GSI_VU_STRING_(NULL)				/* maximum */,
	_GSI_FIELD_FUNC_(widget_data_symbol_name_get)	/* field_func */,
	_GSI_OFFSET_(gb_wdat_label_S, label)		/* field_offset */,
},
};


/*	Entry
*/
static	const	gsi_field_info_S	Entry_fields[]={
{
	GSI_FIELD_STRING				/* field_type */,
	"init_text"					/* field_name */,
	GSI_OPT_STRING_NONNULL		|
	  GSI_OPT_STRING_FUNCTION	|
	  GB_OPT_REBUILD				/* field_flags */,
	_GSI_VU_STRING_(NULL)				/* minimum */,
	_GSI_VU_STRING_(NULL)				/* v_default */,
	_GSI_VU_STRING_(NULL)				/* maximum */,
	_GSI_FIELD_FUNC_(widget_data_symbol_name_get)	/* field_func */,
	_GSI_OFFSET_(gb_wdat_entry_S, init_text)	/* field_offset */,
},
};


/*	Button
*/
static	const	gsi_field_info_S	Button_fields[]={
{
	GSI_FIELD_STRING				/* field_type */,
	"label"						/* field_name */,
	GSI_OPT_STRING_FUNCTION		|
	  GB_OPT_STRING_IS_CHILD	|
	  GB_OPT_REBUILD				/* field_flags */,
	_GSI_VU_STRING_(NULL)				/* minimum */,
	_GSI_VU_STRING_(NULL)				/* v_default */,
	_GSI_VU_STRING_(NULL)				/* maximum */,
	_GSI_FIELD_FUNC_(widget_data_symbol_name_get)	/* field_func */,
	_GSI_OFFSET_(gb_wdat_button_S, label)		/* field_offset */,
},
};


/*	ToggleButton
*/
static	const	gsi_field_info_S	ToggleButton_fields[]={
{
	GSI_FIELD_BOOLEAN				/* field_type */,
	"init_state"					/* field_name */,
	GB_OPT_REBUILD					/* field_flags */,
	_GSI_VU_BOOLEAN_(FALSE)				/* minimum */,
	_GSI_VU_BOOLEAN_(FALSE)				/* v_default */,
	_GSI_VU_BOOLEAN_(TRUE)				/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_toggle_button_S,
		 init_state)				/* field_offset */,
},
{
	GSI_FIELD_BOOLEAN				/* field_type */,
	"draw_indicator"				/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_BOOLEAN_(FALSE)				/* minimum */,
	_GSI_VU_BOOLEAN_(TRUE)				/* v_default */,
	_GSI_VU_BOOLEAN_(TRUE)				/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_toggle_button_S,
		 draw_indicator)			/* field_offset */,
},
};


/*	RadioButton
*/
static	const	gsi_field_info_S	RadioButton_fields[]={
{
	GSI_FIELD_STRUCT_LINK				/* field_type */,
	"grouping"					/* field_name */,
	GB_OPT_REBUILD					/* field_flags */,
	_GSI_VU_STRUCT_LINK_(NULL)			/* minimum */,
	_GSI_VU_STRUCT_LINK_(NULL)			/* v_default */,
	_GSI_VU_STRUCT_LINK_(NULL)			/* maximum */,
	_GSI_FIELD_FUNC_(RadioGroup_List)		/* field_func */,
	_GSI_OFFSET_(gb_wdat_radio_button_S,
		 grouping)				/* field_offset */,
},
};


/*	Frame
*/
static	const	gsi_field_info_S	Frame_fields[]={
{
	GSI_FIELD_STRING				/* field_type */,
	"label"						/* field_name */,
	GSI_OPT_STRING_NONNULL		|
	  GSI_OPT_STRING_FUNCTION			/* field_flags */,
	_GSI_VU_STRING_(NULL)				/* minimum */,
	_GSI_VU_STRING_(NULL)				/* v_default */,
	_GSI_VU_STRING_(NULL)				/* maximum */,
	_GSI_FIELD_FUNC_(widget_data_symbol_name_get)	/* field_func */,
	_GSI_OFFSET_(gb_wdat_frame_S, label)		/* field_offset */,
},
{
	GSI_FIELD_ENUM					/* field_type */,
	"shadow_type"					/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_ENUM_(GTK_SHADOW_NONE)			/* minimum */,
	_GSI_VU_ENUM_(GTK_SHADOW_ETCHED_IN)		/* v_default */,
	_GSI_VU_ENUM_(GTK_SHADOW_ETCHED_OUT)		/* maximum */,
	_GSI_FIELD_FUNC_(String_GtkShadowType)		/* field_func */,
	_GSI_OFFSET_(gb_wdat_frame_S, shadow_type)	/* field_offset */,
},
{
	GSI_FIELD_FLOAT					/* field_type */,
	"xalign"					/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_FLOAT_(MIN_ALIGN)			/* minimum */,
	_GSI_VU_FLOAT_(0.5)				/* v_default */,
	_GSI_VU_FLOAT_(MAX_ALIGN)			/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_frame_S, xalign)		/* field_offset */,
},
{
	GSI_FIELD_FLOAT					/* field_type */,
	"yalign"					/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_FLOAT_(MIN_ALIGN)			/* minimum */,
	_GSI_VU_FLOAT_(0.5)				/* v_default */,
	_GSI_VU_FLOAT_(MAX_ALIGN)			/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_frame_S, yalign)		/* field_offset */,
},
};


/*	Box
*/
static	const	gsi_field_info_S	Box_fields[]={
{
	GSI_FIELD_BOOLEAN				/* field_type */,
	"homogeneous"					/* field_name */,
	GB_OPT_REBUILD					/* field_flags */,
	_GSI_VU_BOOLEAN_(FALSE)				/* minimum */,
	_GSI_VU_BOOLEAN_(FALSE)				/* v_default */,
	_GSI_VU_BOOLEAN_(TRUE)				/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_box_S, homogeneous)	/* field_offset */,
},
{
	GSI_FIELD_INT					/* field_type */,
	"spacing"					/* field_name */,
	GB_OPT_REBUILD					/* field_flags */,
	_GSI_VU_INT_(0)					/* minimum */,
	_GSI_VU_INT_(5)					/* v_default */,
	_GSI_VU_INT_(MAX_SPACING)			/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_box_S, spacing)		/* field_offset */,
},
};


/*	Table
*/
static	const	gsi_field_info_S	Table_fields[]={
{
	GSI_FIELD_BOOLEAN				/* field_type */,
	"homogeneous"					/* field_name */,
	GB_OPT_REBUILD					/* field_flags */,
	_GSI_VU_BOOLEAN_(FALSE)				/* minimum */,
	_GSI_VU_BOOLEAN_(FALSE)				/* v_default */,
	_GSI_VU_BOOLEAN_(TRUE)				/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_table_S, homogeneous)	/* field_offset */,
},
{
	GSI_FIELD_INT					/* field_type */,
	"rows"						/* field_name */,
	GB_OPT_REBUILD					/* field_flags */,
	_GSI_VU_INT_(1)					/* minimum */,
	_GSI_VU_INT_(5)					/* v_default */,
	_GSI_VU_INT_(MAX_ROWS)				/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_table_S, rows)		/* field_offset */,
},
{
	GSI_FIELD_INT					/* field_type */,
	"columns"					/* field_name */,
	GB_OPT_REBUILD					/* field_flags */,
	_GSI_VU_INT_(1)					/* minimum */,
	_GSI_VU_INT_(5)					/* v_default */,
	_GSI_VU_INT_(MAX_COLS)				/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_table_S, columns)		/* field_offset */,
},
{
	GSI_FIELD_INT					/* field_type */,
	"row_spacing"					/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_INT_(0)					/* minimum */,
	_GSI_VU_INT_(1)					/* v_default */,
	_GSI_VU_INT_(MAX_SPACING)			/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_table_S, row_spacing)	/* field_offset */,
},
{
	GSI_FIELD_INT					/* field_type */,
	"col_spacing"					/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_INT_(0)					/* minimum */,
	_GSI_VU_INT_(1)					/* v_default */,
	_GSI_VU_INT_(MAX_SPACING)			/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_table_S, col_spacing)	/* field_offset */,
},
};


/*	Notebook
*/
static	const	gsi_field_info_S	Notebook_fields[]={
{
	GSI_FIELD_INT					/* field_type */,
	"initial_page"					/* field_name */,
	GB_OPT_REBUILD					/* field_flags */,
	_GSI_VU_BITS_(0)				/* minimum */,
	_GSI_VU_BITS_(0)				/* v_default */,
	_GSI_VU_BITS_(MAX_PAGES)			/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_notebook_S, initial_page)	/* field_offset */,
},
{
	GSI_FIELD_ENUM					/* field_type */,
	"tab_position"					/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_ENUM_(GTK_POS_LEFT)			/* minimum */,
	_GSI_VU_ENUM_(GTK_POS_TOP)			/* v_default */,
	_GSI_VU_ENUM_(GTK_POS_BOTTOM)			/* maximum */,
	_GSI_FIELD_FUNC_(String_GtkPositionType)	/* field_func */,
	_GSI_OFFSET_(gb_wdat_notebook_S, tab_position)	/* field_offset */,
},
{
	GSI_FIELD_BOOLEAN				/* field_type */,
	"show_tabs"					/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_BOOLEAN_(FALSE)				/* minimum */,
	_GSI_VU_BOOLEAN_(TRUE)				/* v_default */,
	_GSI_VU_BOOLEAN_(TRUE)				/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_notebook_S, show_tabs)	/* field_offset */,
},
{
	GSI_FIELD_BOOLEAN				/* field_type */,
	"show_border"					/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_BOOLEAN_(FALSE)				/* minimum */,
	_GSI_VU_BOOLEAN_(TRUE)				/* v_default */,
	_GSI_VU_BOOLEAN_(TRUE)				/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_notebook_S, show_border)	/* field_offset */,
},
};



/*	List
*/
static	const	gsi_field_info_S	List_fields[]={
{
	GSI_FIELD_ENUM					/* field_type */,
	"select_mode"					/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_ENUM_(GTK_SELECTION_SINGLE)		/* minimum */,
	_GSI_VU_ENUM_(GTK_SELECTION_SINGLE)		/* v_default */,
	_GSI_VU_ENUM_(GTK_SELECTION_EXTENDED)		/* maximum */,
	_GSI_FIELD_FUNC_(String_GtkSelectionMode)	/* field_func */,
	_GSI_OFFSET_(gb_wdat_list_S, select_mode)	/* field_offset */,
},
};


/*	Scrolled Window
*/
static	const	gsi_field_info_S	ScrolledWindow_fields[]={
{
	GSI_FIELD_ENUM					/* field_type */,
	"hscrollbar_policy"				/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_ENUM_(GTK_POLICY_ALWAYS)		/* minimum */,
	_GSI_VU_ENUM_(GTK_POLICY_ALWAYS)		/* v_default */,
	_GSI_VU_ENUM_(GTK_POLICY_AUTOMATIC)		/* maximum */,
	_GSI_FIELD_FUNC_(String_GtkPolicyType)		/* field_func */,
	_GSI_OFFSET_(gb_wdat_scrolled_window_S,
		 hscrollbar_policy)			/* field_offset */,
},
{
	GSI_FIELD_ENUM					/* field_type */,
	"vscrollbar_policy"				/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_ENUM_(GTK_POLICY_ALWAYS)		/* minimum */,
	_GSI_VU_ENUM_(GTK_POLICY_AUTOMATIC)		/* v_default */,
	_GSI_VU_ENUM_(GTK_POLICY_AUTOMATIC)		/* maximum */,
	_GSI_FIELD_FUNC_(String_GtkPolicyType)		/* field_func */,
	_GSI_OFFSET_(gb_wdat_scrolled_window_S,
		 vscrollbar_policy)			/* field_offset */,
},
};


/*	ProgressBar
*/
static	const	gsi_field_info_S	ProgressBar_fields[]={
{
	GSI_FIELD_FLOAT					/* field_type */,
	"init_percentage"				/* field_name */,
	GB_OPT_REBUILD					/* field_flags */,
	_GSI_VU_FLOAT_(0)				/* minimum */,
	_GSI_VU_FLOAT_(0)				/* v_default */,
	_GSI_VU_FLOAT_(1)				/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_progress_bar_S,
		 init_percentage)			/* field_offset */,
},
};


/*	Arrow
*/
static	const	gsi_field_info_S	Arrow_fields[]={
{
	GSI_FIELD_ENUM					/* field_type */,
	"arrow_type"					/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_ENUM_(GTK_ARROW_UP)			/* minimum */,
	_GSI_VU_ENUM_(GTK_ARROW_UP)			/* v_default */,
	_GSI_VU_ENUM_(GTK_ARROW_RIGHT)			/* maximum */,
	_GSI_FIELD_FUNC_(String_GtkArrowType)		/* field_func */,
	_GSI_OFFSET_(gb_wdat_arrow_S, arrow_type)	/* field_offset */,
},
{
	GSI_FIELD_ENUM					/* field_type */,
	"shadow_type"					/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_ENUM_(GTK_SHADOW_IN)			/* minimum */,
	_GSI_VU_ENUM_(GTK_SHADOW_OUT)			/* v_default */,
	_GSI_VU_ENUM_(GTK_SHADOW_OUT)			/* maximum */,
	_GSI_FIELD_FUNC_(String_GtkShadowType)		/* field_func */,
	_GSI_OFFSET_(gb_wdat_arrow_S, shadow_type)	/* field_offset */,
},
};


/*	ListItem
*/
static	const	gsi_field_info_S	ListItem_fields[]={
{
	GSI_FIELD_STRING				/* field_type */,
	"label"						/* field_name */,
	GSI_OPT_STRING_FUNCTION		|
	  GB_OPT_STRING_IS_CHILD	|
	  GB_OPT_REBUILD				/* field_flags */,
	_GSI_VU_STRING_(NULL)				/* minimum */,
	_GSI_VU_STRING_(NULL)				/* v_default */,
	_GSI_VU_STRING_(NULL)				/* maximum */,
	_GSI_FIELD_FUNC_(widget_data_symbol_name_get)	/* field_func */,
	_GSI_OFFSET_(gb_wdat_list_item_S,
		 label)					/* field_offset */,
},
};


/*	DrawingArea
*/
static	const	gsi_field_info_S	DrawingArea_fields[]={
{
	GSI_FIELD_INT					/* field_type */,
	"req_width"					/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_INT_(0)					/* minimum */,
	_GSI_VU_INT_(1)					/* v_default */,
	_GSI_VU_INT_(MAX_SIZE)				/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_drawing_area_S,
	  req_width)					/* field_offset */,
},
{
	GSI_FIELD_INT					/* field_type */,
	"req_height"					/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_INT_(0)					/* minimum */,
	_GSI_VU_INT_(1)					/* v_default */,
	_GSI_VU_INT_(MAX_SIZE)				/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_drawing_area_S,
	  req_height)					/* field_offset */,
},
};


/*	Scale
*/
static	const	gsi_field_info_S	Scale_fields[]={
{
	GSI_FIELD_BOOLEAN				/* field_type */,
	"draw_value"					/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_BOOLEAN_(FALSE)				/* minimum */,
	_GSI_VU_BOOLEAN_(FALSE)				/* v_default */,
	_GSI_VU_BOOLEAN_(TRUE)				/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_scale_S,
	  draw_value)					/* field_offset */,
},
{
	GSI_FIELD_ENUM					/* field_type */,
	"value_pos"					/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_ENUM_(GTK_POS_LEFT)			/* minimum */,
	_GSI_VU_ENUM_(GTK_POS_TOP)			/* v_default */,
	_GSI_VU_ENUM_(GTK_POS_BOTTOM)			/* maximum */,
	_GSI_FIELD_FUNC_(String_GtkPositionType)	/* field_func */,
	_GSI_OFFSET_(gb_wdat_scale_S,
	  value_pos)					/* field_offset */,
},
{
	GSI_FIELD_ENUM					/* field_type */,
	"update_policy"					/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_ENUM_(GTK_UPDATE_CONTINUOUS)		/* minimum */,
	_GSI_VU_ENUM_(GTK_UPDATE_CONTINUOUS)		/* v_default */,
	_GSI_VU_ENUM_(GTK_UPDATE_DELAYED)		/* maximum */,
	_GSI_FIELD_FUNC_(String_GtkUpdateType)		/* field_func */,
	_GSI_OFFSET_(gb_wdat_scale_S,
	  update_policy)				/* field_offset */,
},
{
	GSI_FIELD_INT					/* field_type */,
	"digits"					/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_INT_(0)					/* minimum */,
	_GSI_VU_INT_(1)					/* v_default */,
	_GSI_VU_INT_(MAX_DIGITS)			/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_scale_S,
	  digits)					/* field_offset */,
},
{
	GSI_FIELD_STRUCT_LINK				/* field_type */,
	"adjustment"					/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_STRUCT_LINK_(NULL)			/* minimum */,
	_GSI_VU_STRUCT_LINK_(NULL)			/* v_default */,
	_GSI_VU_STRUCT_LINK_(NULL)			/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_scale_S,
		 adjustment)				/* field_offset */,
},
};


/*	Ruler
*/
static	const	gsi_field_info_S	Ruler_fields[]={
{
	GSI_FIELD_ENUM					/* field_type */,
	"metric"					/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_ENUM_(GTK_PIXELS)			/* minimum */,
	_GSI_VU_ENUM_(GTK_PIXELS)			/* v_default */,
	_GSI_VU_ENUM_(GTK_CENTIMETERS)			/* maximum */,
	_GSI_FIELD_FUNC_(String_GtkMetricType)		/* field_func */,
	_GSI_OFFSET_(gb_wdat_ruler_S,
	  metric)					/* field_offset */,
},
{
	GSI_FIELD_FLOAT					/* field_type */,
	"lower"						/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_FLOAT_(MIN_RULER)			/* minimum */,
	_GSI_VU_FLOAT_(0)				/* v_default */,
	_GSI_VU_FLOAT_(MAX_RULER)			/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_ruler_S, lower)		/* field_offset */,
},
{
	GSI_FIELD_FLOAT					/* field_type */,
	"upper"						/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_FLOAT_(MIN_RULER)			/* minimum */,
	_GSI_VU_FLOAT_(1)				/* v_default */,
	_GSI_VU_FLOAT_(MAX_RULER)			/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_ruler_S, upper)		/* field_offset */,
},
{
	GSI_FIELD_FLOAT					/* field_type */,
	"position"					/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_FLOAT_(MIN_RULER)			/* minimum */,
	_GSI_VU_FLOAT_(0)				/* v_default */,
	_GSI_VU_FLOAT_(MAX_RULER)			/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_ruler_S, position)		/* field_offset */,
},
{
	GSI_FIELD_FLOAT					/* field_type */,
	"max_size"					/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_FLOAT_(MIN_RULER)			/* minimum */,
	_GSI_VU_FLOAT_(0)				/* v_default */,
	_GSI_VU_FLOAT_(MAX_RULER)			/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_ruler_S, max_size)		/* field_offset */,
},
};


/*	Window
*/
static	const	gsi_field_info_S	Window_fields[]={
{
	GSI_FIELD_STRING				/* field_type */,
	"title"						/* field_name */,
	GSI_OPT_STRING_NONNULL		|
	  GSI_OPT_STRING_FUNCTION			/* field_flags */,
	_GSI_VU_STRING_(NULL)				/* minimum */,
	_GSI_VU_STRING_(NULL)				/* v_default */,
	_GSI_VU_STRING_(NULL)				/* maximum */,
	_GSI_FIELD_FUNC_(widget_data_symbol_name_get)	/* field_func */,
	_GSI_OFFSET_(gb_wdat_window_S, title)		/* field_offset */,
},
{
	GSI_FIELD_ENUM					/* field_type */,
	"win_type"					/* field_name */,
	GB_OPT_REBUILD					/* field_flags */,
	_GSI_VU_ENUM_(GTK_WINDOW_TOPLEVEL)		/* minimum */,
	_GSI_VU_ENUM_(GTK_WINDOW_TOPLEVEL)		/* v_default */,
	_GSI_VU_ENUM_(GTK_WINDOW_POPUP)			/* maximum */,
	_GSI_FIELD_FUNC_(String_GtkWindowType)		/* field_func */,
	_GSI_OFFSET_(gb_wdat_window_S, win_type)	/* field_offset */,
},
{
	GSI_FIELD_ENUM					/* field_type */,
	"win_position"					/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_ENUM_(GTK_WIN_POS_NONE)			/* minimum */,
	_GSI_VU_ENUM_(GTK_WIN_POS_NONE)			/* v_default */,
	_GSI_VU_ENUM_(GTK_WIN_POS_MOUSE)		/* maximum */,
	_GSI_FIELD_FUNC_(String_GtkWindowPosition)	/* field_func */,
	_GSI_OFFSET_(gb_wdat_window_S,
		 win_position)				/* field_offset */,
},
{
	GSI_FIELD_BITS					/* field_type */,
	"resize_policy"					/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_BITS_(0)				/* minimum */,
	_GSI_VU_BITS_(GB_ALLOW_GROW)			/* v_default */,
	_GSI_VU_BITS_(	GB_ALLOW_SHRINK	|
			GB_ALLOW_GROW	|
			GB_AUTO_SHRINK  )		/* maximum */,
	_GSI_FIELD_FUNC_(String_GbResizePolicy)		/* field_func */,
	_GSI_OFFSET_(gb_wdat_window_S,
		 resize_policy)				/* field_offset */,
},
{
	GSI_FIELD_BOOLEAN				/* field_type */,
	"auto_build"					/* field_name */,
	GSI_OPT_NONE					/* field_flags */,
	_GSI_VU_BOOLEAN_(FALSE)				/* minimum */,
	_GSI_VU_BOOLEAN_(TRUE)				/* v_default */,
	_GSI_VU_BOOLEAN_(TRUE)				/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_window_S, auto_build)	/* field_offset */,
},
};


/*	File Selection
*/
static	const	gsi_field_info_S	FileSelection_fields[]={
{
	GSI_FIELD_STRING				/* field_type */,
	"filename"					/* field_name */,
	GSI_OPT_STRING_DEFAULTS				/* field_flags */,
	_GSI_VU_STRING_(NULL)				/* minimum */,
	_GSI_VU_STRING_(NULL)				/* v_default */,
	_GSI_VU_STRING_(NULL)				/* maximum */,
	_GSI_FIELD_FUNC_(NULL)				/* field_func */,
	_GSI_OFFSET_(gb_wdat_file_selection_S,
	  filename)					/* field_offset */,
},
};



/* --- auxillary structure info structures --- */


/*	LinkageBox
*/
static	const	gsi_struct_info_S	LinkageBox={
	GB_LINKAGE_BOX					/* struct_type */,
	"linkage_box"					/* struct_name */,
	GB_FLAG_HIDDEN					/* struct_flags */,
	sizeof(gb_linkage_box_S)			/* struct_size */,
	NULL						/* parent */,
	sizeof(LinkageBox_fields)/
	  sizeof(gsi_field_info_S)			/* n_fields */,
	LinkageBox_fields				/* fields */,
	0						/* widget_child_count */,
};


/*	LinkageTable
*/
static	const	gsi_struct_info_S	LinkageTable={
	GB_LINKAGE_TABLE				/* struct_type */,
	"linkage_table"					/* struct_name */,
	GB_FLAG_HIDDEN					/* struct_flags */,
	sizeof(gb_linkage_table_S)			/* struct_size */,
	NULL						/* parent */,
	sizeof(LinkageTable_fields)/
	  sizeof(gsi_field_info_S)			/* n_fields */,
	LinkageTable_fields				/* fields */,
	0						/* widget_child_count */,
};


/*	LinkageNotebook
*/
static	const	gsi_struct_info_S	LinkageNotebook={
	GB_LINKAGE_NOTEBOOK				/* struct_type */,
	"linkage_notebook"				/* struct_name */,
	GB_FLAG_HIDDEN					/* struct_flags */,
	sizeof(gb_linkage_notebook_S)			/* struct_size */,
	NULL						/* parent */,
	sizeof(LinkageNotebook_fields)/
	  sizeof(gsi_field_info_S)			/* n_fields */,
	LinkageNotebook_fields				/* fields */,
	0						/* widget_child_count */,
};


/* --- object info structures --- */


/*	Object
*/
static	const	gsi_struct_info_S	Object={
	GB_OBJECT					/* struct_type */,
	"object"					/* struct_name */,
	GB_FLAG_BASE_TYPE	|
	  GB_FLAG_HIDDEN				/* struct_flags */,
	sizeof(gb_objdat_S)				/* struct_size */,
	NULL						/* parent */,
	sizeof(Object_fields)/
	  sizeof(gsi_field_info_S)			/* n_fields */,
	Object_fields					/* fields */,
	0						/* widget_child_count */,
};


/*	Widget
*/
static	const	gsi_struct_info_S	Widget={
	GB_WIDGET_BASE					/* struct_type */,
	"base"						/* struct_name */,
	GB_FLAG_BASE_TYPE				/* struct_flags */,
	sizeof(gb_wdat_base_S)				/* struct_size */,
	&Object						/* parent */,
	sizeof(Widget_fields)/
	  sizeof(gsi_field_info_S)			/* n_fields */,
	Widget_fields					/* fields */,
	0						/* widget_child_count */,
};


/*	Misc
*/
static	const	gsi_struct_info_S	Misc={
	GB_WIDGET_MISC					/* struct_type */,
	"misc"						/* struct_name */,
	GB_FLAG_BASE_TYPE				/* struct_flags */,
	sizeof(gb_wdat_misc_S)				/* struct_size */,
	&Widget						/* parent */,
	sizeof(Misc_fields)/
	  sizeof(gsi_field_info_S)			/* n_fields */,
	Misc_fields					/* fields */,
	0						/* widget_child_count */,
};


/*	Separator
*/
static	const	gsi_struct_info_S	Separator={
	GB_WIDGET_SEPARATOR				/* struct_type */,
	"separator"					/* struct_name */,
	GB_FLAG_BASE_TYPE				/* struct_flags */,
	sizeof(gb_wdat_separator_S)			/* struct_size */,
	&Widget						/* parent */,
	0						/* n_fields */,
	NULL						/* fields */,
	0						/* widget_child_count */,
};


/*	Container
*/
static	const	gsi_struct_info_S	Container={
	GB_WIDGET_CONTAINER				/* struct_type */,
	"container"					/* struct_name */,
	GB_FLAG_BASE_TYPE				/* struct_flags */,
	sizeof(gb_wdat_container_S)			/* struct_size */,
	&Widget						/* parent */,
	sizeof(Container_fields)/
	  sizeof(gsi_field_info_S)			/* n_fields */,
	Container_fields				/* fields */,
	0						/* widget_child_count */,
};


/*	Bin
*/
static	const	gsi_struct_info_S	Bin={
	GB_WIDGET_BIN					/* struct_type */,
	"bin"						/* struct_name */,
	GB_FLAG_BASE_TYPE				/* struct_flags */,
	sizeof(gb_wdat_bin_S)				/* struct_size */,
	&Container					/* parent */,
	0						/* n_fields */,
	NULL						/* fields */,
	0						/* widget_child_count */,
};


/*	Item
*/
static	const	gsi_struct_info_S	Item={
	GB_WIDGET_ITEM					/* struct_type */,
	"item"						/* struct_name */,
	GB_FLAG_BASE_TYPE				/* struct_flags */,
	sizeof(gb_wdat_item_S)				/* struct_size */,
	&Bin						/* parent */,
	0						/* n_fields */,
	NULL						/* fields */,
	0						/* widget_child_count */,
};


/*	Box
*/
static	const	gsi_struct_info_S	Box={
	GB_WIDGET_BOX					/* struct_type */,
	"box"						/* struct_name */,
	GB_FLAG_BASE_TYPE				/* struct_flags */,
	sizeof(gb_wdat_box_S)				/* struct_size */,
	&Container					/* parent */,
	sizeof(Box_fields)/
	  sizeof(gsi_field_info_S)			/* n_fields */,
	Box_fields					/* fields */,
	0						/* widget_child_count */,
};


/*	Label
*/
static	const	gsi_struct_info_S	Label={
	GB_WIDGET_LABEL					/* struct_type */,
	"label"						/* struct_name */,
	GSI_FLAG_NONE					/* struct_flags */,
	sizeof(gb_wdat_label_S)				/* struct_size */,
	&Misc						/* parent */,
	sizeof(Label_fields)/
	  sizeof(gsi_field_info_S)			/* n_fields */,
	Label_fields					/* fields */,
	0						/* widget_child_count */,
};


/*	Entry
*/
static	const	gsi_struct_info_S	Entry={
	GB_WIDGET_ENTRY					/* struct_type */,
	"entry"						/* struct_name */,
	GSI_FLAG_NONE					/* struct_flags */,
	sizeof(gb_wdat_entry_S)				/* struct_size */,
	&Widget						/* parent */,
	sizeof(Entry_fields)/
	  sizeof(gsi_field_info_S)			/* n_fields */,
	Entry_fields					/* fields */,
	0						/* widget_child_count */,
};


/*	H_Separator
*/
static	const	gsi_struct_info_S	H_Separator={
	GB_WIDGET_H_SEPARATOR				/* struct_type */,
	"h_separator"					/* struct_name */,
	GSI_FLAG_NONE					/* struct_flags */,
	sizeof(gb_wdat_h_separator_S)			/* struct_size */,
	&Separator					/* parent */,
	0						/* n_fields */,
	NULL						/* fields */,
	0						/* widget_child_count */,
};


/*	V_Separator
*/
static	const	gsi_struct_info_S	V_Separator={
	GB_WIDGET_V_SEPARATOR				/* struct_type */,
	"v_separator"					/* struct_name */,
	GSI_FLAG_NONE					/* struct_flags */,
	sizeof(gb_wdat_v_separator_S)			/* struct_size */,
	&Separator					/* parent */,
	0						/* n_fields */,
	NULL						/* fields */,
	0						/* widget_child_count */,
};


/*	ListItem
*/
static	const	gsi_struct_info_S	ListItem={
	GB_WIDGET_LIST_ITEM				/* struct_type */,
	"list_item"					/* struct_name */,
	GSI_FLAG_NONE					/* struct_flags */,
	sizeof(gb_wdat_list_item_S)			/* struct_size */,
	&Item						/* parent */,
	sizeof(ListItem_fields)/
	  sizeof(gsi_field_info_S)			/* n_fields */,
	ListItem_fields					/* fields */,
	1						/* widget_child_count */,
};


/*	Button
*/
static	const	gsi_struct_info_S	Button={
	GB_WIDGET_BUTTON				/* struct_type */,
	"button"					/* struct_name */,
	GSI_FLAG_NONE					/* struct_flags */,
	sizeof(gb_wdat_button_S)			/* struct_size */,
	&Container					/* parent */,
	sizeof(Button_fields)/
	  sizeof(gsi_field_info_S)			/* n_fields */,
	Button_fields					/* fields */,
	1						/* widget_child_count */,
};


/*	ToggleButton
*/
static	const	gsi_struct_info_S	ToggleButton={
	GB_WIDGET_TOGGLE_BUTTON				/* struct_type */,
	"toggle_button"					/* struct_name */,
	GSI_FLAG_NONE					/* struct_flags */,
	sizeof(gb_wdat_toggle_button_S)			/* struct_size */,
	&Button						/* parent */,
	sizeof(ToggleButton_fields)/
	  sizeof(gsi_field_info_S)			/* n_fields */,
	ToggleButton_fields				/* fields */,
	1						/* widget_child_count */,
};


/*	CheckButton
*/
static	const	gsi_struct_info_S	CheckButton={
	GB_WIDGET_CHECK_BUTTON				/* struct_type */,
	"check_button"					/* struct_name */,
	GSI_FLAG_NONE					/* struct_flags */,
	sizeof(gb_wdat_check_button_S)			/* struct_size */,
	&ToggleButton					/* parent */,
	0						/* n_fields */,
	NULL						/* fields */,
	1						/* widget_child_count */,
};


/*	RadioButton
*/
static	const	gsi_struct_info_S	RadioButton={
	GB_WIDGET_RADIO_BUTTON				/* struct_type */,
	"radio_button"					/* struct_name */,
	GSI_FLAG_NONE					/* struct_flags */,
	sizeof(gb_wdat_radio_button_S)			/* struct_size */,
	&CheckButton					/* parent */,
	sizeof(RadioButton_fields)/
	  sizeof(gsi_field_info_S)			/* n_fields */,
	RadioButton_fields				/* fields */,
	1						/* widget_child_count */,
};


/*	Frame
*/
static	const	gsi_struct_info_S	Frame={
	GB_WIDGET_FRAME					/* struct_type */,
	"frame"						/* struct_name */,
	GSI_FLAG_NONE					/* struct_flags */,
	sizeof(gb_wdat_frame_S)				/* struct_size */,
	&Bin						/* parent */,
	sizeof(Frame_fields)/
	  sizeof(gsi_field_info_S)			/* n_fields */,
	Frame_fields					/* fields */,
	1						/* widget_child_count */,
};


/*	Table
*/
static	const	gsi_struct_info_S	Table={
	GB_WIDGET_TABLE					/* struct_type */,
	"table"						/* struct_name */,
	GSI_FLAG_NONE					/* struct_flags */,
	sizeof(gb_wdat_table_S)				/* struct_size */,
	&Container					/* parent */,
	sizeof(Table_fields)/
	  sizeof(gsi_field_info_S)			/* n_fields */,
	Table_fields					/* fields */,
	MAX_CHILDREN					/* widget_child_count */,
};


/*	Notebook
*/
static	const	gsi_struct_info_S	Notebook={
	GB_WIDGET_NOTEBOOK				/* struct_type */,
	"notebook"					/* struct_name */,
	GSI_FLAG_NONE					/* struct_flags */,
	sizeof(gb_wdat_notebook_S)			/* struct_size */,
	&Container					/* parent */,
	sizeof(Notebook_fields)/
	  sizeof(gsi_field_info_S)			/* n_fields */,
	Notebook_fields					/* fields */,
	MAX_CHILDREN					/* widget_child_count */,
};


/*	H_Box
*/
static	const	gsi_struct_info_S	H_Box={
	GB_WIDGET_H_BOX					/* struct_type */,
	"h_box"						/* struct_name */,
	GSI_FLAG_NONE					/* struct_flags */,
	sizeof(gb_wdat_h_box_S)				/* struct_size */,
	&Box						/* parent */,
	0						/* n_fields */,
	NULL						/* fields */,
	MAX_CHILDREN					/* widget_child_count */,
};


/*	V_Box
*/
static	const	gsi_struct_info_S	V_Box={
	GB_WIDGET_V_BOX					/* struct_type */,
	"v_box"						/* struct_name */,
	GSI_FLAG_NONE					/* struct_flags */,
	sizeof(gb_wdat_v_box_S)				/* struct_size */,
	&Box						/* parent */,
	0						/* n_fields */,
	NULL						/* fields */,
	MAX_CHILDREN					/* widget_child_count */,
};


/*	List
*/
static	const	gsi_struct_info_S	List={
	GB_WIDGET_LIST					/* struct_type */,
	"list"						/* struct_name */,
	GSI_FLAG_NONE					/* struct_flags */,
	sizeof(gb_wdat_list_S)				/* struct_size */,
	&Container					/* parent */,
	sizeof(List_fields)/
	  sizeof(gsi_field_info_S)			/* n_fields */,
	List_fields					/* fields */,
	MAX_CHILDREN					/* widget_child_count */,
};


/*	ScrolledWindow
*/
static	const	gsi_struct_info_S	ScrolledWindow={
	GB_WIDGET_SCROLLED_WINDOW			/* struct_type */,
	"scrolled_window"				/* struct_name */,
	GSI_FLAG_NONE					/* struct_flags */,
	sizeof(gb_wdat_scrolled_window_S)		/* struct_size */,
	&Container					/* parent */,
	sizeof(ScrolledWindow_fields)/
	  sizeof(gsi_field_info_S)			/* n_fields */,
	ScrolledWindow_fields				/* fields */,
	1						/* widget_child_count */,
};


/*	ProgressBar
*/
static	const	gsi_struct_info_S	ProgressBar={
	GB_WIDGET_PROGRESS_BAR				/* struct_type */,
	"progress_bar"					/* struct_name */,
	GSI_FLAG_NONE					/* struct_flags */,
	sizeof(gb_wdat_progress_bar_S)			/* struct_size */,
	&Widget						/* parent */,
	sizeof(ProgressBar_fields)/
	  sizeof(gsi_field_info_S)			/* n_fields */,
	ProgressBar_fields				/* fields */,
	0						/* widget_child_count */,
};


/*	Arrow
*/
static	const	gsi_struct_info_S	Arrow={
	GB_WIDGET_ARROW					/* struct_type */,
	"arrow"						/* struct_name */,
	GSI_FLAG_NONE					/* struct_flags */,
	sizeof(gb_wdat_arrow_S)				/* struct_size */,
	&Misc						/* parent */,
	sizeof(Arrow_fields)/
	  sizeof(gsi_field_info_S)			/* n_fields */,
	Arrow_fields					/* fields */,
	0						/* widget_child_count */,
};


/*	DrawingArea
*/
static	const	gsi_struct_info_S	DrawingArea={
	GB_WIDGET_DRAWING_AREA				/* struct_type */,
	"drawing_area"					/* struct_name */,
	GSI_FLAG_NONE					/* struct_flags */,
	sizeof(gb_wdat_drawing_area_S)			/* struct_size */,
	&Widget						/* parent */,
	sizeof(DrawingArea_fields)/
	  sizeof(gsi_field_info_S)			/* n_fields */,
	DrawingArea_fields				/* fields */,
	0						/* widget_child_count */,
};


/*	Scale
*/
static	const	gsi_struct_info_S	Scale={
	GB_WIDGET_SCALE					/* struct_type */,
	"scale"						/* struct_name */,
	GB_FLAG_BASE_TYPE	|
	  GB_FLAG_HIDDEN				/* struct_flags */,
	sizeof(gb_wdat_scale_S)				/* struct_size */,
	&Widget						/* parent */,
	sizeof(Scale_fields)/
	  sizeof(gsi_field_info_S)			/* n_fields */,
	Scale_fields					/* fields */,
	0						/* widget_child_count */,
};


/*	H_Scale
*/
static	const	gsi_struct_info_S	H_Scale={
	GB_WIDGET_H_SCALE				/* struct_type */,
	"h_scale"					/* struct_name */,
	GB_FLAG_HIDDEN					/* struct_flags */,
	sizeof(gb_wdat_h_scale_S)			/* struct_size */,
	&Scale						/* parent */,
	0						/* n_fields */,
	NULL						/* fields */,
	0						/* widget_child_count */,
};


/*	V_Scale
*/
static	const	gsi_struct_info_S	V_Scale={
	GB_WIDGET_V_SCALE				/* struct_type */,
	"v_scale"					/* struct_name */,
	GB_FLAG_HIDDEN					/* struct_flags */,
	sizeof(gb_wdat_v_scale_S)			/* struct_size */,
	&Scale						/* parent */,
	0						/* n_fields */,
	NULL						/* fields */,
	0						/* widget_child_count */,
};


/*	Ruler
*/
static	const	gsi_struct_info_S	Ruler={
	GB_WIDGET_RULER					/* struct_type */,
	"ruler"						/* struct_name */,
	GB_FLAG_BASE_TYPE				/* struct_flags */,
	sizeof(gb_wdat_ruler_S)				/* struct_size */,
	&Widget						/* parent */,
	sizeof(Ruler_fields)/
	  sizeof(gsi_field_info_S)			/* n_fields */,
	Ruler_fields					/* fields */,
	0						/* widget_child_count */,
};


/*	H_Ruler
*/
static	const	gsi_struct_info_S	H_Ruler={
	GB_WIDGET_H_RULER				/* struct_type */,
	"h_ruler"					/* struct_name */,
	GSI_FLAG_NONE					/* struct_flags */,
	sizeof(gb_wdat_h_ruler_S)			/* struct_size */,
	&Ruler						/* parent */,
	0						/* n_fields */,
	NULL						/* fields */,
	0						/* widget_child_count */,
};


/*	V_Ruler
*/
static	const	gsi_struct_info_S	V_Ruler={
	GB_WIDGET_V_RULER				/* struct_type */,
	"v_ruler"					/* struct_name */,
	GSI_FLAG_NONE					/* struct_flags */,
	sizeof(gb_wdat_v_ruler_S)			/* struct_size */,
	&Ruler						/* parent */,
	0						/* n_fields */,
	NULL						/* fields */,
	0						/* widget_child_count */,
};


/*	Window
*/
static	const	gsi_struct_info_S	Window={
	GB_WIDGET_WINDOW				/* struct_type */,
	"window"					/* struct_name */,
	GSI_FLAG_NONE					/* struct_flags */,
	sizeof(gb_wdat_window_S)			/* struct_size */,
	&Bin						/* parent */,
	sizeof(Window_fields)/
	  sizeof(gsi_field_info_S)			/* n_fields */,
	Window_fields					/* fields */,
	1						/* widget_child_count */,
};


/*	File Selection
*/
static	const	gsi_struct_info_S	FileSelection={
	GB_WIDGET_FILE_SELECTION			/* struct_type */,
	"file_selection"				/* struct_name */,
	GSI_FLAG_NONE					/* struct_flags */,
	sizeof(gb_wdat_file_selection_S)		/* struct_size */,
	&Window						/* parent */,
	sizeof(FileSelection_fields)/
	  sizeof(gsi_field_info_S)			/* n_fields */,
	FileSelection_fields				/* fields */,
	MAX_CHILDREN					/* widget_child_count */,
};


/* --- gsi_struct_info_S pointers --- */
const	gsi_struct_info_S	*gsi_struc_info_list[]={
	&LinkageBox,
	&LinkageTable,
	&LinkageNotebook,
	&Object,
	&Frame,
	&Widget,
	&Misc,
	&Container,
	&Bin,
	&Label,
	&Entry,
	&Separator,
	&H_Separator,
	&V_Separator,
	&Item,
	&ListItem,
	&Button,
	&ToggleButton,
	&CheckButton,
	&RadioButton,
	&Table,
	&Notebook,
	&Box,
	&H_Box,
	&V_Box,
	&List,
	&ScrolledWindow,
	&ProgressBar,
	&Arrow,
	&DrawingArea,
	&Scale,
	&H_Scale,
	&V_Scale,
	&Ruler,
	&H_Ruler,
	&V_Ruler,
	&Window,
	&FileSelection,
	NULL,
};



/* --- signal handler structure field information --- */
struct	gb_signal_handler_field_info_S	gb_signal_handler_field_info[GB_SIGH_N_FIELDS]={
{
	/* GB_SIGH_SIGNAL_NAME_INDX: */
	"signal_name",
	"gb_sigh_signal_name_key"
},
{
	/* GB_SIGH_FUNC_NAME_INDX: */
	"handler_func",
	"gb_sigh_handler_func_key"
},
{
	/* GB_SIGH_DATA_NAME_INDX: */
	"data",
	"gb_sigh_data_key"
},
{
	/* GB_SIGH_CONNECT_OPTIONS_INDX: */
	"connect_options",
	"gb_sigh_connect_options_key"
},
};
gchar	*gb_signal_handler_struct_name="signal_handler";
