/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997  Tim Janik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include	"RCS.h"
RCS_ID("$Id: type2str.c,v 1.6 1997/05/09 16:50:16 tim Exp tim $")


#define		__type2str_c__

#include	"type2str.h"
#include	"misc.h"



/* --- variables --- */
static	gchar	char_buffer[128];



/* --- functions --- */
const char*
String_gb_connect_options_E	(const	guint32	value,
				 const	guint32	bit_mask)
{
	register char	*String;

	switch (value & bit_mask) {
	case	GB_CONNECT_DATA_POINTER:
		String="GB_CONNECT_DATA_POINTER";
		break;

	case	GB_CONNECT_AFTER:
		String="GB_CONNECT_AFTER";
		break;

	case	GB_CONNECT_OBJECT:
		String="GB_CONNECT_OBJECT";
		break;

	case	GB_CONNECT:
		String="GB_CONNECT";
		break;

	default:
		g_warning("%s\nunknown value for gb_connect_options_E: `%d'",
			  FUNCNAME,
			  value);
		sprintf(char_buffer, "%d", value);
		String=char_buffer;
		break;
	}
	
	return String;
}


const char*
String_GbResizePolicy		(const	guint32	value,
				 gboolean	descriptive)
{
	register char	*String;

	switch (value) {
	
	case	GB_ALLOW_SHRINK:
		if (descriptive)
			String="allow shrinking";
		else
			String="GB_ALLOW_SHRINK";
		break;
	
	case	GB_ALLOW_GROW:
		if (descriptive)
			String="allow growing";
		else
			String="GB_ALLOW_GROW";
		break;
	
	case	GB_AUTO_SHRINK:
		if (descriptive)
			String="shrink automatically";
		else
			String="GB_AUTO_SHRINK";
		break;
	
	
	default:
		g_warning("%s\nunknown GbResizePolicy: `%d'",
			  FUNCNAME,
			  value);
		sprintf(char_buffer, "%d", value);
		String=char_buffer;
		break;
	}
	
	return String;
}


const char*
String_GtkWidgetFlag		(const	guint32	value,
				 gboolean	descriptive)
{
	register char	*String;

	switch (value) {
	
	case	GTK_VISIBLE:
		if (descriptive)
			String="is Visible";
		else
			String="GTK_VISIBLE";
		break;
	
	case	GTK_MAPPED:
		String="GTK_MAPPED";
		break;
	
	case	GTK_UNMAPPED:
		String="GTK_UNMAPPED";
		break;
	
	case	GTK_REALIZED:
		String="GTK_REALIZED";
		break;
	
	case	GTK_SENSITIVE:
		if (descriptive)
			String="is Sensitive";
		else
			String="GTK_SENSITIVE";
		break;
	
	case	GTK_PARENT_SENSITIVE:
		String="GTK_PARENT_SENSITIVE";
		break;
	
	case	GTK_NO_WINDOW:
		String="GTK_NO_WINDOW";
		break;
	
	case	GTK_HAS_FOCUS:
		if (descriptive)
			String="grab Focus";
		else
			String="GTK_HAS_FOCUS";
		break;
	
	case	GTK_CAN_FOCUS:
		if (descriptive)
			String="can Focus";
		else
			String="GTK_CAN_FOCUS";
		break;
	
	case	GTK_HAS_DEFAULT:
		if (descriptive)
			String="grab Default";
		else
			String="GTK_HAS_DEFAULT";
		break;
	
	case	GTK_CAN_DEFAULT:
		if (descriptive)
			String="can Default";
		else
			String="GTK_CAN_DEFAULT";
		break;
	
	case	GTK_PROPAGATE_STATE:
		String="GTK_PROPAGATE_STATE";
		break;
	
	case	GTK_ANCHORED:
		String="GTK_ANCHORED";
		break;
	
	default:
		g_warning("%s\nunknown GtkWidget-Flag: `%d'",
			  FUNCNAME,
			  value);
		sprintf(char_buffer, "%d", value);
		String=char_buffer;
		break;
	}
	
	return String;
}


const char*
String_GtkSelectionMode		(const	guint32	value,
				 gboolean	descriptive)
{
	register char	*String;

	switch (value) {
	case	GTK_SELECTION_SINGLE:
		if (descriptive)
			String="Single";
		else
			String="GTK_SELECTION_SINGLE";
		break;

	case	GTK_SELECTION_BROWSE:
		if (descriptive)
			String="Browse";
		else
			String="GTK_SELECTION_BROWSE";
		break;

	case	GTK_SELECTION_MULTIPLE:
		if (descriptive)
			String="Multiple";
		else
			String="GTK_SELECTION_MULTIPLE";
		break;

	case	GTK_SELECTION_EXTENDED:
		if (descriptive)
			String="Extended";
		else
			String="GTK_SELECTION_EXTENDED";
		break;

	default:
		g_warning("%s\nunknown GtkSelectionMode: `%d'",
			  FUNCNAME,
			  value);
		sprintf(char_buffer, "%d", value);
		String=char_buffer;
		break;
	}
	
	return String;
}


const char*
String_GtkParamType		(const	guint32	value,
				 gboolean	descriptive)
{
	register char	*String;

	switch (value) {
	case	GTK_PARAM_NONE:
		String="GTK_PARAM_NONE";
		break;

	case	GTK_PARAM_CHAR:
		String="GTK_PARAM_CHAR";
		break;

	case	GTK_PARAM_SHORT:
		String="GTK_PARAM_SHORT";
		break;

	case	GTK_PARAM_INT:
		String="GTK_PARAM_INT";
		break;

	case	GTK_PARAM_LONG:
		String="GTK_PARAM_LONG";
		break;

	case	GTK_PARAM_POINTER:
		String="GTK_PARAM_POINTER";
		break;
	
	case	GTK_PARAM_FUNCTION:
		String="GTK_PARAM_FUNCTION";
		break;

	default:
		g_warning("%s\nunknown GtkParamType: `%d'",
			  FUNCNAME,
			  value);
		sprintf(char_buffer, "%d", value);
		String=char_buffer;
		break;
	}
	
	return String;
}


const char*
String_GtkStateType		(const	guint32	value,
				 gboolean	descriptive)
{
	register char	*String;

	switch (value) {
	case	GTK_STATE_NORMAL:
		String="GTK_STATE_NORMAL";
		break;

	case	GTK_STATE_ACTIVE:
		String="GTK_STATE_ACTIVE";
		break;

	case	GTK_STATE_PRELIGHT:
		String="GTK_STATE_PRELIGHT";
		break;

	case	GTK_STATE_SELECTED:
		String="GTK_STATE_SELECTED";
		break;

	case	GTK_STATE_INSENSITIVE:
		String="GTK_STATE_INSENSITIVE";
		break;

	default:
		g_warning("%s\nunknown GtkStateType: `%d'",
			  FUNCNAME,
			  value);
		sprintf(char_buffer, "%d", value);
		String=char_buffer;
		break;
	}
	
	return String;
}


const char*
String_GtkWindowType		(const	guint32	value,
				 gboolean	descriptive)
{
	register char	*String;

	switch (value) {
	case	GTK_WINDOW_TOPLEVEL:
		if (descriptive)
			String="Toplevel";
		else
			String="GTK_WINDOW_TOPLEVEL";
		break;

	case	GTK_WINDOW_DIALOG:
		if (descriptive)
			String="Dialog";
		else
			String="GTK_WINDOW_DIALOG";
		break;

	case	GTK_WINDOW_POPUP:
		if (descriptive)
			String="PopUp";
		else
			String="GTK_WINDOW_POPUP";
		break;

	default:
		g_warning("%s\nunknown GtkWindowType: `%d'",
			  FUNCNAME,
			  value);
		sprintf(char_buffer, "%d", value);
		String=char_buffer;
		break;
	}
	
	return String;
}


const char*
String_GtkDirectionType		(const	guint32	value,
				 gboolean	descriptive)
{
	register char	*String;

	switch (value) {
	case	GTK_DIR_TAB_FORWARD:
		String="GTK_DIR_TAB_FORWARD";
		break;

	case	GTK_DIR_TAB_BACKWARD:
		String="GTK_DIR_TAB_BACKWARD";
		break;

	case	GTK_DIR_UP:
		String="GTK_DIR_UP";
		break;

	case	GTK_DIR_DOWN:
		String="GTK_DIR_DOWN";
		break;

	case	GTK_DIR_LEFT:
		String="GTK_DIR_LEFT";
		break;

	case	GTK_DIR_RIGHT:
		String="GTK_DIR_RIGHT";
		break;

	default:
		g_warning("%s\nunknown GtkDirectionType: `%d'",
			  FUNCNAME,
			  value);
		sprintf(char_buffer, "%d", value);
		String=char_buffer;
		break;
	}
	
	return String;
}


const char*
String_GtkShadowType		(const	guint32	value,
				 gboolean	descriptive)
{
	register char	*String;

	switch (value) {
	case	GTK_SHADOW_NONE:
		if (descriptive)
			String="None";
		else
			String="GTK_SHADOW_NONE";
		break;

	case	GTK_SHADOW_IN:
		if (descriptive)
			String="Shadow In";
		else
			String="GTK_SHADOW_IN";
		break;

	case	GTK_SHADOW_OUT:
		if (descriptive)
			String="Shadow Out";
		else
			String="GTK_SHADOW_OUT";
		break;

	case	GTK_SHADOW_ETCHED_IN:
		if (descriptive)
			String="Etched In";
		else
			String="GTK_SHADOW_ETCHED_IN";
		break;

	case	GTK_SHADOW_ETCHED_OUT:
		if (descriptive)
			String="Etched Out";
		else
			String="GTK_SHADOW_ETCHED_OUT";
		break;

	default:
		g_warning("%s\nunknown GtkShadowType: `%d'",
			  FUNCNAME,
			  value);
		sprintf(char_buffer, "%d", value);
		String=char_buffer;
		break;
	}
	
	return String;
}


const char*
String_GtkArrowType		(const	guint32	value,
				 gboolean	descriptive)
{
	register char	*String;

	switch (value) {
	case	GTK_ARROW_UP:
		if (descriptive)
			String="Up";
		else
			String="GTK_ARROW_UP";
		break;

	case	GTK_ARROW_DOWN:
		if (descriptive)
			String="Down";
		else
			String="GTK_ARROW_DOWN";
		break;

	case	GTK_ARROW_LEFT:
		if (descriptive)
			String="Left";
		else
			String="GTK_ARROW_LEFT";
		break;

	case	GTK_ARROW_RIGHT:
		if (descriptive)
			String="Right";
		else
			String="GTK_ARROW_RIGHT";
		break;

	default:
		g_warning("%s\nunknown GtkArrowType: `%d'",
			  FUNCNAME,
			  value);
		sprintf(char_buffer, "%d", value);
		String=char_buffer;
		break;
	}
	
	return String;
}


const char*
String_GtkPackType		(const	guint32	value,
				 gboolean	descriptive)
{
	register char	*String;

	switch (value) {
	case	GTK_PACK_START:
		if (descriptive)
			String="from Start";
		else
			String="GTK_PACK_START";
		break;

	case	GTK_PACK_END:
		if (descriptive)
			String="from End";
		else
			String="GTK_PACK_END";
		break;

	default:
		g_warning("%s\nunknown GtkPackType: `%d'",
			  FUNCNAME,
			  value);
		sprintf(char_buffer, "%d", value);
		String=char_buffer;
		break;
	}
	
	return String;
}


const char*
String_GtkPolicyType		(const	guint32	value,
				 gboolean	descriptive)
{
	register char	*String;

	switch (value) {
	case	GTK_POLICY_ALWAYS:
		if (descriptive)
			String="Always";
		else
			String="GTK_POLICY_ALWAYS";
		break;

	case	GTK_POLICY_AUTOMATIC:
		if (descriptive)
			String="Automatic";
		else
			String="GTK_POLICY_AUTOMATIC";
		break;

	default:
		g_warning("%s\nunknown GtkPolicyType: `%d'",
			  FUNCNAME,
			  value);
		sprintf(char_buffer, "%d", value);
		String=char_buffer;
		break;
	}
	
	return String;
}


const char*
String_GtkUpdateType		(const	guint32	value,
				 gboolean	descriptive)
{
	register char	*String;

	switch (value) {
	case	GTK_UPDATE_CONTINUOUS:
		if (descriptive)
			String="Continuous";
		else
			String="GTK_UPDATE_CONTINUOUS";
		break;

	case	GTK_UPDATE_DISCONTINUOUS:
		if (descriptive)
			String="Discontinuous";
		else
			String="GTK_UPDATE_DISCONTINUOUS";
		break;

	case	GTK_UPDATE_DELAYED:
		if (descriptive)
			String="Delayed";
		else
			String="GTK_UPDATE_DELAYED";
		break;

	default:
		g_warning("%s\nunknown GtkUpdateType: `%d'",
			  FUNCNAME,
			  value);
		sprintf(char_buffer, "%d", value);
		String=char_buffer;
		break;
	}
	
	return String;
}


const char*
String_GtkAttachOptions		(const	guint32	value,
				 gboolean	descriptive)
{
	register char	*String;

	switch (value) {
	case	GTK_EXPAND:
		if (descriptive)
			String="Expand";
		else
			String="GTK_EXPAND";
		break;

	case	GTK_SHRINK:
		if (descriptive)
			String="Shrink";
		else
			String="GTK_SHRINK";
		break;

	case	GTK_FILL:
		if (descriptive)
			String="Fill";
		else
			String="GTK_FILL";
		break;

	default:
		g_warning("%s\nunknown GtkAttachOptions: `%d'",
			  FUNCNAME,
			  value);
		sprintf(char_buffer, "%d", value);
		String=char_buffer;
		break;
	}
	
	return String;
}


const char*
String_GtkSignalRunType		(const	guint32	value,
				 gboolean	descriptive)
{
	register char	*String;

	switch (value) {
	case	GTK_RUN_FIRST:
		String="GTK_RUN_FIRST";
		break;

	case	GTK_RUN_LAST:
		String="GTK_RUN_LAST";
		break;

	case	GTK_RUN_BOTH:
		String="GTK_RUN_BOTH";
		break;

	case	GTK_RUN_MASK:
		String="GTK_RUN_MASK";
		break;

	case	GTK_RUN_NO_RECURSE:
		String="GTK_RUN_NO_RECURSE";
		break;

	default:
		g_warning("%s\nunknown GtkSignalRunType: `%d'",
			  FUNCNAME,
			  value);
		sprintf(char_buffer, "%d", value);
		String=char_buffer;
		break;
	}
	
	return String;
}


const char*
String_GtkWindowPosition	(const	guint32	value,
				 gboolean	descriptive)
{
	register char	*String;

	switch (value) {
	case	GTK_WIN_POS_NONE:
		if (descriptive)
			String="Unspecified";
		else
			String="GTK_WIN_POS_NONE";
		break;

	case	GTK_WIN_POS_CENTER:
		if (descriptive)
			String="Centered";
		else
			String="GTK_WIN_POS_CENTER";
		break;

	case	GTK_WIN_POS_MOUSE:
		if (descriptive)
			String="at Mouse Cursor";
		else
			String="GTK_WIN_POS_MOUSE";
		break;

	default:
		g_warning("%s\nunknown GtkWindowPosition: `%d'",
			  FUNCNAME,
			  value);
		sprintf(char_buffer, "%d", value);
		String=char_buffer;
		break;
	}
	
	return String;
}


const char*
String_GtkSubmenuDirection	(const	guint32	value,
				 gboolean	descriptive)
{
	register char	*String;

	switch (value) {
	case	GTK_DIRECTION_LEFT:
		String="GTK_DIRECTION_LEFT";
		break;

	case	GTK_DIRECTION_RIGHT:
		String="GTK_DIRECTION_RIGHT";
		break;

	default:
		g_warning("%s\nunknown GtkSubmenuDirection: `%d'",
			  FUNCNAME,
			  value);
		sprintf(char_buffer, "%d", value);
		String=char_buffer;
		break;
	}
	
	return String;
}


const char*
String_GtkSubmenuPlacement	(const	guint32	value,
				 gboolean	descriptive)
{
	register char	*String;

	switch (value) {
	case	GTK_TOP_BOTTOM:
		String="GTK_TOP_BOTTOM";
		break;

	case	GTK_LEFT_RIGHT:
		String="GTK_LEFT_RIGHT";
		break;

	default:
		g_warning("%s\nunknown GtkSubmenuPlacement: `%d'",
			  FUNCNAME,
			  value);
		sprintf(char_buffer, "%d", value);
		String=char_buffer;
		break;
	}
	
	return String;
}


const char*
String_GtkMenuFactoryType	(const	guint32	value,
				 gboolean	descriptive)
{
	register char	*String;

	switch (value) {
	case	GTK_MENU_FACTORY_MENU:
		String="GTK_MENU_FACTORY_MENU";
		break;

	case	GTK_MENU_FACTORY_MENU_BAR:
		String="GTK_MENU_FACTORY_MENU_BAR";
		break;

	case	GTK_MENU_FACTORY_OPTION_MENU:
		String="GTK_MENU_FACTORY_OPTION_MENU";
		break;

	default:
		g_warning("%s\nunknown GtkMenuFactoryType: `%d'",
			  FUNCNAME,
			  value);
		sprintf(char_buffer, "%d", value);
		String=char_buffer;
		break;
	}
	
	return String;
}


const char*
String_GtkMetricType		(const	guint32	value,
				 gboolean	descriptive)
{
	register char	*String;

	switch (value) {
	case	GTK_PIXELS:
		if (descriptive)
			String="Pixels";
		else
			String="GTK_PIXELS";
		break;

	case	GTK_INCHES:
		if (descriptive)
			String="Inches";
		else
			String="GTK_INCHES";
		break;

	case	GTK_CENTIMETERS:
		if (descriptive)
			String="Centimeters";
		else
			String="GTK_CENTIMETERS";
		break;

	default:
		g_warning("%s\nunknown GtkMetricType: `%d'",
			  FUNCNAME,
			  value);
		sprintf(char_buffer, "%d", value);
		String=char_buffer;
		break;
	}
	
	return String;
}


const char*
String_GtkScrollType		(const	guint32	value,
				 gboolean	descriptive)
{
	register char	*String;

	switch (value) {
	case	GTK_SCROLL_NONE:
		String="GTK_SCROLL_NONE";
		break;

	case	GTK_SCROLL_STEP_BACKWARD:
		String="GTK_SCROLL_STEP_BACKWARD";
		break;

	case	GTK_SCROLL_STEP_FORWARD:
		String="GTK_SCROLL_STEP_FORWARD";
		break;

	case	GTK_SCROLL_PAGE_BACKWARD:
		String="GTK_SCROLL_PAGE_BACKWARD";
		break;

	case	GTK_SCROLL_PAGE_FORWARD:
		String="GTK_SCROLL_PAGE_FORWARD";
		break;

	default:
		g_warning("%s\nunknown GtkScrollType: `%d'",
			  FUNCNAME,
			  value);
		sprintf(char_buffer, "%d", value);
		String=char_buffer;
		break;
	}
	
	return String;
}


const char*
String_GtkTroughType		(const	guint32	value,
				 gboolean	descriptive)
{
	register char	*String;

	switch (value) {
	case	GTK_TROUGH_NONE:
		String="GTK_TROUGH_NONE";
		break;

	case	GTK_TROUGH_START:
		String="GTK_TROUGH_START";
		break;

	case	GTK_TROUGH_END:
		String="GTK_TROUGH_END";
		break;

	default:
		g_warning("%s\nunknown GtkTroughType: `%d'",
			  FUNCNAME,
			  value);
		sprintf(char_buffer, "%d", value);
		String=char_buffer;
		break;
	}
	
	return String;
}


const char*
String_GtkPositionType		(const	guint32	value,
				 gboolean	descriptive)
{
	register char	*String;

	switch (value) {
	case	GTK_POS_LEFT:
		if (descriptive)
			String="at Left";
		else
			String="GTK_POS_LEFT";
		break;

	case	GTK_POS_RIGHT:
		if (descriptive)
			String="at Right";
		else
			String="GTK_POS_RIGHT";
		break;

	case	GTK_POS_TOP:
		if (descriptive)
			String="on Top";
		else
			String="GTK_POS_TOP";
		break;

	case	GTK_POS_BOTTOM:
		if (descriptive)
			String="below Bottom";
		else
			String="GTK_POS_BOTTOM";
		break;

	default:
		g_warning("%s\nunknown GtkPositionType: `%d'",
			  FUNCNAME,
			  value);
		sprintf(char_buffer, "%d", value);
		String=char_buffer;
		break;
	}
	
	return String;
}


const char*
String_GtkPreviewType		(const	guint32	value,
				 gboolean	descriptive)
{
	register char	*String;

	switch (value) {
	case	GTK_PREVIEW_COLOR:
		String="GTK_PREVIEW_COLOR";
		break;

	case	GTK_PREVIEW_GRAYSCALE:
		String="GTK_PREVIEW_GRAYSCALE";
		break;

	default:
		g_warning("%s\nunknown GtkPreviewType: `%d'",
			  FUNCNAME,
			  value);
		sprintf(char_buffer, "%d", value);
		String=char_buffer;
		break;
	}
	
	return String;
}
