/* gbconf.c: functions executed on widget tree building
 * file created 1997/05/09 18:57:45 by gubi (static)
*/
#include	"RCS.h"
RCS_ID("$Id$")
RCS_KEY(Template, "$Template: gbconfc.tpl 1997 gubi $")

#define		__gbconf_c__

#include	"gbconf.h"
#include	<stdio.h>



/* --- prototypes --- */
static	void	gb_widget_data_clone_with_parent	(gb_wdat_base_S	*SrcDat,
							 gb_wdat_base_S	*ParDat);



/* ---------------- functions ---------------- */
void
gb_sigh_widget_dump	(GtkWidget	*widget)
{
	g_assert(widget);
	
	printf("gb_sigh_widget_dump(%s):\n", widget->name ? widget->name : "");
	printf("\tname:       %s\n", gtk_widget_get_name(widget));
	printf("\tstate:      %d\n", widget->state);
	printf("\tallocation:\n");
	printf("\t  x:      %d\n", widget->allocation.x);
	printf("\t  y:      %d\n", widget->allocation.y);
	printf("\t  width:  %d\n", widget->allocation.width);
	printf("\t  height: %d\n", widget->allocation.height);
}


void
gb_sigh_pointer_nullify	(
	#ifndef	__cplusplus
			 GtkWidget	*widget,
	#else
			 GtkWidget	*,
	#endif
			 gpointer	*pointer_adress)
{
	g_assert(pointer_adress);
	
	*pointer_adress=NULL;
}


void
gb_sigh_structure_free	(
	#ifndef	__cplusplus
			 GtkWidget	*widget,
	#else
			 GtkWidget	*,
	#endif
			 gb_any_S	*Struct)
{
	g_assert(Struct);
	
	if (GB_IS_WIDGET(Struct)) {
		register gb_wdat_base_S	*WidDat=GB_wCAST(base, Struct);
		
		g_free(WidDat->handler_stack);
		g_free(WidDat->linkage);
	}
	
	g_free(Struct);
}


void
gb_window_connect	(gb_wdat_window_S	*WinDat)
{
	register gb_wdat_base_S	*WidDat;
	
	g_assert(GB_IS_WINDOW_WIDGET(WinDat));
	
	WidDat=GB_wCAST(base, WinDat);
	while (WidDat) {
		gb_widget_connect(WidDat);
		WidDat=WidDat->next;
	}
}


void
gb_widget_connect	(gb_wdat_base_S	*WidDat)
{
	register gb_handler_S		*Next;
	
	g_assert(GB_IS_WIDGET(WidDat));
	g_assert(WidDat->widget);
	
	if (!WidDat->handler_stack)
		return;
	
	Next=WidDat->handler_stack;
	while (Next->handler_func) {
		register gb_handler_data_U	data_p;
		
		if (Next->connect_options&GB_CONNECT_DATA_POINTER)
			data_p.func_data=*Next->data.func_data_p;
		else
			data_p.func_data=Next->data.func_data;
	
		if (Next->connect_options&GB_CONNECT_OBJECT && data_p.slot_object==NULL)
			data_p.slot_object=GTK_OBJECT(WidDat->widget);
			
		switch ( Next->connect_options &
			 ( GB_CONNECT |
			   GB_CONNECT_OBJECT |
			   GB_CONNECT_AFTER ) ) {
		
		case	GB_CONNECT:
			Next->handler_id=gtk_signal_connect(
				GTK_OBJECT(WidDat->widget),
				Next->signal_name,
				Next->handler_func,
				data_p.func_data);
			break;
		
		case	GB_CONNECT | GB_CONNECT_AFTER:
			Next->handler_id=gtk_signal_connect_after(
				GTK_OBJECT(WidDat->widget),
				Next->signal_name,
				Next->handler_func,
				data_p.func_data);
			break;
		
		case	GB_CONNECT | GB_CONNECT_OBJECT:
			Next->handler_id=gtk_signal_connect_object(
				GTK_OBJECT(WidDat->widget),
				Next->signal_name,
				Next->handler_func,
				data_p.slot_object);
			break;

		case	GB_CONNECT | GB_CONNECT_OBJECT | GB_CONNECT_AFTER:
			Next->handler_id=gtk_signal_connect_object_after(
				GTK_OBJECT(WidDat->widget),
				Next->signal_name,
				Next->handler_func,
				data_p.slot_object);
			break;

		default:
			break;
		}
		Next++;
	}
}


void
gb_widget_data_clone	(gb_wdat_base_S	*WidDat)
{
	register gb_wdat_base_S	*TmpDat;
	
	g_assert(GB_IS_WIDGET(WidDat));
	
	
	/* clear all clone references in list
	*/
	TmpDat=WidDat;
	while (TmpDat->parent)
		TmpDat=TmpDat->parent;
	while (TmpDat) {
		TmpDat->clone=NULL;
		TmpDat=TmpDat->next;
	}
	
	
	/* do the real cloning
	*/
	gb_widget_data_clone_with_parent(WidDat, NULL);
}


void
gb_widget_data_clone_with_parent	(gb_wdat_base_S	*SrcDat,
					 gb_wdat_base_S	*ParDat)
{
	static	 gb_wdat_base_S	**NextPointer;
	register gb_wdat_base_S	*ChildDat;
	register gb_wdat_base_S	*WidDat;
	
	g_assert(GB_IS_WIDGET(SrcDat));
	
	
	/* copy the widget data structure
	*/
	WidDat=GB_wCAST(base, memdup(SrcDat, gb_struct_size(SrcDat->type)));
	WidDat->next=NULL;
	
	
	/* copy the handler_stack
	*/
	if (SrcDat->handler_stack) {
		register guint		i;
		for (i=0; SrcDat->handler_stack[i].handler_func!=NULL; i++);
		i++;
		WidDat->handler_stack=GB_CAST(handler, memdup(SrcDat->handler_stack, i*sizeof(gb_handler_S)));
	}
	
	
	/* copy the linkage information
	*/
	if (SrcDat->linkage)
		WidDat->linkage=GB_CAST(any, memdup(SrcDat->linkage, gb_struct_size(SrcDat->linkage->type)));
	
	
	/* include clone reference into source
	*/
	SrcDat->clone=WidDat;
	WidDat->clone=NULL;
	WidDat->gfree_on_destroy=TRUE;
	
	
	/* if we have a new parent,
	 * we set it, and add us to the list
	*/
	if (ParDat) {
		g_assert(GB_IS_CONTAINER_WIDGET(ParDat));
		WidDat->parent=ParDat;
		*NextPointer=WidDat;
	}
	
	
	/* make us the last one in the list now
	*/
	NextPointer=&WidDat->next;
	
	
	/* update widget specific fields
	*/
	switch (WidDat->type) {
	
	case	GB_WIDGET_RADIO_BUTTON:
		if (GB_wCAST(radio_button, WidDat)->grouping &&
		    GB_wCAST(radio_button, WidDat)->grouping->clone)
			GB_wCAST(radio_button, WidDat)->grouping=GB_wCAST(radio_button,
				GB_wCAST(radio_button, WidDat)->grouping->clone);
		else
			GB_wCAST(radio_button, WidDat)->grouping=NULL;
		break;
	
	default:
		break;
	}
	
	
	/* let's add our children as well
	*/
	ChildDat=SrcDat->next;
	while (ChildDat) {
		if (ChildDat->parent==SrcDat)
			gb_widget_data_clone_with_parent(ChildDat, WidDat);
		ChildDat=ChildDat->next;
	}
}


void
gb_window_build		(gb_wdat_window_S	*WinDat)
{
	static	gb_wdat_base_S		*WidDat;
	
	g_assert(GB_IS_WINDOW_WIDGET(WinDat));
	g_assert(!WinDat->parent);


	/* create window widget
	*/
	gb_widget_create(GB_wCAST(base, WinDat));
	
	
	/* build widget tree
	*/
	WidDat=WinDat->next;
	
	while (WidDat) {
		gb_widget_create(WidDat);
		WidDat=WidDat->next;
	};
}


void
gb_widget_create	(gb_wdat_base_S	*WidDat)
{
	
	g_assert(GB_IS_WIDGET(WidDat));
	g_assert(WidDat->parent || GB_IS_WINDOW_WIDGET(WidDat));
	if (WidDat->widget)
		g_warning("gb_create_widget(%d):\nfailed to assert: WidDat->widget==NULL",
			  WidDat->type);
	
	
	/* call appropriate creation function for this widget
	 * and set specific data
	*/
	switch (WidDat->type) {
		register GSList		*radio_group;
		
	case	GB_WIDGET_LABEL:
		WidDat->widget=gtk_label_new(GB_wCAST(label, WidDat)->label);
		break;

	case	GB_WIDGET_ENTRY:
		WidDat->widget=gtk_entry_new();
		if (GB_wCAST(entry, WidDat)->init_text)
			gtk_entry_set_text(GTK_ENTRY(WidDat->widget),
					   GB_wCAST(entry, WidDat)->init_text);
		break;

	case	GB_WIDGET_H_SEPARATOR:
		WidDat->widget=gtk_hseparator_new();
		break;
		
	case	GB_WIDGET_V_SEPARATOR:
		WidDat->widget=gtk_vseparator_new();
		break;
		
	case	GB_WIDGET_BUTTON:
		if (GB_wCAST(button, WidDat)->label)
			WidDat->widget=gtk_button_new_with_label(
							GB_wCAST(button,
							WidDat)->label);
		else
			WidDat->widget=gtk_button_new();
		break;

	case	GB_WIDGET_TOGGLE_BUTTON:
		if (GB_wCAST(toggle_button, WidDat)->label)
			WidDat->widget=gtk_toggle_button_new_with_label(
							GB_wCAST(toggle_button,
							WidDat)->label);
		else
			WidDat->widget=gtk_toggle_button_new();
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(WidDat->widget),
					    GB_wCAST(toggle_button, WidDat)->init_state);
		gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(WidDat->widget),
					   GB_wCAST(toggle_button, WidDat)->draw_indicator);
		break;
		
	case	GB_WIDGET_CHECK_BUTTON:
		if (GB_wCAST(check_button, WidDat)->label)
			WidDat->widget=gtk_check_button_new_with_label(
							GB_wCAST(check_button,
							WidDat)->label);
		else
			WidDat->widget=gtk_check_button_new();
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(WidDat->widget),
					    GB_wCAST(check_button, WidDat)->init_state);
		gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(WidDat->widget),
					   GB_wCAST(check_button, WidDat)->draw_indicator);
		break;
	
	case	GB_WIDGET_RADIO_BUTTON:
		if (GB_wCAST(radio_button, WidDat)->grouping) {
			g_assert(GB_wCAST(radio_button, WidDat)->grouping->widget);
			
			radio_group=gtk_radio_button_group(
				GTK_RADIO_BUTTON(GB_wCAST(radio_button, WidDat)->grouping->widget));
		} else
			radio_group=NULL;
		
		if (GB_wCAST(radio_button, WidDat)->label)
			WidDat->widget=gtk_radio_button_new_with_label(
							radio_group,
							GB_wCAST(radio_button,
							WidDat)->label);
		else
			WidDat->widget=gtk_radio_button_new(radio_group);
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(WidDat->widget),
					    GB_wCAST(radio_button, WidDat)->init_state);
		gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(WidDat->widget),
					   GB_wCAST(radio_button, WidDat)->draw_indicator);
		break;

	case	GB_WIDGET_FRAME:
		if (GB_wCAST(frame, WidDat)->label)
			WidDat->widget=gtk_frame_new(GB_wCAST(frame,
						     WidDat)->label);
		else
			WidDat->widget=gtk_frame_new(NULL);
		gtk_frame_set_shadow_type(GTK_FRAME(WidDat->widget),
					  GB_wCAST(frame, WidDat)->shadow_type);
		gtk_frame_set_label_align(GTK_FRAME(WidDat->widget),
					  GB_wCAST(frame, WidDat)->xalign,
					  GB_wCAST(frame, WidDat)->yalign);
		break;
		
	case	GB_WIDGET_TABLE:
		WidDat->widget=gtk_table_new(GB_wCAST(table, WidDat)->rows,
					     GB_wCAST(table, WidDat)->columns,
					     GB_wCAST(table, WidDat)->homogeneous);
		gtk_table_set_row_spacings(GTK_TABLE(WidDat->widget),
					   GB_wCAST(table, WidDat)->row_spacing);
		gtk_table_set_col_spacings(GTK_TABLE(WidDat->widget),
					   GB_wCAST(table, WidDat)->col_spacing);
		break;
	
	case	GB_WIDGET_H_BOX:
		WidDat->widget=gtk_hbox_new(GB_wCAST(h_box, WidDat)->homogeneous,
					    GB_wCAST(h_box, WidDat)->spacing);
		break;
		
	case	GB_WIDGET_V_BOX:
		WidDat->widget=gtk_vbox_new(GB_wCAST(v_box, WidDat)->homogeneous,
					    GB_wCAST(v_box, WidDat)->spacing);
		break;
		
	case	GB_WIDGET_LIST:
		WidDat->widget=gtk_list_new();
		gtk_list_set_selection_mode(GTK_LIST(WidDat->widget),
					    GB_wCAST(list, WidDat)->select_mode);
		break;
		
	case	GB_WIDGET_SCROLLED_WINDOW:
		WidDat->widget=gtk_scrolled_window_new(NULL, NULL);
		gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(WidDat->widget),
					GB_wCAST(scrolled_window, WidDat)->hscrollbar_policy,
					GB_wCAST(scrolled_window, WidDat)->vscrollbar_policy);
		break;
		
	case	GB_WIDGET_PROGRESS_BAR:
		WidDat->widget=gtk_progress_bar_new();
		if (GB_wCAST(progress_bar, WidDat)->init_percentage)
			gtk_progress_bar_update(GTK_PROGRESS_BAR(WidDat->widget),
						GB_wCAST(progress_bar,
						WidDat)->init_percentage);
		break;
	
	case	GB_WIDGET_ARROW:
		WidDat->widget=gtk_arrow_new(GB_wCAST(arrow, WidDat)->arrow_type,
					     GB_wCAST(arrow, WidDat)->shadow_type);
		break;
	
	case	GB_WIDGET_DRAWING_AREA:
		WidDat->widget=gtk_drawing_area_new();
		gtk_drawing_area_size(GTK_DRAWING_AREA(WidDat->widget),
				      GB_wCAST(drawing_area, WidDat)->req_width,
				      GB_wCAST(drawing_area, WidDat)->req_height);
		break;
	
	case	GB_WIDGET_H_SCALE:
		WidDat->widget=gtk_hscale_new(GB_wCAST(v_scale, WidDat)->adjustment);
		gtk_scale_set_digits(GTK_SCALE(WidDat->widget),
				     GB_wCAST(h_scale, WidDat)->digits);
		gtk_scale_set_draw_value(GTK_SCALE(WidDat->widget),
					 GB_wCAST(h_scale, WidDat)->draw_value);
		gtk_scale_set_value_pos(GTK_SCALE(WidDat->widget),
					GB_wCAST(h_scale, WidDat)->value_pos);
		gtk_range_set_update_policy(GTK_RANGE(WidDat->widget),
					    GB_wCAST(h_scale, WidDat)->update_type);
		break;
	
	case	GB_WIDGET_V_SCALE:
		WidDat->widget=gtk_vscale_new(GB_wCAST(v_scale, WidDat)->adjustment);
		gtk_scale_set_digits(GTK_SCALE(WidDat->widget),
				     GB_wCAST(v_scale, WidDat)->digits);
		gtk_scale_set_draw_value(GTK_SCALE(WidDat->widget),
					 GB_wCAST(v_scale, WidDat)->draw_value);
		gtk_scale_set_value_pos(GTK_SCALE(WidDat->widget),
					GB_wCAST(v_scale, WidDat)->value_pos);
		gtk_range_set_update_policy(GTK_RANGE(WidDat->widget),
					    GB_wCAST(v_scale, WidDat)->update_type);
		break;

	case	GB_WIDGET_H_RULER:
		WidDat->widget=gtk_hruler_new();
		gtk_ruler_set_metric(GTK_RULER(WidDat->widget),
				     GB_wCAST(h_ruler, WidDat)->metric);
		gtk_ruler_set_range(GTK_RULER(WidDat->widget),
				    GB_wCAST(h_ruler, WidDat)->lower,
				    GB_wCAST(h_ruler, WidDat)->upper,
				    GB_wCAST(h_ruler, WidDat)->position,
				    GB_wCAST(h_ruler, WidDat)->max_size);
		gtk_ruler_draw_ticks(GTK_RULER(WidDat->widget));
		gtk_ruler_draw_pos(GTK_RULER(WidDat->widget));
		break;
		
	case	GB_WIDGET_V_RULER:
		WidDat->widget=gtk_vruler_new();
		gtk_ruler_set_metric(GTK_RULER(WidDat->widget),
				     GB_wCAST(v_ruler, WidDat)->metric);
		gtk_ruler_set_range(GTK_RULER(WidDat->widget),
				    GB_wCAST(v_ruler, WidDat)->lower,
				    GB_wCAST(v_ruler, WidDat)->upper,
				    GB_wCAST(v_ruler, WidDat)->position,
				    GB_wCAST(v_ruler, WidDat)->max_size);
		gtk_ruler_draw_ticks(GTK_RULER(WidDat->widget));
		gtk_ruler_draw_pos(GTK_RULER(WidDat->widget));
		break;
	
	case	GB_WIDGET_WINDOW:
		WidDat->widget=gtk_window_new(GB_wCAST(window,
						WidDat)->win_type);
		gtk_window_set_title(GTK_WINDOW(WidDat->widget),
				     GB_wCAST(window, WidDat)->title);
		gtk_window_position(GTK_WINDOW(WidDat->widget),
				    GB_wCAST(window, WidDat)->win_position);
		gtk_window_set_policy(GTK_WINDOW(WidDat->widget),
				      (GB_wCAST(window, WidDat)->resize_policy&GB_ALLOW_SHRINK)!=0,
				      (GB_wCAST(window, WidDat)->resize_policy&GB_ALLOW_GROW)!=0,
				      (GB_wCAST(window, WidDat)->resize_policy&GB_AUTO_SHRINK)!=0);
		break;
	
	case	GB_WIDGET_FILE_SELECTION:
		WidDat->widget=gtk_file_selection_new(GB_wCAST(file_selection,
						      WidDat)->title);
		gtk_window_position(GTK_WINDOW(WidDat->widget),
				    GB_wCAST(file_selection, WidDat)->win_position);
		gtk_window_set_policy(GTK_WINDOW(WidDat->widget),
				      (GB_wCAST(file_selection, WidDat)->resize_policy&GB_ALLOW_SHRINK)!=0,
				      (GB_wCAST(file_selection, WidDat)->resize_policy&GB_ALLOW_GROW)!=0,
				      (GB_wCAST(file_selection, WidDat)->resize_policy&GB_AUTO_SHRINK)!=0);
		if (GB_wCAST(file_selection, WidDat)->filename)
			gtk_file_selection_set_filename(GTK_FILE_SELECTION(WidDat->widget),
							GB_wCAST(file_selection, WidDat)->filename);
		break;

	default:
		g_error("gb_widget_create(): unknown structure type: `%d'",
			WidDat->type);
	};
	
	
	/* if we are a clone, we want to be free()d,
	 * otherwise we want our widget pointer
	 * to be nullified
	*/
	if (WidDat->gfree_on_destroy)
		gtk_signal_connect(GTK_OBJECT(WidDat->widget),
				   "destroy",
				   GTK_SIGNAL_FUNC(gb_sigh_structure_free),
				   WidDat);
	else
		GB_NULLIFY_ON_DESTROY(WidDat->widget, &WidDat->widget);
	
	
	/* set our name for Gtk+
	*/
	if (WidDat->widget_name)
		gtk_widget_set_name(WidDat->widget, WidDat->widget_name);
	
	
	/* set base data
	*/
	if (WidDat->x>=0 && WidDat->y>=0)
		gtk_widget_set_uposition(WidDat->widget, WidDat->x, WidDat->y);
	if (WidDat->width>0 && WidDat->height>0)
		gtk_widget_set_usize(WidDat->widget, WidDat->width, WidDat->height);
	gtk_widget_set_sensitive(WidDat->widget, (WidDat->flags&GTK_SENSITIVE)!=0);
	if (WidDat->flags&GTK_CAN_DEFAULT)
		GTK_WIDGET_SET_FLAGS(WidDat->widget, GTK_CAN_DEFAULT);
	else
		GTK_WIDGET_UNSET_FLAGS(WidDat->widget, GTK_CAN_DEFAULT);
	if (WidDat->flags&GTK_CAN_FOCUS)
		GTK_WIDGET_SET_FLAGS(WidDat->widget, GTK_CAN_FOCUS);
	else
		GTK_WIDGET_UNSET_FLAGS(WidDat->widget, GTK_CAN_FOCUS);
	gtk_object_set_user_data(GTK_OBJECT(WidDat->widget), WidDat->user_data);
	
	
	/* set container specific data
	*/
	if (GB_IS_CONTAINER_WIDGET(WidDat))
		gtk_container_border_width(GTK_CONTAINER(WidDat->widget),
					   GB_wCAST(container,
					   	WidDat)->border_width);


	/* link widget to parent
	*/
	if (WidDat->parent) switch (WidDat->parent->type) {
	register gb_linkage_box_S	*l_box;
	register gb_linkage_table_S	*l_table;
	register GtkBox			*box;
		
	case	GB_WIDGET_LIST:
	case	GB_WIDGET_FRAME:
	case	GB_WIDGET_BUTTON:
	case	GB_WIDGET_RADIO_BUTTON:
	case	GB_WIDGET_CHECK_BUTTON:
	case	GB_WIDGET_TOGGLE_BUTTON:
	case	GB_WIDGET_SCROLLED_WINDOW:
	case	GB_WIDGET_WINDOW:
		g_assert(!WidDat->linkage);
		
		gtk_container_add(GTK_CONTAINER(WidDat->parent->widget), WidDat->widget);
		break;
		
	case	GB_WIDGET_TABLE:
		l_table=(gb_linkage_table_S*)WidDat->linkage;
		
		if (l_table) {
			g_assert(l_table->type==GB_LINKAGE_TABLE);
			
			gtk_table_attach(GTK_TABLE(WidDat->parent->widget),
					 WidDat->widget,
					 l_table->left_attach,
					 l_table->right_attach,
					 l_table->top_attach,
					 l_table->bottom_attach,
					 l_table->xoptions,
					 l_table->yoptions,
					 l_table->xpadding,
					 l_table->xpadding);
		} else
			gtk_container_add(GTK_CONTAINER(WidDat->parent->widget), WidDat->widget);
		break;

	case	GB_WIDGET_H_BOX:
	case	GB_WIDGET_V_BOX:
	case	GB_WIDGET_FILE_SELECTION:
		l_box=(gb_linkage_box_S*)WidDat->linkage;
		if (WidDat->parent->type==GB_WIDGET_FILE_SELECTION)
			box=GTK_BOX(GTK_FILE_SELECTION(WidDat->parent->widget)->main_vbox);
		else
			box=GTK_BOX(WidDat->parent->widget);
		
		if (l_box) {
			g_assert(l_box->type==GB_LINKAGE_BOX);
		
			switch (l_box->pack_type) {
			
			case GTK_PACK_START:
				gtk_box_pack_start(box,
						   WidDat->widget,
						   (l_box->attach&GTK_EXPAND)!=0,
						   (l_box->attach&GTK_FILL)!=0,
						   l_box->padding);
				break;
			
			case GTK_PACK_END:
				gtk_box_pack_end(box,
						 WidDat->widget,
						 (l_box->attach&GTK_EXPAND)!=0,
						 (l_box->attach&GTK_FILL)!=0,
						 l_box->padding);
				break;
			}
		} else
			gtk_container_add(GTK_CONTAINER(box), WidDat->widget);
		break;
			
	default:
		g_error("gb_widget_create(): parent: unknown structure type: `%d'",
			WidDat->parent->type);
		break;
	}
	
	/* grab default
	*/
	if (WidDat->flags&GTK_HAS_DEFAULT)
		gtk_widget_grab_default(WidDat->widget);
	
	
	/* grab focus
	*/
	if (WidDat->flags&GTK_HAS_FOCUS)
		gtk_widget_grab_focus(WidDat->widget);
	
	
	/* show widget if it is visible and has parent
	*/
	if (WidDat->flags&GTK_VISIBLE && WidDat->parent)
		gtk_widget_show(WidDat->widget);
}


guint	gb_struct_size(const gb_struct_type_E struct_type)
{
	switch (struct_type) {
	
	case	GB_STRUCT_NONE:
	case	GB_WIDGET_BASE:
	case	GB_WIDGET_CONTAINER:
	default:
		g_assert_not_reached();
		return 0;

	case	GB_LINKAGE_BOX:
		return sizeof(gb_linkage_box_S);
	
	case	GB_LINKAGE_TABLE:
		return sizeof(gb_linkage_table_S);
		
	case	GB_WIDGET_LABEL:
		return sizeof(gb_wdat_label_S);
	
	case	GB_WIDGET_ENTRY:
		return sizeof(gb_wdat_entry_S);

	case	GB_WIDGET_H_SEPARATOR:
		return sizeof(gb_wdat_h_separator_S);
	
	case	GB_WIDGET_V_SEPARATOR:
		return sizeof(gb_wdat_v_separator_S);
	
	case	GB_WIDGET_PROGRESS_BAR:
		return sizeof(gb_wdat_progress_bar_S);
	
	case	GB_WIDGET_ARROW:
		return sizeof(gb_wdat_arrow_S);
	
	case	GB_WIDGET_DRAWING_AREA:
		return sizeof(gb_wdat_drawing_area_S);

	case	GB_WIDGET_H_SCALE:
		return sizeof(gb_wdat_h_scale_S);
	
	case	GB_WIDGET_V_SCALE:
		return sizeof(gb_wdat_v_scale_S);
	
	case	GB_WIDGET_H_RULER:
		return sizeof(gb_wdat_h_ruler_S);
	
	case	GB_WIDGET_V_RULER:
		return sizeof(gb_wdat_v_ruler_S);
	
	case	GB_WIDGET_H_BOX:
		return sizeof(gb_wdat_h_box_S);
	
	case	GB_WIDGET_V_BOX:
		return sizeof(gb_wdat_v_box_S);
		
	case	GB_WIDGET_TABLE:
		return sizeof(gb_wdat_table_S);
	
	case	GB_WIDGET_FRAME:
		return sizeof(gb_wdat_frame_S);
	
	case	GB_WIDGET_BUTTON:
		return sizeof(gb_wdat_button_S);
		
	case	GB_WIDGET_TOGGLE_BUTTON:
		return sizeof(gb_wdat_toggle_button_S);
	
	case	GB_WIDGET_CHECK_BUTTON:
		return sizeof(gb_wdat_check_button_S);

	case	GB_WIDGET_RADIO_BUTTON:
		return sizeof(gb_wdat_radio_button_S);

	case	GB_WIDGET_LIST:
		return sizeof(gb_wdat_list_S);
	
	case	GB_WIDGET_SCROLLED_WINDOW:
		return sizeof(gb_wdat_scrolled_window_S);
		
	case	GB_WIDGET_WINDOW:
		return sizeof(gb_wdat_window_S);
	
	case	GB_WIDGET_FILE_SELECTION:
		return sizeof(gb_wdat_file_selection_S);
	}
}
