/* GDK - The GIMP Drawing Kit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * BeOS Port
 * Copyright (C) 1999 EventLoop, Inc.
 *   Shawn T. Amundson <amundson@gtk.org>
 *   James Mitchell <mitchell@eventloop.com>
 *         
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Modified by the GTK+ Team and others 1997-1999.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/. 
 */

#include <Region.h>
#include <Rect.h>

#include "gdk/gdk.h"
#include "gdkprivate.h"

GdkRegion*
gdk_region_new (void)
{
  GdkRegionPrivate *priv;
  GdkRegion *region;
  BRegion *r;

  priv = g_new (GdkRegionPrivate, 1);
  region = (GdkRegion*) priv;
  region->user_data = NULL;

  r = new BRegion();
  //r->Set(BRect(0,0,0,0));
  r->MakeEmpty();
  priv->bregion = (GdkBRegion*) r;

  return region;
}

void
gdk_region_destroy (GdkRegion *region)
{
  GdkRegionPrivate *priv;

  g_return_if_fail (region != NULL);

  priv = (GdkRegionPrivate *) region;

  delete priv->bregion;

  g_free (priv);
}

gboolean
gdk_region_empty (GdkRegion      *region)
{
  GdkRegionPrivate *priv;
  BRegion *bregion;

  g_return_val_if_fail (region != NULL, 0);

  priv = (GdkRegionPrivate *) region;
  bregion = (BRegion*) priv->bregion;

  bregion->MakeEmpty();

  return 0;
}

gboolean
gdk_region_equal (GdkRegion      *region1,
                  GdkRegion      *region2)
{
  GdkRegionPrivate *private1;
  GdkRegionPrivate *private2;
  BRegion *bregion1;
  BRegion *bregion2;
  BRect frame1, frame2;

  g_return_val_if_fail (region1 != NULL, 0);
  g_return_val_if_fail (region2 != NULL, 0);

  private1 = (GdkRegionPrivate *) region1;
  private2 = (GdkRegionPrivate *) region2;

  bregion1 = (BRegion*) private1->bregion;
  bregion2 = (BRegion*) private2->bregion;

  frame1 = bregion1->Frame();
  frame2 = bregion2->Frame();
  
  if(frame1.IsValid() && frame2.IsValid())
    if(frame1 == frame2)
      return 1;
    else
      return 0;
  else
   g_warning("gdk_region_equal: bogus regions bub!");

  return 0;
}

void
gdk_region_get_clipbox(GdkRegion    *region,
		       GdkRectangle *rectangle)
{
  GdkRegionPrivate *priv;
  BRegion *bregion;
  BRect frame;

  g_return_if_fail(region != NULL);
  g_return_if_fail(rectangle != NULL);

  priv = (GdkRegionPrivate *)region;
  bregion = (BRegion*) priv->bregion;
  
  frame = bregion->Frame();

  if(frame.IsValid())
    {
      rectangle->x = (gint16) frame.left;
      rectangle->y = (gint16) frame.top;
      rectangle->width = (gint16) frame.Width() + 1;
      rectangle->height = (gint16) frame.Height() + 1;
    }
  else
    g_warning("gdk_region_get_clipbox: bogus region bub");
}

gboolean
gdk_region_point_in (GdkRegion      *region,
                     gint           x,
		     gint           y)
{
  GdkRegionPrivate *priv;
  BRegion *bregion;

  g_return_val_if_fail (region != NULL, 0);

  priv = (GdkRegionPrivate *) region;
  bregion = (BRegion*) priv->bregion;
  
  return bregion->Contains(BPoint(x, y)); 
}

GdkOverlapType
gdk_region_rect_in (GdkRegion      *region,
                    GdkRectangle   *rect)
{
  GdkRegionPrivate *priv;
  BRegion *bregion;
  int res;
  
  g_return_val_if_fail (region != NULL, (GdkOverlapType)0);

  priv = (GdkRegionPrivate *) region;
  bregion = (BRegion*) priv->bregion;

  res = bregion->Intersects(BRect(rect->x, rect->y, 
				  rect->x + rect->width - 1,
                                  rect->y + rect->height - 1));

  if (res)
    {
      BRect frame;
      
      frame = bregion->Frame();

      if (frame.Contains(BRect(rect->x, rect->y, 
			       rect->x + rect->width - 1,
			       rect->y + rect->height - 1)))
        return GDK_OVERLAP_RECTANGLE_IN; 
      else
        return GDK_OVERLAP_RECTANGLE_PART;  
    }
  else
    return GDK_OVERLAP_RECTANGLE_OUT;
}
				    
GdkRegion *
gdk_region_polygon (GdkPoint    *points,
		    gint         npoints,
		    GdkFillRule  fill_rule)
{
  g_return_val_if_fail (points != NULL, NULL);
  g_return_val_if_fail (npoints != 0, NULL); /* maybe we should check for at least three points */

  g_warning ("gdk_region_region_polygon: no polygon regions in BeOS!!!");

  return NULL;
}

void          
gdk_region_offset (GdkRegion      *region,
                   gint           dx,
		   gint           dy)
{
  GdkRegionPrivate *priv;
  BRegion *bregion;

  g_return_if_fail (region != NULL);

  priv = (GdkRegionPrivate *) region;
  bregion = (BRegion*) priv->bregion;

  bregion->OffsetBy(dx, dy);
}

void
gdk_region_shrink (GdkRegion      *region,
                   gint           dx,
		   gint           dy)
{
  GdkRegionPrivate *priv;

  g_return_if_fail (region != NULL);

  priv = (GdkRegionPrivate *) region;
  
  g_warning ("gdk_region_shrink: not implemented!");
}

GdkRegion*    
gdk_region_union_with_rect (GdkRegion      *region,
                            GdkRectangle   *rect)
{
  GdkRegionPrivate *priv;
  GdkRegion *res;
  GdkRegionPrivate *res_private;
  BRegion *int_region;

  g_return_val_if_fail (region != NULL, NULL);

  priv = (GdkRegionPrivate *) region;
  
  res = gdk_region_new ();
  res_private = (GdkRegionPrivate *) res;

  int_region = new BRegion();
  
  int_region->Set(BRect(rect->x, rect->y, 
			rect->x + rect->width - 1, 
			rect->y + rect->height - 1));

  res_private->bregion = priv->bregion;
  
  ((BRegion*)res_private->bregion)->IntersectWith(int_region);
  
  return res;
}

GdkRegion*    
gdk_regions_intersect (GdkRegion      *source1,
                       GdkRegion      *source2)
{
  GdkRegionPrivate *private1;
  GdkRegionPrivate *private2;
  GdkRegion *res;
  GdkRegionPrivate *res_private;

  g_return_val_if_fail (source1 != NULL, NULL);
  g_return_val_if_fail (source2 != NULL, NULL);

  private1 = (GdkRegionPrivate *) source1;
  private2 = (GdkRegionPrivate *) source2;

  res = gdk_region_new ();
  res_private = (GdkRegionPrivate *) res;
  
  g_warning ("gdk_regions_intersect: not implemented!");
  
  return res;
}

GdkRegion* 
gdk_regions_union (GdkRegion      *source1,
                   GdkRegion      *source2)
{
  GdkRegionPrivate *private1;
  GdkRegionPrivate *private2;
  GdkRegion *res;
  GdkRegionPrivate *res_private;

  g_return_val_if_fail (source1 != NULL, NULL);
  g_return_val_if_fail (source2 != NULL, NULL);

  private1 = (GdkRegionPrivate *) source1;
  private2 = (GdkRegionPrivate *) source2;

  res = gdk_region_new ();
  res_private = (GdkRegionPrivate *) res;
  
  g_warning ("gdk_regions_union: not implemented!");
  
  return res;
}

GdkRegion*    
gdk_regions_subtract (GdkRegion      *source1,
                      GdkRegion      *source2)
{
  GdkRegionPrivate *private1;
  GdkRegionPrivate *private2;
  GdkRegion *res;
  GdkRegionPrivate *res_private;

  g_return_val_if_fail (source1 != NULL, NULL);
  g_return_val_if_fail (source2 != NULL, NULL);

  private1 = (GdkRegionPrivate *) source1;
  private2 = (GdkRegionPrivate *) source2;

  res = gdk_region_new ();
  res_private = (GdkRegionPrivate *) res;
  
  g_warning ("gdk_regions_subtract: not implemented!");
  
  return res;
}

GdkRegion*    
gdk_regions_xor (GdkRegion      *source1,
                 GdkRegion      *source2)
{
  GdkRegionPrivate *private1;
  GdkRegionPrivate *private2;
  GdkRegion *res;
  GdkRegionPrivate *res_private;

  g_return_val_if_fail (source1 != NULL, NULL);
  g_return_val_if_fail (source2 != NULL, NULL);

  private1 = (GdkRegionPrivate *) source1;
  private2 = (GdkRegionPrivate *) source2;

  res = gdk_region_new ();
  res_private = (GdkRegionPrivate *) res;
  
  g_warning ("gdk_regions_xor: not implemented!");
  
  return res;
}



