#!/bin/sh 
#ident "%W%"	%G%
#
# Copyright (C) 1994 Kubota Graphics Corp.
# 
# Permission to use, copy, modify, and distribute this material for
# any purpose and without fee is hereby granted, provided that the
# above copyright notice and this permission notice appear in all
# copies, and that the name of Kubota Graphics not be used in
# advertising or publicity pertaining to this material.  Kubota
# Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
# OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
# "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
# EXPRESS OR IMPLIED.

RELEASE="5.0"
echo
echo "Installing Portable Dore' release $RELEASE"
echo
tape=
echo "Enter non-rewind tape device: [/dev/nrtape]"
read tape
if [ -z "$tape" ]; then
    tape=/dev/nrtape
fi
echo "Do you wish to install the Dore' source code? [y/n]"
read ans
while [ -z "$ans" -o \( "$ans" != "y" -a "$ans" != "n" \) ]; do
    echo "Please answer y or n"
    read ans
done
dore_src=$ans

echo "Do you wish to install the binary Dore' library"
echo "and include files? [y/n]"
read ans
while [ -z "$ans" -o \( "$ans" != "y" -a "$ans" != "n" \) ]; do
    echo "Please answer y or n"
    read ans
done
dore_bin=$ans

if [ $dore_src = y ]; then
    if [ -d dore ]; then
	echo "directory 'dore' exsits, do you wish to install here? [y/n]"
	read ans
	while [ -z "$ans" -o \( "$ans" != "y" -a "$ans" != "n" \) ]; do
            echo "Please answer y or n"
	    read ans
	done
	if [ $ans = "n" ]; then
            echo "Installation aborted"
	    mt -t $tape rewind > /dev/null 2>&1
	    if [ $? -ne 0 ]; then
		mt -f $tape rewind
	    fi
	    exit 1
	fi

	echo
	echo "The Portable Dore' release $RELEASE has a significantly"
	echo "different directory structure than previous releases."
	echo "It is not recommended to install Portable Dore' release $RELEASE"
	echo "in a directory containing a previous release."
	echo
	echo "Are you SURE you want to proceed ? [y/n]"
	read ans
	while [ -z "$ans" -o \( "$ans" != "y" -a "$ans" != "n" \) ]; do
	    echo "Please answer y or n"
	    read ans
	done

	if [ $ans = "n" ]; then
	    echo "Installation aborted"
	    mt -t $tape rewind > /dev/null 2>&1
	    if [ $? -ne 0 ]; then
		mt -f $tape rewind
	    fi
	    exit 1
	fi
    fi

    echo 
    echo "Installing the Dore' source code"
    echo "Extracting all files ..."
    cpio -iadvmcB <$tape
    echo
    echo "Done"

else 
    mt -t $tape fsf 1 > /dev/null 2>&1
    if [ $? -ne 0 ]; then
	mt -f $tape fsf 1
    fi
fi

if [ $dore_bin = y ]; then
    echo "Installing the Dore' library and include files"
    echo "Enter the target root directory: [/usr]"
    read root_dir
    if [ -z "$root_dir" ]; then
	root_dir=/usr
    fi

    while [ ! -d $root_dir ]; do
	echo "$root_dir is not a directory."
	echo "Please enter the target root directory: [/usr]"
	read root_dir
	if [ -z "$root_dir" ]; then
	    root_dir=/usr
	fi
    done

    cd $root_dir
    cpio -iadvmcB <$tape
    echo
    echo "Done"
fi

echo "Rewinding tape ..."
mt -t $tape rewind > /dev/null 2>&1 
if [ $? -ne 0 ]; then
    mt -f $tape rewind
fi
echo
echo "Done"

