/* external stuff for ScianTextBoxes.c */

extern ObjPtr textBoxClass;

/* constants for alignment value */
#define	LEFTALIGN	1
#define	CENTERALIGN	2
#define	RIGHTALIGN	3

/* bit definitions for textbox style */
#define EDITABLE	0x01
#define WITH_PIT	0x04
#define ONE_LINE	0x08
#define ADJUSTABLE	0x10
#define DEFERCHANGE	0x00		/*EMP no longer needed*/

/*Is textbox predicate*/
#define IsTextBox(tb) IntVarEql(tb, CLASSID, CLASS_TEXTBOX)

ObjPtr SelectAll();

void InitTextBoxes();
void KillTextBoxes();
#ifdef PROTO
ObjPtr NewTextBox(int, int, int, int, int, char *, char *);
void ActivateTextBox(ObjPtr, Bool);
ObjPtr SetTextBox(ObjPtr, char *);
ObjPtr SetTextFont(ObjPtr, char *);
ObjPtr SetTextSize(ObjPtr, int);
ObjPtr SetTextLineSpace(ObjPtr, int);
ObjPtr SetTextAlign(ObjPtr, int);
ObjPtr SetTextColor(ObjPtr, ObjPtr);
ObjPtr SetTextBGColor(ObjPtr, ObjPtr);
ObjPtr SetTextBoxStyle(ObjPtr, int);
int TextHeight(ObjPtr textBox);
int LineCount(char *, int);

#else
ObjPtr NewTextBox();
void ActivateTextBox();
ObjPtr SetTextBox();
ObjPtr SetTextFont();
ObjPtr SetTextSize();
ObjPtr SetTextLineSpace();
ObjPtr SetTextAlign();
ObjPtr SetTextColor();
ObjPtr SetTextBGColor();
ObjPtr SetTextBoxStyle();
int TextHeight();
int LineCount();
#endif

