/*ScianVisObjects.h
  May 28, 1991
  Eric Pepke
  Public stuff for vis objects
*/

/*Bounded box bits*/
#define BBINNERCORNER	1	/*Show inner corner*/
#define BBFLOOR		2	/*Show inside of floor*/
#define BBCEILING	4	/*Show inside of ceiling*/
#define BBWIREFRAME	8	/*Show wire frame*/
#define BBTHICK		16	/*Thick lines*/
#define BBAXISNAMES	32	/*Show names of axes*/

#define BBXMAJOR	1024	/*Show major tics on X axis*/
#define BBXMINOR	2048	/*Show minor tics on X axis*/
#define BBYMAJOR	4096	/*Show major tics on Y axis*/
#define BBYMINOR	8192	/*Show minor tics on Y axis*/
#define BBZMAJOR	16384	/*Show major tics on Z axis*/
#define BBZMINOR	32768	/*Show minor tics on Z axis*/

extern ObjPtr isoClass, traceClass, visWindowClass, visGeometryClass;
extern ObjPtr visSurface, visColored, visDeformed;
extern WinInfoPtr winForRGB;
extern ObjPtr visIcon;
extern ObjPtr objectForRGB;
extern real globalXScale, globalYScale, globalZScale, globalFactor, globalOffset, globalFixed;
extern ObjPtr globalDeformObject;

/*Is vis obj predicate*/
#define IsVisObj(object) IntVarEql(object, CLASSID, CLASS_VISOBJ)

ObjPtr ChangeShowPalette();
ObjPtr ChangeShowControls();
ObjPtr DropInMainDatasetCorral();
ObjPtr EnterRealNumber();

#ifdef PROTO
void InitVisObjects(void);
void KillVisObjects(void);
Bool GetBounds(ObjPtr, real bounds[6]);
void ChooseRGBTask(void);
void PrefixDatasets(ObjPtr, ObjPtr);
void DefineVisMapping(long, int, int, int, ObjPtr);
ObjPtr NewVis(ObjPtr, ObjPtr);
ObjPtr NewVisIcon(ObjPtr);
ObjPtr GetAllVis(ObjPtr, Bool);
ObjPtr GetPrefVis(ObjPtr);
void ObjectRGB(WinInfoPtr);
ObjPtr DummyDeformed(ObjPtr);
void SetupDeformation(ObjPtr);
#else
void InitVisObjects();
void KillVisObjects();
Bool GetBounds();
void ChooseRGBTask(void);
void PrefixDatasets();
void DefineVisMapping();
ObjPtr VisualizeObjectAs();
ObjPtr NewVisIcon();
ObjPtr GetAllVis();
ObjPtr GetPrefVis();
void ObjectRGB();
ObjPtr DummyDeformed();
void SetupDeformation();
#endif
