/*ScianObjFunctions.h
  Eric Pepke
  April 9, 1992
  External stuff for object functions*/

#define OF_PICK_UP		"Pick Up"
#define OF_SHOW_CONTROLS	"Show Controls"
#define OF_OPEN			"Open"
#define OF_CONNECT_TO_PROCESS	"Connect to Process"
#define OF_VISUALIZE		"Visualize"
#define OF_VISUALIZE_AS		"Visualize As..."
#define OF_MODIFY		"Modify..."
#define OF_TURNON		"Turn On"
#define OF_TURNOFF		"Turn Off"
#define OF_DUPLICATE		"Duplicate"
#define OF_DELETE		"Delete"
#define OF_LOCALCOPY		"Make Local Copy"
#define OF_SETFORMAT		"Set Format"
#define OF_SHOWINFO		"Show Info"
#define OF_BRINGTOTOP		"Bring to Top"
#define OF_PUSHTOBOTTOM		"Push to Bottom"
#define OF_MOVETOBACKPANEL	"Move to Back Panel"
#define OF_MOVETOFRONTPANEL	"Move to Front Panel"
#define OF_ADVERTISE		"Publish Object"
#define OF_UNADVERTISE		"Recall from Publication"

#ifdef PROTO
void InitObjFunctions(void);
void KillObjFunctions(void);
void DoObjFunction(char *);
void AddFunctionItem(WinInfoPtr, int, int);
void AddFunctionMenus(WinInfoPtr);
void AdjustObjButtons(void);
void AdjustFunctionMenus(WinInfoPtr);
void EnableFunctionMenus(WinInfoPtr);
ObjPtr NewFunctionButton(WinInfoPtr, int, int, int, int, char *);
Bool ObjFunctionScriptLine(char *);
void LogObjFunction(char *, ObjPtr);
void LogSelectedObjFunction(char *);
void DoDoubleClickFunction(void);
ObjPtr LogSpacedObject(ObjPtr);
#else
void InitObjFunctions();
void KillObjFunctions();
void DoObjFunction();
void AddFunctionItem();
void AddFunctionMenus();
void AdjustObjButtons();
void AdjustFunctionMenus();
void EnableFunctionMenus();
ObjPtr NewFunctionButton();
Bool ObjFunctionScriptLine();
void LogObjFunction();
void LogSelectedObjFunction();
void DoDoubleClickFunction();
ObjPtr LogSpacedObject();
#endif
