/* ScianNetObjects.h John R. Murray */

#define NO_END_OF_PTRS 0
#define NO_PTR_TO_REALS 1
#define NO_PTR_TO_INTS 2
#define NO_PTR_TO_OBJPTRS 3

typedef struct PointerDescriberStruct {
    unsigned long ptrOffset;	/* location of pointer. */
    unsigned long number;	/* number of things pointed to */
    int type;			/* type of things pointed to */
} *PtrDescPtr;

typedef int NetFlagsTyp;
#define HTON_NETFLAGSTYP(x) htons(x)	/* to be consistent with FlagsTyp */
#define NTOH_NETFLAGSTYP(x) ntohs(x)

#define NO_NULL_CLASS 1L
#define NO_NULL_VARS 2L
#define NO_NULL_METHODS 4L
#define NO_NULL_DEPENDS 8L

#define NO_LAST_VAR 0L

/* different types of network packets (This is allowing for multiple ways
 * of shipping one type of object (e.g. reals) */

extern ObjPtr allPublishedObjects;

#ifdef PROTO
void InitNetObjects();
void KillNetObjects();
int PublishObject(ObjPtr);
void UnPublishObject(ObjPtr);
void TransmitObject(ObjPtr, ObjPtr);
unsigned long GetNetworkID();
ObjPtr FindPublishedObject(unsigned long);
ObjPtr ReceiveObject(ObjPtr);
ObjPtr TransmitExtraStuffRealArrayRaw(ObjPtr, ObjPtr);
ObjPtr ReceiveExtraStuffRealArrayRaw(ObjPtr, ObjPtr);
ObjPtr TransmitExtraStuffRealArrayAscii(ObjPtr, ObjPtr);
ObjPtr ReceiveExtraStuffRealArrayAscii(ObjPtr, ObjPtr);
#else
void InitNetObjects();
void KillNetObjects();
int PublishObject();
void UnPublishObject();
void TransmitObject();
unsigned long GetNetworkID();
ObjPtr FindPublishedObject();
ObjPtr ReceiveObject();
ObjPtr TransmitExtraStuffRealArrayRaw();
ObjPtr ReceiveExtraStuffRealArrayRaw();
ObjPtr TransmitExtraStuffRealArrayAscii();
ObjPtr ReceiveExtraStuffRealArrayAscii();
#endif

/* messages */				/* saying... */
#define	NO_MESG_OBJECT		"OBJ!"	/* <variable format>. Here's an object */
#define NO_MESG_SEND_OBJECT	"SNDO"	/* <objid>. Send me this object */
#define NO_MESG_MAKEVAR		"MKVR"	/* <objid> <varnum>. (NIY) Make this var for me */
#define NO_MESG_DIDMAKEVAR	"YSVR"	/* <objid> <varnum>. (NIY) I made this var for you */
#define NO_MESG_DIDNTMAKEVAR	"NOVR"	/* <objid> <varnum>. (NIY) I didn't need to make this var */
#define NO_MESG_GETVAR		"GTVR"	/* <objid> <varnum>. I want the value of this var of this object */
#define NO_MESG_GOTVAR		"GOTV"	/* <objid> <varnum> <objid>. Here's the ID of this var of this object */
						/* objid == 0 ==> NULLOBJ */
#define NO_MESG_UPDATEVAR	"UPVR"	/* <objid> <varnum>. value of var changed */

#define NET_PLAINOBJECT		"OBJ1"	/* plain old object. no trailing data*/
#define NET_INTEGER		"INT1"	/* std integer */
#define NET_REAL		"REA1"	/* std. real, first cut format. */
#define NET_REALARRAYRAW	"RAR1"	/* obj in arrayClass class, raw fmt */
#define NET_REALARRAYASCII	"RAR2"	/* obj in arrayClass class, ascii fmt */
#define NET_STRING		"STR1"	/* std string */
#define NET_ICONDATASET		"IDS1"	/* obj in iconDataset class */
#define NET_ICON1DVECTOR	"I1V1"	/* obj in icon1DVector class */
#define NET_ICON2DVECTOR	"I2V1"	/* obj in icon2DVector class */
#define NET_ICON3DVECTOR	"I3V1"	/* obj in icon3DVector class */
#define NET_ICON4DVECTOR	"I4V1"	/* obj in icon4DVector class */
#define NET_ICON1DSCALAR	"I1S1"	/* obj in icon1DScalar class */
#define NET_ICON2DSCALAR	"I2S1"	/* obj in icon2DScalar class */
#define NET_ICON3DSCALAR	"I3S1"	/* obj in icon3DScalar class */
#define NET_ICON4DSCALAR	"I4S1"	/* obj in icon4DScalar class */
#define NET_DATA1DVECTOR	"D1V1"	/* obj in data1DVector class */
#define NET_DATA2DSCALAR	"D2S1"	/* obj in data2DScalar class */
#define NET_DATA3DSCALAR	"D3S1"	/* obj in data3DScalar class */
#define NET_DATA3DUNSTRUCT	"D3U1"	/* obj in dat3DUnstructSurface class */
#define NET_DATASET		"DAT1"	/* obj in generic dataset class */
#define NET_DATAFORM		"DFM1"	/* obj in dataform class */
#define NET_TIMEDOBJECT		"TOB1"	/* obj in timedObjClass */
