/*ScianThingLists.h
  External stuff for lists of things.
*/

typedef struct objlist			/*List of objects*/
    {
	struct objlist *next;		/*Next thing in list*/
	ThingPtr thing;		/*This thing*/
    } ThingListElement, *ThingListPtr;

typedef struct
    {
	Thing thing;			/*The thing part, containing flags*/
	ThingListPtr list;		/*The list, initially 0*/
    } List, *LPtr;

#define LISTOF(l) (((LPtr) l) -> list)

/*Method declarations*/
ObjPtr KeyDownList();
ObjPtr PressList();

#ifdef PROTO
ObjPtr NewList(void);
Bool PrefixList(ObjPtr, ThingPtr);
Bool PostfixList(ObjPtr, ThingPtr);
int DeleteFromList(ObjPtr, ThingPtr);
void DisposeList(ObjPtr);
int ListCount(ObjPtr);
ObjPtr GetListElem(ObjPtr, int);
void DrawList(ObjPtr);
ObjPtr DropList(ObjPtr, ObjPtr, int, int);
void InitLists(void);
void KillLists(void);
Bool AppendList(ObjPtr, ObjPtr);
Bool InsertList(ThingListPtr, ObjPtr);
void EmptyList(ObjPtr);
ObjPtr CopyList(ObjPtr);
#else
ObjPtr NewList();
Bool PrefixList();
Bool PostfixList();
int DeleteFromList();
void DisposeList();
int ListCount();
ObjPtr GetListElem();
void DrawList();
ObjPtr DropList();
void InitLists();
void KillLists();
Bool AppendList();
Bool InsertList();
void EmptyList();
ObjPtr CopyList();
#endif

