/*Object IDs and variable IDs
  Eric Pepke
  March 28, 1990
*/

/*Variables and methods*/
#define DATA		1	/*Data variable*/
#define DATAFORM	2	/*Data form*/
#define COLORS		3	/*Colors for field dots*/
#define DIMENSIONS	4	/*Dimensions of something*/
#define BOUNDS		5	/*Bounds of an object*/
#define ICONLOC		6	/*Icon location*/
#define REPOBJ		7	/*Object this object represents*/
#define NAME		8	/*Name of this object*/
#define DRAW		9	/*Draw yerself.*/
#define CONTENTS	10	/*Contents of this panel, corral, or whatever*/
#define WHICHICON	11	/*The number of the icon*/
#define PRESS		12	/*Press method*/
#define SELECTED	13	/*Selected variable*/
#define HIGHLIGHTED	14	/*Highghlighghglighghted variable.*/
#define BASECOLOR	15	/*Base color of an object*/
#define XFORM		16	/*Rotation and translation matrix for an observer*/
#define ROTATE		17	/*Rotate message*/
#define BUTTONTYPE	18	/*Type of button*/
#define MARKERTYPE	19	/*Type of marker*/
#define XSTRETCH	20	/*Stretch in X*/
#define YSTRETCH	21	/*Stretch in Y*/
#define CHANGEDVALUE	22	/*Changedvalue method for buttons & controls*/
#define LEVEL		23	/*Level in a slice*/
#define ADDCONTROLS	24	/*Gives visualization a chance to add controls*/
#define DRAWCONTENTS	25	/*Method to draw the contents of something*/
#define PRESSCONTENTS	26	/*Method to press in the contents of something*/
#define BACKGROUND	27	/*Background color of something*/
#define STYLE		28      /*Style of anything*/
#define LOVALUE         29      /*Lower limit of slider value*/
#define HIVALUE         30      /*Upper limit of slider value*/
#define STEPVALUE       31      /*Step value of slider*/
#define VALUE           32      /*Current value of slider*/
#define VALUE2          33      /*Second value of dual-value slider*/
#define GETVAL		34	/*Get value method*/
#define NORMALS		35	/*Normals for a mesh*/
#define DEFAULTICON	36	/*Default icon for a visualization object*/
#define NEWCTLWINDOW	37	/*New control window method*/
#define SPECVAL		38	/*Specular value*/
#define SHINVAL		39	/*Shininess value*/
#define CLEANUP		40	/*Clean up object message*/
#define CLOSE		41	/*Close (a window) message*/
#define STICKINESS	42	/*Stickiness of an object, flag bits*/
#define RESHAPE		43	/*Reshape a window*/
#define INITIALIZE	44	/*Initialize an object*/
#define HILITESEGMENT	46	/*Variable containing hilite segment*/
#define SURFACE		47	/*Variable containing a surface*/
#define DELTAS		48	/*Variable containing deltas in a field*/
#define ISTRANSPARENT	49	/*True iff surface is transparent*/
#define BRIGHTNESS	50	/*Brightness of a surface*/
#define ISOVAL		51	/*Isosurface value*/
#define YAW		53	/*Yaw of the eye*/
#define ROLL		54	/*Roll of the eye*/
#define PITCH		55	/*Pitch of the eye*/
#define KEYDOWN		56	/*KeyDown method*/
#define AIRSPEED	57	/*Airspeed of eye*/
#define LASTTIME	58	/*Last time eye was moved*/
#define PERSPECSTUFF	59	/*Perspective stuff*/
#define DROTATION	60	/*Change in rotation matrix*/
#define CONNECT		61	/*Connect something, maybe a recorder*/
#define DISCONNECT	62	/*Disconnect something*/
#define PORTNUMBER	63	/*Port number for a recorder*/
#define RECORD		64	/*Record some frames*/
#define PREPARETORECORD	65	/*Prepare to record some frames*/
#define STOPRECORDING	66	/*Stop recording*/
#define SNAPONEFRAME	67	/*Snap a single frame shot*/
#define SELECT		68	/*Select an icon or something*/
#define ICONY		70	/*Y of next icon*/
#define MATERIALHUE	71	/*Hue of material*/
#define CONTROLICON	72	/*Icon for controlling stuff*/
#define PANEL		74	/*Var holding control panel for an icon or space*/
#define PANELCONTENTS	75	/*Contents for a control panel for an icon*/
#define REPICON		76	/*Icon that represents this field*/
#define MULTIDRAW	77	/*True iff all classes of objects are to be drawn*/
#define BBFLAGS		78	/*Flags for bounding box*/
#define WHICHFLAG	79	/*Which flag a check box controls*/
#define SETVAL		80	/*Method to set a value*/
#define LILSTEP		81	/*Little step in a scale*/
#define BIGSTEP		82	/*Big step in a scale*/
#define FORMAT		83	/*Format of numbers*/
#define TRACKNOT	84	/*Variable to inhibit tracking*/
#define MAXSIZE		85	/*Maximum size of objects within space*/
#define SPACE		86	/*Space to which this object belongs*/
#define PARENT		87	/*Parent of object in window*/
#define PORTIONSHOWN	89	/*Portion of a scrolled window that's shown*/
#define TIMESTEPS	92	/*Array of time steps*/
#define TIMEDATA	93	/*Data corresponding to the time steps*/
#define OWNERWINDOW	94	/*Window that owns this space*/
#define WAKEUP		95	/*Wakeup call*/
#define CLOCK		97	/*The clock in this space*/
#define TIME		98	/*Time of this space*/
#define TIMEBOUNDS	99	/*Bounds of the time, array[2] of real*/
#define FOCUSPOINT	100	/*Point of focus*/
#define FOCUSDIST	101	/*Distance of focus, relates FOCUSPOINT to EYEPOSN*/
#define SMOOTH		102	/*Boolean value of smoothness of curve*/
#define SHEAR		103	/*Shear matrix*/
#define ALIGNMENT	104	/*Alignment*/
#define WHICHDIALOG	105	/*Identifier for dialog*/
#define DTIME		106	/*Delta time per second*/
#define MARKTIME	107	/*Mark time in a time-dependant field*/
#define ANCHOR		108	/*Anchor for a slider*/
#define COLOR		109	/*Color of a something*/
#define DISPLAY		111	/*Display yourself*/
#define BUTTONPRESSED	113	/*Method when a button has been pressed*/
#define CURRENT		114	/*Current object in window clicked*/
#define KEYSTRING	115	/*String so far in a slider from keypress*/
#define READOUT		116	/*Slider readout*/
#define SETREADOUT	117	/*Method to set slider readout*/
#define PICSTATE	118	/*State of picture*/
#define MAKEDRAWN	119	/*Method to make something drawn if not already*/
#define MARK		120	/*Mark method*/
#define INHIBITDRAWING	121	/*Flag to inhibit drawing.  DrawObject looks at it*/
#define DRAWME		122	/*Temporary flag to mark drawing*/
#define XSCALE		123	/*Scale along X dimension*/
#define YSCALE		124	/*Scale along Y dimension*/
#define ZSCALE		125	/*Scale along Z dimension*/
#define DOUBLECLICK	126	/*Double click method*/
#define NCELLS		127	/*Number of cells in a switch*/
#define OUTCELL		128	/*Which cell is the output*/
#define ISTRANSLUCENT	129	/*True iff translucent*/
#define OTHERSWITCH	130	/*Another switch*/
#define DONTCHANGE	131	/*Temporary flag meaning don't do changedvalue*/
#define GETMINMAX	132	/*Method to get the scalar min and max*/
#define MINMAX		133	/*Minimum and maximum*/
#define CPALETTE	136	/*Variable to store palette*/
#define COLOROBJ	137	/*Object waiting to be color*/
#define DROPOBJECTS	138	/*Method to drop some objects*/
#define DROPINCONTENTS	139	/*Drop in contents of something like a corral*/
#define HSCROLL		141	/*Horizontal scroll bar*/
#define VSCROLL		142	/*Vertical scroll bar*/
#define RECALCSCROLL	143	/*Recalculate scroll bars*/
#define LABEL		144	/*Label of button*/
#define ISOSLIDER	145	/*Slider for an iso value*/
#define HANDLEMISSING	146	/*Integer specifying how to handle missing data*/
#define NODES		147	/*Nodes for an unstructured grid*/
#define EDGES		148	/*Edges for an unstructured grid*/
#define CELLS		149	/*Cells for an unstructured grid*/
#define TEXTFONT	150	/*Text font*/
#define TEXTSIZE	151	/*Text size, as if you couldn't guess.*/
#define LINESPACE	152	/*Line spacing for text boxes*/
#define SPACES		153	/*List of spaces*/
#define DRAWCOVER	154	/*Cover to draw*/
#define DISPLAYCLOCK	156	/*Displayed clock in a space*/
#define MAGICDRAG	157	/*Predicate giving magic drag of a panel*/
#define FRONTPANEL	158	/*Front space panel*/
#define BACKPANEL	159	/*Back space panel*/
#define BINDTOSPACE	161	/*Method to bind a controller to a space*/
#define TOUCHSPACE	162	/*Method for a changed controller to touch a space*/
#define OBSERVER	163	/*Observer of this space.  That's YOU!*/
#define WHICHUPDATE	164	/*Place for current update*/
#define ERRORLIST	165	/*List of errors waiting*/
#define ERRORNUMBER	166	/*Currently displayed error*/
#define ERRORTEXT	167	/*TextBox of the error message*/
#define ERRORCOUNT	168	/*Number of errors*/
#define DPITCH		169	/*Change in pitch*/
#define ALWAYSCHANGE	170	/*Always do a changed value*/
#define RANGE		171	/*Range of a whatever*/
#define FILETYPE	172	/*File type*/
#define MARQUEE		173	/*Marquee around icons*/
#define LOCATION	174	/*Location of an object, usually in 3-space*/
#define LIGHTS		175	/*Individual lights in a lights class*/
#define WHATVALUE	176	/*A value for a button that changes a slider*/
#define CYCLECLOCK	177	/*Clock cycle predicate*/
#define GETVISDATASETS	180	/*Returns a dataset or list of datasets from vis obj*/
#define PANELHIDDEN	181	/*True iff the panel is hidden*/
#define ENCLOSELOW	182	/*True iff enclosing low values in isosurface*/
#define ENABLED		183	/*True iff something is enabled, like a light*/
#define FINDOBJECT	184	/*Finds an object*/
#define INTERPOLATEP	185	/*True iff we're to interpolate*/
#define RESOLVE		186	/*Method to resolve a controller after spaces touched*/
#define TIMEREGISTERED	187	/*Dummy variable for registering time*/
#define LASTTIMESTEP	188	/*Size of last time step*/
#define PREFVIS		189	/*Preferred visualization*/
#define TRANSLUCENTCNT	190	/*Translucent control, if already made*/
#define TRANSPARENTCNT	191	/*Transparent control, if already made*/
#define COLORSHADING	192	/*Color shading value*/
#define LIGHTSHADING	193	/*Light shading value*/
#define COLORSHADED	194	/*Dummy dependency variable for color shaded*/
#define LIGHTSHADED	195	/*Dummy dependency variable for light shaded*/
#define PICCOLORED	196	/*Dummy dependency variable for picture colored*/
#define MAINDATASET	197	/*The main data set which sets up the time*/
#define ISOFIELD	198	/*The field that the isosurface is made from*/
#define SETMAINDATASET	199	/*Method for a vis object to accept a main field*/
#define CONTOURFIELD	200	/*Field for contours*/
#define UNSTRUCTURED	201	/*Boolean that tells if a data form is unstructured*/
#define VIEWBYWHAT	202	/*View by icon or name*/
#define VIRTUALBOUNDS	203	/*Virtual bounds of a scrolled field*/
#define BGNSEL		204	/* index of first char of text selection */
#define ENDSEL		205	/* index of last char of text selection */
#define SELECTALL	206	/* method to select all text in a textbox */
#define CALLBACK	207	/* callback method for a dialog */
#define	FILELIST	208	/* list of file lists by type */
#define SELECTOR	209	/* selector bits for file types */
#define PATH		210	/* path name to file window's directory */
#define OKMETHOD	211	/* method to call when OK button pressed */
#define SHOWFILES	212	/* method to show files in a corral */
#define REGISTERFIELD	213	/*Method to register a field*/
#define HIDDEN		214	/*True iff a visualization object is hidden*/
#define ICONGREYED	215	/*Greyed (an icon*)*/
#define WHICHPREF	216	/*Which preference a control deals with*/
#define HIGHLIGHTCOLOR	217	/*Color of a highlight*/
#define HIDE		219	/*Hide method*/
#define CLONE		220	/*Clone yourself method*/
#define ACTIVATED	221	/*Object is activated*/
#define ICONEXTRADRAW	222	/*Method to draw extra stuff for an icon*/
#define CURDATA		224	/*Current data*/
#define CMODERADIO	225	/*Color map radio button for a window*/
#define RENDERER	226	/*Renderer for a space*/
#define RENDERTYPE	227	/*Type of renderer*/
#define FILTERTYPE	228	/*Type of image filter*/
#define ENTERMETHOD	229	/*Method to call when enter key pressed in object*/
#define KEDGES		230	/*K-edges*/
#define DELETEICON	232	/*Message to send an icon to delete its repobj before deleting*/
#define CORRAL		233	/*Corral assoc with a space or window*/
#define VISBUTTON	234	/*The vis button for a corral*/
#define SHOWCNTBUTTON	235	/*Show controls button*/
#define TIMEPERPIXEL	236	/*Time per pixel on screen in time control*/
#define PREFIXDATASETS	237	/*Method to have a vis object prefix datasets it uses*/
#define DATASETS	238	/*Datasets of a clock*/
#define DISPLAYSTEP	239	/*Step for displaying time*/
#define DISPLAYTICS	240	/*Number of tics per time step*/
#define TIMECONTROL	241	/*A time control in a dialog*/
#define AUTOSCROLL	242	/*Autoscroll message*/
#define REINIT		243	/*Reinitialize controller*/
#define TIMEFORMAT	244	/*Format of time associated with dataset*/
#define CUT		245	/*Method to cut from something*/
#define COPY		246	/*Method to copy from something*/
#define PASTE		247	/*Method to paste on something*/
#define CLEAR		248	/*Method to clear something*/
#define TOPVARS		249	/*Topological variables*/
#define LASTINTERP	250	/*Last value of interpolate*/
#define VALUESET	251	/*Predicate, means new set value has been registered once*/
#define DRAWNFULL	252	/*Predicate, of a window if it was drawn fully*/
#define ROTATING	253	/*Of a space, predicate saying we are rotating*/
#define MOVING		254	/*Of a space, true iff moving*/
#define HELPSTRING	255	/*The help string of an object for the default help system*/ 
#define BORDERTYPE	256	/*Type of border, on a panel*/
#define HELPCONTENTS	257	/*Array of contents for help*/
#define HELPRADIO	258	/*Radio button in a help dialog*/
#define TYPESTRING	259	/*type string*/
#define	MAKE1HELPSTRING	260	/*Makes the help string*/
#define SINGLECORRAL	261	/*True iff corral can only hold one icon*/
#define REGISTERCOMP	262	/*Method to register a component*/
#define XFIELD		263	/*Field for X of trace*/
#define YFIELD		264	/*Field for Y of trace*/
#define ZFIELD		265	/*Field for Z of trace*/
#define XTOPDIM		266	/*Topological dimension for X*/
#define YTOPDIM		267	/*Topological dimension for Y*/
#define ZTOPDIM		268	/*Topological dimension for Z*/
#define ORTHO		269	/*Predicate to see if a perspec control is ortho*/
#define NCOMPONENTS	270	/*Number of components for a vector dataset or null for scalar*/
#define INDICES		271	/*Indices for array*/
#define COLORCELLS	272	/*What kind of color cells*/
#define ZDISPLACED	273	/*True iff z is displaced*/
#define VISASBUTTON	274	/*Visualize As button*/
#define PARENTS		275	/*List of parents*/
#define SLIDER		276	/*A slider a text box represents*/
#define CHANGED		277	/*Dummy variable used sometimes to indicate data changed*/
#define PALETTESET	278	/*Set if a color palette is set in a dataset*/
#define COLORWHEEL	279	/*Color control*/
#define KEPTPALETTE	280	/*The kept palette*/
#define COLORBAR	281	/*A color bar with which a slider or colorwheel works*/
#define OLDCOLORS	282	/*Old colors to revert to*/
#define BUTTON		283	/*A random button*/
#define TEMPPALETTE	284	/*Temporary palette*/
#define INITVALUE	285	/*Initial value of something*/
#define KEEPBUTTON	286	/*Keep button*/
#define REVERTBUTTON	287	/*Revert button*/
#define PALETTEFUNC	288	/*Palette function*/
#define FULLCOMPBUTTONS	289	/*List of buttons to activate or deactivate on full and components*/
#define COMPBUTTONS	290	/*List of buttons to activate or deactivate on components*/
#define EDITMODE	291	/*The edit mode, esp. of a color bar*/
#define TOOLGROUP	292	/*Group of tools*/
#define FUNCTIONBOX	293	/*Box that controls a function*/
#define FREEFORMBUTTON	294	/*Button for free form tool*/
#define HALTHELP	295	/*Halt help search predicate*/
#define NCOLORBOX	296	/*Box for ncolors*/
#define MINBOX		297	/*Box for min*/
#define MAXBOX		298	/*Box for max*/
#define REGISTERFORM	299	/*Register data form*/
#define JUSTCOLORCHANGE	300	/*Just the colors changed*/
#define GETTOPDIM	301	/*Get topological dimension*/
#define INITFILTER	302	/*Initialize filter*/
#define GETSPATIALDIM	303	/*Get spatial dimension*/
#define GETDATASETINFO	304	/*Get dataset info*/
#define SETRGBMESSAGE	305	/*Message to set to RGB*/
#define DIMVALUES	306	/*Array of dimension values*/
#define GETFORMDIMS	307	/*Method to get form dimensions*/
#define OPENBTN		308	/*Open button in file window*/
#define SETFORMATBTN	309	/*Set Format button in file window*/
#define SHOWINFOBTN	310	/*Show Info button in file window*/
#define FILEINFO	313	/*Text box in file information window*/
#define WHICHDIMENSION	314	/*Which dimension a slider controls*/
#define TOPDOWN		315	/*Predicate of field, true iff top down*/
#define VIEWTYPE	316	/*Type of view*/
#define EYEOFFSET	317	/*Offset of individual eyes*/
#define PERSPECCONTROL	318	/*Perspective control of this radio group*/
#define OLDVALUE	319	/*Old value for something*/
#define INTERPCOLORS	320	/*True iff interp colors*/
#define DRAWSURFACE	321	/*Draw the surface*/
#define DRAWWIREFRAME	322	/*Draw the wire frame*/
#define VECTORFACTOR	323	/*Factor for vector displays*/
#define SHAFTWIDTH	324	/*Width of an arrow's shaft*/
#define	HEADWIDTH	325	/*Width of an arrow's head*/
#define HEADLENGTH	326	/*Length of an arrow's head*/
#define GETLONGNAME	327	/*Returns long name of an object*/
#define WHICHVAR	328	/*Which var for numeric text*/
#define TEMPLATEP	329	/*True iff the object is a template*/
#define ALLFILTERS	331	/*Method to get all filters*/
#define DISPOSE		332	/*Dispose method for a window*/
#define READALL		333	/*Read all of a file method*/
#define OLDREAD		334	/*Old style file read routine, NOT method style*/
#define EXTENSION	335	/*Extension for file reader*/
#define TIMEDDATASETS	336	/*Timed datasets flags*/
#define OUTOFBOUNDS	337	/*Integer specifying how to handle out of bounds*/
#define TICDENSITY	338	/*Tic mark density*/
#define TICLENGTH	339	/*Length of tic marks*/
#define SPHERESUBDIV	340	/*Sphere subdivisions*/
#define FRUSTUMSUBDIV	341	/*Subdivision of a frustum*/
#define CAPENDSP	342	/*Cap ends predicate*/
#define ETERNALPART	343	/*Eternal portion of a picture*/
#define YOURENOTCURRENT	344	/*You're not current anymore message*/
#define HIDEPANEL	345	/*True iff window has panel to hide*/
#define MINMAJORSTEP	346	/*Number of pixels minimum in major step*/
#define COLORBYFIELD	347	/*Color text by field*/
#define CHECKBOX	348	/*A check box*/
#define SHOWOVERUNDER	349	/*Show over and under*/
#define SHOWMISSING	350	/*Show missing data*/
#define NUMBERSONLY	351	/*Numbers only*/
#define SHOWMINORTICS	352	/*Show minor tics*/
#define ROTAXIS		353	/*Axis of rotation*/
#define ROTSPEED	354	/*Rotation speed*/
#define FLYING		355	/*F L Y I N ---- G predicate*/
#define DEFORMOBJ	356	/*Deformation object*/
#define DEFCONSTANT	357	/*Constant deformation*/
#define DEFOFFSET	358	/*Offset of deformation*/
#define DEFFACTOR	359	/*Factor of deformation*/
#define DEFORMSWITCH	360	/*Value of deform switch*/
#define REVERSESENSE	361	/*Reverse order of contour*/
#define COLORMODEL	362	/*Color model for palette*/
#define CMODELRADIO	363	/*Color model radio button*/
#define FILENAME	364	/*Name of file where a dataset was found*/
#define DIRECTORY	365	/*Name of directory where a dataset was found*/
#define SAVECPANEL	366	/*Method to save the controls of an object*/
#define SAVEALLCONTROLS	367	/*Method to save all the indiv. controls of an object*/
#define CONTOURLINES	368	/*List of contour lines in an object*/
#define STARTVALUE	369	/*Starting value of a contour line*/
#define PICDEFORMED	370	/*Dummy variable for deformed picture*/
#define CONNECTIONSTATE 372	/*State of a connection*/
#define INHIBITLOGGING	373	/*Control predicate, inhibits logging*/
#define TIMEOUT		374	/*Timeout message*/
#define CURCMD		375	/*Current command being assembled*/
#define CMDPROCNAME	377	/*Command process name*/
#define ALLPROCESSES	378	/*All processes in a connection*/
#define OBJPANEL	380	/*A space's object panel*/
#define TOOLPANEL	381	/*A space's tool panel*/
#define ESCAPED		382	/*Connection is escaped*/
#define EDITTOOL	383	/*Edit tool*/
#define LINEWIDTH	384	/*Line width*/
#define COLORWIDTH	385	/*Width of a color bar in a palette display*/
#define TEXTWIDTH	386	/*Width of text on a palette display*/
#define STARTPOINT	387	/*Starting location (for a line)*/
#define ENDPOINT	388	/*Ending location (for a line)*/
#define ARROWHEAD	389	/*Of a line, are there arrowheads at each side*/
#define READER		390	/* reader for a file */
#define FIELD		391	/* control field */
#define OPEN		392	/* open message */
#define CLASSID		393	/*ID of a class*/
#define ONEONLY		394	/*One only predicate, of a controller in a space*/
#define TWOSIDEDSURFACE	395	/*Two-sided surface predicate*/
#define CONTROLLERP	396	/*True iff it's a controller*/
#define SHOWGRID	397	/*True iff show grid*/
#define FUNCTIONBUTTONS 398	/*List of function buttons in a window*/
#define SHOWCONTROLS	399	/*Show controls method of an object*/
#define DOFUNCTION	400	/*Deferred message for an object function button*/
#define VISUALIZE	401	/*Visualize an object*/
#define VISUALIZEAS	402	/*Visualize an object as...*/
#define MODIFY		403	/*Modify datasets*/
#define DELETE		404	/*Delete yourself from current window*/
#define SHOW		405	/*Show an object, opposite of hide*/
#define DUPLICATE	406	/*Duplicate an object*/
#define LOCALCOPY	407	/*Make local copy*/
#define PICKUP		408	/*Pick up an object*/
#define COLLECT		409	/*Collect object into a list*/
#define FORALLOBJECTS	410	/*For all objects method*/
#define APPEARANCE	411	/*Appearance of an object*/
#define BEVELED		412	/*Beveled style predicate*/
#define SHADOW		413	/*Shadow int variable*/
#define BINOCULARITY	414	/*Binocular distance*/
#define BRINGTOTOP	415	/*Bring object to top*/
#define PUSHTOBOTTOM	416	/*Push object to bottom*/
#define MOVETOBACKPANEL	417	/*Move to back panel*/
#define MOVETOFRONTPANEL 418	/*Move to front panel*/
#define MESHFIELD	419	/*Field for the mesh*/
#define CONTOURCENTER	420	/*Center value of contour*/
#define CONTOURSTEP	421	/*Step of contour*/
#define CONTOURMAX	422	/*Maximum value of contour*/
#define CONTOURDIV	423	/*Divisions of contour*/
#define CONTOURMIN	424	/*Minimum value of contour*/
#define CONTOURMAJWIDTH	425	/*Major width of contours*/
#define CONTOURMINWIDTH	426	/*Minor width of contours*/
#define DEFERLASTKEY	427	/*Defer the last keystroke*/
#define XNAME		428	/*Name of X axis*/
#define YNAME		429	/*Name of Y axis*/
#define ZNAME		430	/*Name of Z axis*/
#define READVECTOR	431	/*Read vector data*/
#define DTIMEPER	432	/*Delta time per second*/
#define RUNSPEED	433	/*Control integer for running*/
#define RUNCONTROL	434	/*Running radio button*/
#define DTIMEUNITS	435	/*Units for delta time*/
#define DTIMEPERUNITS	436	/*Units for delta time per*/
#define TIMESTEP	437	/*Time step in a clock*/
#define SHOWPANEL 	438	/*Show a panel*/
#define CONNECTIONKIND	439	/*Kind of connection*/
#define MOVESKELETON	440	/*True iff move skeleton*/
#define CONNECTTOPROCESS 441	/*Connect to a process*/
#define OUTPUTQUEUE	442	/*Output queue for a connection*/
#define OWNERCONNECTION	443	/*The connection of a process*/
#define CMDPROCSOCKET	444	/*Socket for a proc*/
#define ALLOBJECTS	445	/*All objects of a proc*/
#define SOCKETID	446	/*Socket a process wants to connect*/
#define OBJECTID	448	/*ID of object*/
#define ADVERTISED	449	/*Of an object, true iff advertised*/
#define ADVERTISE	450	/*Advertise obj function*/
#define UNADVERTISE	451	/*Unadvertise obj function*/
#define OLDCONNSTATE	452	/*Old connection state*/
#define OWNERPROCESS	453	/*Process that owns this connection*/
#define READNUMBERONE	454
#define READNUMBERTWO	455
#define READNUMBERTHREE	456
#define RECEIVEEXTRA	457
#define NETWORKID	458
#define TRANSMITEXTRA	459
#define ALLADVERTISED	460	/*Advertised objects of a process*/
#define TARGETOBJECT	461	/*Target for an incoming object*/
#define TARGETVAR	462
#define NEWREMOTEOBJ	463	/*New remote object method*/
