/* ScianTypes.h: header file for ScianTypes.c structures. requires
		that Scian.h be included prior to this file.
	This file contains, in order, what was once ScianObjects.h,
	the old ScianTypes.h, and ScianArrays.h
*/

typedef unsigned long FlagsTyp;		/*Type for thing*/
typedef unsigned long NameTyp;		/*Name defining things and variables*/

/*Object types*/
typedef struct VarsNode {
	NameTyp		name;		/*ID # of this variable association */
	struct Obj	*value;		/*(ThingPtr) value of this var. assoc.*/
	struct VarsNode	*left;		/*internal pointers to subtrees */
	struct VarsNode	*right;
	long		chCount;	/*count number of changes to this var*/
} Vars, *VarsPtr;


typedef struct Obj {
	FlagsTyp	flags;		/*Type flags of the thing*/
	int		refCount;	/*Number of times referenced*/
	NameTyp		name;		/*object ID # */
	struct Obj	*class;		/*pointer to class of object */
	VarsPtr		vars;		/*pointer to top node of Vars bintree*/
	struct MethNode	*methods;	/* " to top node of Methods bintree */
	int		garbageFlag;	/*flags for deletion record-keeping */
        struct Obj	*gNext;		/*next node in garbage list*/
        struct Obj	*rNext;		/*next node in reference list*/
} Thing, *ThingPtr, Obj, *ObjPtr;

#define NULLOBJ ((ObjPtr) 0)
typedef ObjPtr (* FuncTyp)();		/*typedef Methods function pointers */
extern ObjPtr ObjTrue;
extern ObjPtr ObjFalse;

typedef struct MethNode {
	NameTyp		name;		/*ID # of Method association */
	FuncTyp		method;		/*pointer to Method function */
	struct MethNode	*left;		/*internal pointers to subtrees */
	struct MethNode *right;
} Method, *MethodPtr;

extern long globalThingCount;	/* number of things in the world */

#define IncGlobalThingCount() (++globalThingCount)

/*** former ScianObjects functions definitions */

#ifdef	PROTO
Bool		IsTrue(ObjPtr);
ObjPtr		SetObjValue(ObjPtr, ObjPtr);
ObjPtr		GetObjValue(ObjPtr);
void		InitObjects();
void		KillObjects();
ObjPtr		NewObject(ObjPtr class,NameTyp name);
ObjPtr		ClassOf(ObjPtr);
Bool		InClass(ObjPtr object, ObjPtr class);
unsigned long	GetVarChangeCount(ObjPtr, NameTyp);
ObjPtr		SetVar(ObjPtr object,NameTyp varname,ThingPtr value);
Bool		ChangeVar(ObjPtr, NameTyp, ObjPtr);
ThingPtr	GetVar(ObjPtr object,NameTyp varname);
ThingPtr	Get1Var(ObjPtr, NameTyp);
void		PrintObject(ObjPtr object);
void		PrintVarNodes(VarsPtr vp, int indent);
void		PrintVarTree(ObjPtr object);
void		DeleteThing(ObjPtr thing);
void		DecGlobalThingCount();
FuncTyp		GetMethod(ObjPtr object, NameTyp methname);
FuncTyp		Get1Method(ObjPtr, NameTyp);
Bool		SetMethod(ObjPtr obj, NameTyp methname, FuncTyp value);
Bool		SanityCheckObject(ObjPtr);
#else
Bool		IsTrue();
ObjPtr		SetObjValue();
ObjPtr		GetObjValue();
void		InitObjects();
void		KillObjects();
ObjPtr		NewObject();
ObjPtr		ClassOf();
Bool		InClass();
unsigned long	GetVarChangeCount();
ObjPtr		SetVar();
Bool		ChangeVar();
ThingPtr	GetVar();
ThingPtr	Get1Var();
void		PrintObject();
void		PrintVarNodes();
void		PrintVarTree();
void		DeleteThing();
void		DecGlobalThingCount();
FuncTyp		GetMethod();
FuncTyp		Get1Method();
Bool		SetMethod();
Bool		SanityCheckObject();
#endif

#define GetRefCount(thingp) ((thingp) ? (thingp) -> refCount : -1)

/*** former ScianTypes structures and functions */

typedef	struct	RealStruct {
		Thing	thing;			/* flags and stuff */
		real	realpart;		/* the actual Real data */
} RealThing, *RPtr;

typedef ObjPtr RealPtr;

typedef struct	IntStruct {
		Thing	thing;			/* flags and stuff */
		int	intpart;		/* the actual Integer data */
} IntThing, *IPtr;

typedef ObjPtr IntPtr;

typedef struct	StringStruct {
		Thing	thing;			/* flags and stuff */
		char	*stringPtr;		/* the actual String data */
} StringThing, *SPtr;

typedef ObjPtr StringPtr;

#ifdef PROTO
ObjPtr	NewInt(int intno);
int	GetInt(ObjPtr ip);
void	SetInt(ObjPtr ip,int intno);
void	PrintInt(ObjPtr ip);
ObjPtr	NewReal(real realno);
real	GetReal(ObjPtr rp);
void	SetReal(ObjPtr rp,real realno);
void	PrintReal(ObjPtr rp);
ObjPtr	NewString(char *string);
char	*GetString(ObjPtr sp);
Bool	SetString(ObjPtr sp, char *string);
ObjPtr	ConcatStrings(ObjPtr, ObjPtr);
void	PrintString(ObjPtr sp);
Bool	Eql(ObjPtr, ObjPtr);
ObjPtr	Clone(ObjPtr);
#else
ObjPtr	NewInt();
int	GetInt();
void	SetInt();
void	PrintInt();
ObjPtr	NewReal();
real	GetReal();
void	SetReal();
void	PrintReal();
ObjPtr	NewString();
char	*GetString();
Bool	SetString();
ObjPtr	ConcatStrings();
void	PrintString();
Bool	Eql();
void	Clone();
#endif

