/*ScianVisWindow.h
  Public stuff for ScianVisWindow.c
  Eric Pepke
  April 6, 1990
*/

/*Bounded box bits*/
#define BBWIREFRAME	1	/*Show wire frame*/
#define BBINNERCORNER	2	/*Show inner corner*/
#define BBFLOOR		4	/*Show inside of floor*/
#define BBCEILING	8	/*Show inside of ceiling*/
#define BBTHICK		16	/*Thick lines*/
#define BBAXISNAMES	32	/*Show names of axes*/
#define BBBIGGERBOUNDS	64	/*Make bounds a bit bigger*/
#define BBSHOWGRID	128	/*Show the grid*/

#define BBXMAJOR	1024	/*Show major tics on X axis*/
#define BBXMINOR	2048	/*Show minor tics on X axis*/
#define BBYMAJOR	4096	/*Show major tics on Y axis*/
#define BBYMINOR	8192	/*Show minor tics on Y axis*/
#define BBZMAJOR	16384	/*Show major tics on Z axis*/
#define BBZMINOR	32768	/*Show minor tics on Z axis*/

#define TIMESLIDERNAME	"Time"		/*Name of the time slider*/

typedef float nmls[3];			/*Array of 3 normals*/

#define MESHMATERIAL	2
#define ISOMATERIAL	3
#define GEOMATERIAL	4

/*Function prototypes*/
#ifdef PROTO
WinInfoPtr NewVisWindow(char *, long);
ObjPtr FindMainCorral(WinInfoPtr);
void VisObjects(void);
void VisObjectsAs(void);
ObjPtr FindSpace(WinInfoPtr);
ObjPtr FindPanel(WinInfoPtr);
ObjPtr FindPerspecControl(WinInfoPtr);
void RotateOrthoWindow(WinInfoPtr, char, float);
void RotateWindowTo(WinInfoPtr, Matrix);
void ShowPanel(void);
void HidePanel(void);
void DoShowControls(void);
void ShearOrthoWindow(WinInfoPtr window, float amount);
void DoShowClock();
ObjPtr VisIcon(ObjPtr);
void InitVisWindows(void);
void KillVisWindows(void);
void ForAllVisWindows(void (*routine)());
ObjPtr NewControlWindow(ObjPtr, char *);
Bool DoShowPanel(void);
Bool DoHidePanel(void);
void DoMakeLocalCopy(void);
#else
WinInfoPtr NewVisWindow();
ObjPtr FindMainCorral();
void VisObjects();
void VisObjectsAs();
ObjPtr FindSpace();
ObjPtr FindPanel();
ObjPtr FindPerspecControl();
void RotateOrthoWindow();
void RotateWindowTo();
void ShowPanel();
void HidePanel();
void DoShowControls();
void ShearOrthoWindow();
void DoShowClock();
ObjPtr VisIcon();
void InitVisWindows();
void KillVisWindows();
void ForAllVisWindows();
ObjPtr NewControlWindow();
Bool DoShowPanel();
Bool DoHidePanel();
void DoMakeLocalCopy();
#endif
