/*SciaNetworkManager.c
  Eric Pepke
  September 12, 1991

  SciAn Network Manager

  Run one of these in the background on each machine with SciAn clients.
*/

#include "Scian.h"
#include "ScianTypes.h"
#include "ScianSockets.h"

/*Line for mkmk*/
/*$cc -I/usr/include/bsd ScianNetworkManager.c -c $(CFLAGS)
*/

/*Values for socketState*/
#define NOTLISTENING	0		/*Not even listening for a connection*/
#define LISTENING	1		/*Socket is listening for a connection*/
#define CONNECTED	2		/*Socket is connected*/

int socketState = NOTLISTENING; 
struct sockaddr_in templateAddr;	/*Socket template for listening*/
int template;
int sock;				/*Socket that is connected*/
FILE *sockFile;				/*Buffered file pointer for input*/
FILE *sockOutFile;			/*Buffered file pointer for output*/

#define CMD(s)  ((s)[0] * 16777216 + (s)[1] * 65536 + (s)[2] * 256 + (s)[3])

char tempStr[TEMPSTRSIZE + 1];

static void ReturnValue(val)
long val;
/*Returns value val*/
{
    fwrite(&val, sizeof(long), 1, sockOutFile);
    fflush(sockOutFile);
}

static u_short SocketPort()
/*Returns the port for the socket*/
{
    return htons((u_short) 21737);
}

static void DoSocketCommand(cmd)
long cmd;
/*Does command cmd*/
{
    if (cmd == CMD("bye "))
    {
	    /*Disconnect the socket*/
	    fclose(sockFile);
	    fclose(sockOutFile);
	    socketState = LISTENING;
    }
    else
    {
	ReturnValue(CMD("HUH?"));
    }
}

void IdleSockets()
/*Idles the sockets*/
{
    int proto;
    char command[256];
    char *cPtr, *dPtr;

    switch (socketState)
    {
	case NOTLISTENING:
	    /*Initialize internet socket template to internet, any machine*/
	    templateAddr . sin_port = SocketPort();
	    templateAddr . sin_family = PF_INET;
	    templateAddr . sin_addr.s_addr = INADDR_ANY;

	    proto = getprotobyname("tcp") -> p_proto;
	    template = socket(PF_INET, SOCK_STREAM, proto);
	    if (template >= 0)
	    {
		int status;

		status = bind(template, &templateAddr, sizeof(templateAddr));
		if (status >= 0)
		{
		    /*Name was bound OK*/

		    /*Set socket to be non blocking*/
		    fcntl(template, F_SETFL, 
			fcntl(template, F_GETFL) | FNDELAY);

		    /*Listen for a maximum of 5 connections*/
		    listen(template, 5);

		    socketState = LISTENING;
		}
		else
		{
		    perror("IdleSockets");
		    return;
		}
	    }
	    else
	    {
		perror("IdleSockets");
		return;
	    }
	case LISTENING:
	    sock = accept(template, (struct sockaddr *) 0, (int *) 0);
	    if (sock != -1)
	    {
		sockFile = fdopen(sock, "r+");
		sockOutFile = fdopen(sock, "w");
		socketState = CONNECTED;
	    }
	    else
	    {
		return;
	    }
	case CONNECTED:
	    if (1 == fread(command, (unsigned) 1, 1, sockFile))
	    {
		if (command[0] != '\n')
		{
		    fgets(&(command[1]), 254, sockFile);
		    DoSocketCommand(CMD(command));
		}
	    }
	    break;
    }
}

main()
{
    for (;;)
    {
	IdleSockets();
    }
}
