/*ScianScrDump.c
  Eric Pepke
  May 22, 1991
  Screen dump pseudorecorder*/

#include "Scian.h"
#include "ScianTypes.h"
#include "ScianWindows.h"
#include "ScianIDs.h"
#include "ScianScrDump.h"
#include "ScianRecorders.h"

long curFrame = 0;

static ObjPtr ReturnTrue(object)
ObjPtr object;
/*Returns true*/
{
    return ObjTrue;
}

static ObjPtr PrepareToRecordScrDump(object, nFrames)
ObjPtr object;
long nFrames;
/*Prepares to record nframes*/
{
    curFrame = 0;
    return ObjTrue;
}

static ObjPtr SnapOneFrameScrDump(object)
ObjPtr object;
/*Do a screen dump of arbitrary size*/
{
    int x, y;

    GetScreenSize(&x, &y);
    sprintf(tempStr, "scrsave dump%04d.rgb 0 %d 0 %d", 
		++curFrame, x, y);
    system(tempStr);
    return ObjTrue;
}

#ifdef PROTO
void InitScrDump(void)
#else
void InitScrDump()
#endif
/*Create a new screen dump ersatz recorder*/
{
    ObjPtr recorder;

    recorder = NewRecorder(NULLOBJ, "scrsave", "IRIS rgb");
    SetMethod(recorder, CONNECT, ReturnTrue);
    SetMethod(recorder, DISCONNECT, ReturnTrue);
    SetMethod(recorder, PREPARETORECORD, PrepareToRecordScrDump);
    SetMethod(recorder, STOPRECORDING, ReturnTrue);
    SetMethod(recorder, SNAPONEFRAME, SnapOneFrameScrDump);
    RegisterRecorder(recorder);
}

#ifdef PROTO
void KillScrDump(void)
#else
void KillScrDump()
#endif
{
}
