/*ScianRecorder.h
  Public stuff for ScianRecorder.c
  Eric Pepke
*/

extern ObjPtr commRecorderClass;

/*Baud rates*/
#define RB_300		0
#define RB_1200		1
#define RB_2400		2
#define RB_4800		3
#define RB_9600		4
#define RB_19200	5

#ifdef PROTO
void InitRecorders(void);
void KillRecorders(void);
Bool ConnectRecorder(void);
Bool PrepareToRecord(int);
void DisconnectRecorder(void);
Bool StopRecording(void);
Bool SetRecorder(char *);
void SetFPS(real);
void SetScreenSize(int, int);
void GetScreenSize(int *, int *);
ObjPtr NewRecorder(ObjPtr, char *, char *);
void RegisterRecorder(ObjPtr);
WinInfoPtr AnimationControlsWindow(void);
WinInfoPtr RecorderDriversWindow(void);
#else
Bool ConnectRecorder();
Bool PrepareToRecord();
void DisconnectRecorder();
void InitRecorders();
void KillRecorders();
Bool StopRecording(); 
Bool SetRecorder();
void SetFPS();
void SetScreenSize();
void GetScreenSize();
ObjPtr NewRecorder();
void RegisterRecorder();
WinInfoPtr AnimationControlsWindow();
WinInfoPtr RecorderDriversWindow();
#endif
